/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3vectors.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutVectorsRequest extends S3VectorsRequest implements
        ToCopyableBuilder<PutVectorsRequest.Builder, PutVectorsRequest> {
    private static final SdkField<String> VECTOR_BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vectorBucketName").getter(getter(PutVectorsRequest::vectorBucketName))
            .setter(setter(Builder::vectorBucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vectorBucketName").build()).build();

    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("indexName").getter(getter(PutVectorsRequest::indexName)).setter(setter(Builder::indexName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indexName").build()).build();

    private static final SdkField<String> INDEX_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("indexArn").getter(getter(PutVectorsRequest::indexArn)).setter(setter(Builder::indexArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indexArn").build()).build();

    private static final SdkField<List<PutInputVector>> VECTORS_FIELD = SdkField
            .<List<PutInputVector>> builder(MarshallingType.LIST)
            .memberName("vectors")
            .getter(getter(PutVectorsRequest::vectors))
            .setter(setter(Builder::vectors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vectors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PutInputVector> builder(MarshallingType.SDK_POJO)
                                            .constructor(PutInputVector::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VECTOR_BUCKET_NAME_FIELD,
            INDEX_NAME_FIELD, INDEX_ARN_FIELD, VECTORS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String vectorBucketName;

    private final String indexName;

    private final String indexArn;

    private final List<PutInputVector> vectors;

    private PutVectorsRequest(BuilderImpl builder) {
        super(builder);
        this.vectorBucketName = builder.vectorBucketName;
        this.indexName = builder.indexName;
        this.indexArn = builder.indexArn;
        this.vectors = builder.vectors;
    }

    /**
     * <p>
     * The name of the vector bucket that contains the vector index.
     * </p>
     * 
     * @return The name of the vector bucket that contains the vector index.
     */
    public final String vectorBucketName() {
        return vectorBucketName;
    }

    /**
     * <p>
     * The name of the vector index where you want to write vectors.
     * </p>
     * 
     * @return The name of the vector index where you want to write vectors.
     */
    public final String indexName() {
        return indexName;
    }

    /**
     * <p>
     * The ARN of the vector index where you want to write vectors.
     * </p>
     * 
     * @return The ARN of the vector index where you want to write vectors.
     */
    public final String indexArn() {
        return indexArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Vectors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasVectors() {
        return vectors != null && !(vectors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The vectors to add to a vector index. The number of vectors in a single request must not exceed the resource
     * capacity, otherwise the request will be rejected with the error <code>ServiceUnavailableException</code> with the
     * error message "Currently unable to handle the request".
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVectors} method.
     * </p>
     * 
     * @return The vectors to add to a vector index. The number of vectors in a single request must not exceed the
     *         resource capacity, otherwise the request will be rejected with the error
     *         <code>ServiceUnavailableException</code> with the error message "Currently unable to handle the request".
     */
    public final List<PutInputVector> vectors() {
        return vectors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(vectorBucketName());
        hashCode = 31 * hashCode + Objects.hashCode(indexName());
        hashCode = 31 * hashCode + Objects.hashCode(indexArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasVectors() ? vectors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutVectorsRequest)) {
            return false;
        }
        PutVectorsRequest other = (PutVectorsRequest) obj;
        return Objects.equals(vectorBucketName(), other.vectorBucketName()) && Objects.equals(indexName(), other.indexName())
                && Objects.equals(indexArn(), other.indexArn()) && hasVectors() == other.hasVectors()
                && Objects.equals(vectors(), other.vectors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutVectorsRequest").add("VectorBucketName", vectorBucketName()).add("IndexName", indexName())
                .add("IndexArn", indexArn()).add("Vectors", hasVectors() ? vectors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "vectorBucketName":
            return Optional.ofNullable(clazz.cast(vectorBucketName()));
        case "indexName":
            return Optional.ofNullable(clazz.cast(indexName()));
        case "indexArn":
            return Optional.ofNullable(clazz.cast(indexArn()));
        case "vectors":
            return Optional.ofNullable(clazz.cast(vectors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("vectorBucketName", VECTOR_BUCKET_NAME_FIELD);
        map.put("indexName", INDEX_NAME_FIELD);
        map.put("indexArn", INDEX_ARN_FIELD);
        map.put("vectors", VECTORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutVectorsRequest, T> g) {
        return obj -> g.apply((PutVectorsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends S3VectorsRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutVectorsRequest> {
        /**
         * <p>
         * The name of the vector bucket that contains the vector index.
         * </p>
         * 
         * @param vectorBucketName
         *        The name of the vector bucket that contains the vector index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vectorBucketName(String vectorBucketName);

        /**
         * <p>
         * The name of the vector index where you want to write vectors.
         * </p>
         * 
         * @param indexName
         *        The name of the vector index where you want to write vectors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexName(String indexName);

        /**
         * <p>
         * The ARN of the vector index where you want to write vectors.
         * </p>
         * 
         * @param indexArn
         *        The ARN of the vector index where you want to write vectors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexArn(String indexArn);

        /**
         * <p>
         * The vectors to add to a vector index. The number of vectors in a single request must not exceed the resource
         * capacity, otherwise the request will be rejected with the error <code>ServiceUnavailableException</code> with
         * the error message "Currently unable to handle the request".
         * </p>
         * 
         * @param vectors
         *        The vectors to add to a vector index. The number of vectors in a single request must not exceed the
         *        resource capacity, otherwise the request will be rejected with the error
         *        <code>ServiceUnavailableException</code> with the error message
         *        "Currently unable to handle the request".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vectors(Collection<PutInputVector> vectors);

        /**
         * <p>
         * The vectors to add to a vector index. The number of vectors in a single request must not exceed the resource
         * capacity, otherwise the request will be rejected with the error <code>ServiceUnavailableException</code> with
         * the error message "Currently unable to handle the request".
         * </p>
         * 
         * @param vectors
         *        The vectors to add to a vector index. The number of vectors in a single request must not exceed the
         *        resource capacity, otherwise the request will be rejected with the error
         *        <code>ServiceUnavailableException</code> with the error message
         *        "Currently unable to handle the request".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vectors(PutInputVector... vectors);

        /**
         * <p>
         * The vectors to add to a vector index. The number of vectors in a single request must not exceed the resource
         * capacity, otherwise the request will be rejected with the error <code>ServiceUnavailableException</code> with
         * the error message "Currently unable to handle the request".
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.s3vectors.model.PutInputVector.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.s3vectors.model.PutInputVector#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.s3vectors.model.PutInputVector.Builder#build()} is called immediately
         * and its result is passed to {@link #vectors(List<PutInputVector>)}.
         * 
         * @param vectors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.s3vectors.model.PutInputVector.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vectors(java.util.Collection<PutInputVector>)
         */
        Builder vectors(Consumer<PutInputVector.Builder>... vectors);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends S3VectorsRequest.BuilderImpl implements Builder {
        private String vectorBucketName;

        private String indexName;

        private String indexArn;

        private List<PutInputVector> vectors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutVectorsRequest model) {
            super(model);
            vectorBucketName(model.vectorBucketName);
            indexName(model.indexName);
            indexArn(model.indexArn);
            vectors(model.vectors);
        }

        public final String getVectorBucketName() {
            return vectorBucketName;
        }

        public final void setVectorBucketName(String vectorBucketName) {
            this.vectorBucketName = vectorBucketName;
        }

        @Override
        public final Builder vectorBucketName(String vectorBucketName) {
            this.vectorBucketName = vectorBucketName;
            return this;
        }

        public final String getIndexName() {
            return indexName;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final String getIndexArn() {
            return indexArn;
        }

        public final void setIndexArn(String indexArn) {
            this.indexArn = indexArn;
        }

        @Override
        public final Builder indexArn(String indexArn) {
            this.indexArn = indexArn;
            return this;
        }

        public final List<PutInputVector.Builder> getVectors() {
            List<PutInputVector.Builder> result = PutVectorsInputListCopier.copyToBuilder(this.vectors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVectors(Collection<PutInputVector.BuilderImpl> vectors) {
            this.vectors = PutVectorsInputListCopier.copyFromBuilder(vectors);
        }

        @Override
        public final Builder vectors(Collection<PutInputVector> vectors) {
            this.vectors = PutVectorsInputListCopier.copy(vectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vectors(PutInputVector... vectors) {
            vectors(Arrays.asList(vectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vectors(Consumer<PutInputVector.Builder>... vectors) {
            vectors(Stream.of(vectors).map(c -> PutInputVector.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutVectorsRequest build() {
            return new PutVectorsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
