/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3vectors.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListVectorBucketsResponse extends S3VectorsResponse implements
        ToCopyableBuilder<ListVectorBucketsResponse.Builder, ListVectorBucketsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListVectorBucketsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<VectorBucketSummary>> VECTOR_BUCKETS_FIELD = SdkField
            .<List<VectorBucketSummary>> builder(MarshallingType.LIST)
            .memberName("vectorBuckets")
            .getter(getter(ListVectorBucketsResponse::vectorBuckets))
            .setter(setter(Builder::vectorBuckets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vectorBuckets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VectorBucketSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(VectorBucketSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            VECTOR_BUCKETS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<VectorBucketSummary> vectorBuckets;

    private ListVectorBucketsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.vectorBuckets = builder.vectorBuckets;
    }

    /**
     * <p>
     * The element is included in the response when there are more buckets to be listed with pagination.
     * </p>
     * 
     * @return The element is included in the response when there are more buckets to be listed with pagination.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the VectorBuckets property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVectorBuckets() {
        return vectorBuckets != null && !(vectorBuckets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of vector buckets owned by the requester.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVectorBuckets} method.
     * </p>
     * 
     * @return The list of vector buckets owned by the requester.
     */
    public final List<VectorBucketSummary> vectorBuckets() {
        return vectorBuckets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasVectorBuckets() ? vectorBuckets() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVectorBucketsResponse)) {
            return false;
        }
        ListVectorBucketsResponse other = (ListVectorBucketsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasVectorBuckets() == other.hasVectorBuckets()
                && Objects.equals(vectorBuckets(), other.vectorBuckets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListVectorBucketsResponse").add("NextToken", nextToken())
                .add("VectorBuckets", hasVectorBuckets() ? vectorBuckets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "vectorBuckets":
            return Optional.ofNullable(clazz.cast(vectorBuckets()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("vectorBuckets", VECTOR_BUCKETS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListVectorBucketsResponse, T> g) {
        return obj -> g.apply((ListVectorBucketsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends S3VectorsResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListVectorBucketsResponse> {
        /**
         * <p>
         * The element is included in the response when there are more buckets to be listed with pagination.
         * </p>
         * 
         * @param nextToken
         *        The element is included in the response when there are more buckets to be listed with pagination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The list of vector buckets owned by the requester.
         * </p>
         * 
         * @param vectorBuckets
         *        The list of vector buckets owned by the requester.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vectorBuckets(Collection<VectorBucketSummary> vectorBuckets);

        /**
         * <p>
         * The list of vector buckets owned by the requester.
         * </p>
         * 
         * @param vectorBuckets
         *        The list of vector buckets owned by the requester.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vectorBuckets(VectorBucketSummary... vectorBuckets);

        /**
         * <p>
         * The list of vector buckets owned by the requester.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.s3vectors.model.VectorBucketSummary.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.s3vectors.model.VectorBucketSummary#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.s3vectors.model.VectorBucketSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #vectorBuckets(List<VectorBucketSummary>)}.
         * 
         * @param vectorBuckets
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.s3vectors.model.VectorBucketSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vectorBuckets(java.util.Collection<VectorBucketSummary>)
         */
        Builder vectorBuckets(Consumer<VectorBucketSummary.Builder>... vectorBuckets);
    }

    static final class BuilderImpl extends S3VectorsResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<VectorBucketSummary> vectorBuckets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListVectorBucketsResponse model) {
            super(model);
            nextToken(model.nextToken);
            vectorBuckets(model.vectorBuckets);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<VectorBucketSummary.Builder> getVectorBuckets() {
            List<VectorBucketSummary.Builder> result = ListVectorBucketsOutputListCopier.copyToBuilder(this.vectorBuckets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVectorBuckets(Collection<VectorBucketSummary.BuilderImpl> vectorBuckets) {
            this.vectorBuckets = ListVectorBucketsOutputListCopier.copyFromBuilder(vectorBuckets);
        }

        @Override
        public final Builder vectorBuckets(Collection<VectorBucketSummary> vectorBuckets) {
            this.vectorBuckets = ListVectorBucketsOutputListCopier.copy(vectorBuckets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vectorBuckets(VectorBucketSummary... vectorBuckets) {
            vectorBuckets(Arrays.asList(vectorBuckets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vectorBuckets(Consumer<VectorBucketSummary.Builder>... vectorBuckets) {
            vectorBuckets(Stream.of(vectorBuckets).map(c -> VectorBucketSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListVectorBucketsResponse build() {
            return new ListVectorBucketsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
