/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3tables.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.s3tables.model.ManagedTableInformation;
import software.amazon.awssdk.services.s3tables.model.NamespaceListCopier;
import software.amazon.awssdk.services.s3tables.model.OpenTableFormat;
import software.amazon.awssdk.services.s3tables.model.S3TablesResponse;
import software.amazon.awssdk.services.s3tables.model.TableType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTableResponse
extends S3TablesResponse
implements ToCopyableBuilder<Builder, GetTableResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetTableResponse.getter(GetTableResponse::name)).setter(GetTableResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(GetTableResponse.getter(GetTableResponse::typeAsString)).setter(GetTableResponse.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> TABLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tableARN").getter(GetTableResponse.getter(GetTableResponse::tableARN)).setter(GetTableResponse.setter(Builder::tableARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tableARN").build()}).build();
    private static final SdkField<List<String>> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("namespace").getter(GetTableResponse.getter(GetTableResponse::namespace)).setter(GetTableResponse.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespace").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAMESPACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("namespaceId").getter(GetTableResponse.getter(GetTableResponse::namespaceId)).setter(GetTableResponse.setter(Builder::namespaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceId").build()}).build();
    private static final SdkField<String> VERSION_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("versionToken").getter(GetTableResponse.getter(GetTableResponse::versionToken)).setter(GetTableResponse.setter(Builder::versionToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionToken").build()}).build();
    private static final SdkField<String> METADATA_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("metadataLocation").getter(GetTableResponse.getter(GetTableResponse::metadataLocation)).setter(GetTableResponse.setter(Builder::metadataLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadataLocation").build()}).build();
    private static final SdkField<String> WAREHOUSE_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("warehouseLocation").getter(GetTableResponse.getter(GetTableResponse::warehouseLocation)).setter(GetTableResponse.setter(Builder::warehouseLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("warehouseLocation").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(GetTableResponse.getter(GetTableResponse::createdAt)).setter(GetTableResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("createdBy").getter(GetTableResponse.getter(GetTableResponse::createdBy)).setter(GetTableResponse.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()}).build();
    private static final SdkField<String> MANAGED_BY_SERVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("managedByService").getter(GetTableResponse.getter(GetTableResponse::managedByService)).setter(GetTableResponse.setter(Builder::managedByService)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedByService").build()}).build();
    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("modifiedAt").getter(GetTableResponse.getter(GetTableResponse::modifiedAt)).setter(GetTableResponse.setter(Builder::modifiedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modifiedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> MODIFIED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modifiedBy").getter(GetTableResponse.getter(GetTableResponse::modifiedBy)).setter(GetTableResponse.setter(Builder::modifiedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modifiedBy").build()}).build();
    private static final SdkField<String> OWNER_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ownerAccountId").getter(GetTableResponse.getter(GetTableResponse::ownerAccountId)).setter(GetTableResponse.setter(Builder::ownerAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownerAccountId").build()}).build();
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("format").getter(GetTableResponse.getter(GetTableResponse::formatAsString)).setter(GetTableResponse.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()}).build();
    private static final SdkField<String> TABLE_BUCKET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tableBucketId").getter(GetTableResponse.getter(GetTableResponse::tableBucketId)).setter(GetTableResponse.setter(Builder::tableBucketId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tableBucketId").build()}).build();
    private static final SdkField<ManagedTableInformation> MANAGED_TABLE_INFORMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("managedTableInformation").getter(GetTableResponse.getter(GetTableResponse::managedTableInformation)).setter(GetTableResponse.setter(Builder::managedTableInformation)).constructor(ManagedTableInformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedTableInformation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TYPE_FIELD, TABLE_ARN_FIELD, NAMESPACE_FIELD, NAMESPACE_ID_FIELD, VERSION_TOKEN_FIELD, METADATA_LOCATION_FIELD, WAREHOUSE_LOCATION_FIELD, CREATED_AT_FIELD, CREATED_BY_FIELD, MANAGED_BY_SERVICE_FIELD, MODIFIED_AT_FIELD, MODIFIED_BY_FIELD, OWNER_ACCOUNT_ID_FIELD, FORMAT_FIELD, TABLE_BUCKET_ID_FIELD, MANAGED_TABLE_INFORMATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetTableResponse.memberNameToFieldInitializer();
    private final String name;
    private final String type;
    private final String tableARN;
    private final List<String> namespace;
    private final String namespaceId;
    private final String versionToken;
    private final String metadataLocation;
    private final String warehouseLocation;
    private final Instant createdAt;
    private final String createdBy;
    private final String managedByService;
    private final Instant modifiedAt;
    private final String modifiedBy;
    private final String ownerAccountId;
    private final String format;
    private final String tableBucketId;
    private final ManagedTableInformation managedTableInformation;

    private GetTableResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.type = builder.type;
        this.tableARN = builder.tableARN;
        this.namespace = builder.namespace;
        this.namespaceId = builder.namespaceId;
        this.versionToken = builder.versionToken;
        this.metadataLocation = builder.metadataLocation;
        this.warehouseLocation = builder.warehouseLocation;
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.managedByService = builder.managedByService;
        this.modifiedAt = builder.modifiedAt;
        this.modifiedBy = builder.modifiedBy;
        this.ownerAccountId = builder.ownerAccountId;
        this.format = builder.format;
        this.tableBucketId = builder.tableBucketId;
        this.managedTableInformation = builder.managedTableInformation;
    }

    public final String name() {
        return this.name;
    }

    public final TableType type() {
        return TableType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String tableARN() {
        return this.tableARN;
    }

    public final boolean hasNamespace() {
        return this.namespace != null && !(this.namespace instanceof SdkAutoConstructList);
    }

    public final List<String> namespace() {
        return this.namespace;
    }

    public final String namespaceId() {
        return this.namespaceId;
    }

    public final String versionToken() {
        return this.versionToken;
    }

    public final String metadataLocation() {
        return this.metadataLocation;
    }

    public final String warehouseLocation() {
        return this.warehouseLocation;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final String managedByService() {
        return this.managedByService;
    }

    public final Instant modifiedAt() {
        return this.modifiedAt;
    }

    public final String modifiedBy() {
        return this.modifiedBy;
    }

    public final String ownerAccountId() {
        return this.ownerAccountId;
    }

    public final OpenTableFormat format() {
        return OpenTableFormat.fromValue(this.format);
    }

    public final String formatAsString() {
        return this.format;
    }

    public final String tableBucketId() {
        return this.tableBucketId;
    }

    public final ManagedTableInformation managedTableInformation() {
        return this.managedTableInformation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNamespace() ? this.namespace() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.namespaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadataLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.warehouseLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.managedByService());
        hashCode = 31 * hashCode + Objects.hashCode(this.modifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.modifiedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableBucketId());
        hashCode = 31 * hashCode + Objects.hashCode(this.managedTableInformation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTableResponse)) {
            return false;
        }
        GetTableResponse other = (GetTableResponse)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.tableARN(), other.tableARN()) && this.hasNamespace() == other.hasNamespace() && Objects.equals(this.namespace(), other.namespace()) && Objects.equals(this.namespaceId(), other.namespaceId()) && Objects.equals(this.versionToken(), other.versionToken()) && Objects.equals(this.metadataLocation(), other.metadataLocation()) && Objects.equals(this.warehouseLocation(), other.warehouseLocation()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.managedByService(), other.managedByService()) && Objects.equals(this.modifiedAt(), other.modifiedAt()) && Objects.equals(this.modifiedBy(), other.modifiedBy()) && Objects.equals(this.ownerAccountId(), other.ownerAccountId()) && Objects.equals(this.formatAsString(), other.formatAsString()) && Objects.equals(this.tableBucketId(), other.tableBucketId()) && Objects.equals(this.managedTableInformation(), other.managedTableInformation());
    }

    public final String toString() {
        return ToString.builder((String)"GetTableResponse").add("Name", (Object)this.name()).add("Type", (Object)this.typeAsString()).add("TableARN", (Object)this.tableARN()).add("Namespace", this.hasNamespace() ? this.namespace() : null).add("NamespaceId", (Object)this.namespaceId()).add("VersionToken", (Object)this.versionToken()).add("MetadataLocation", (Object)this.metadataLocation()).add("WarehouseLocation", (Object)this.warehouseLocation()).add("CreatedAt", (Object)this.createdAt()).add("CreatedBy", (Object)this.createdBy()).add("ManagedByService", (Object)this.managedByService()).add("ModifiedAt", (Object)this.modifiedAt()).add("ModifiedBy", (Object)this.modifiedBy()).add("OwnerAccountId", (Object)this.ownerAccountId()).add("Format", (Object)this.formatAsString()).add("TableBucketId", (Object)this.tableBucketId()).add("ManagedTableInformation", (Object)this.managedTableInformation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "tableARN": {
                return Optional.ofNullable(clazz.cast(this.tableARN()));
            }
            case "namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
            case "namespaceId": {
                return Optional.ofNullable(clazz.cast(this.namespaceId()));
            }
            case "versionToken": {
                return Optional.ofNullable(clazz.cast(this.versionToken()));
            }
            case "metadataLocation": {
                return Optional.ofNullable(clazz.cast(this.metadataLocation()));
            }
            case "warehouseLocation": {
                return Optional.ofNullable(clazz.cast(this.warehouseLocation()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "createdBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "managedByService": {
                return Optional.ofNullable(clazz.cast(this.managedByService()));
            }
            case "modifiedAt": {
                return Optional.ofNullable(clazz.cast(this.modifiedAt()));
            }
            case "modifiedBy": {
                return Optional.ofNullable(clazz.cast(this.modifiedBy()));
            }
            case "ownerAccountId": {
                return Optional.ofNullable(clazz.cast(this.ownerAccountId()));
            }
            case "format": {
                return Optional.ofNullable(clazz.cast(this.formatAsString()));
            }
            case "tableBucketId": {
                return Optional.ofNullable(clazz.cast(this.tableBucketId()));
            }
            case "managedTableInformation": {
                return Optional.ofNullable(clazz.cast(this.managedTableInformation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("tableARN", TABLE_ARN_FIELD);
        map.put("namespace", NAMESPACE_FIELD);
        map.put("namespaceId", NAMESPACE_ID_FIELD);
        map.put("versionToken", VERSION_TOKEN_FIELD);
        map.put("metadataLocation", METADATA_LOCATION_FIELD);
        map.put("warehouseLocation", WAREHOUSE_LOCATION_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("createdBy", CREATED_BY_FIELD);
        map.put("managedByService", MANAGED_BY_SERVICE_FIELD);
        map.put("modifiedAt", MODIFIED_AT_FIELD);
        map.put("modifiedBy", MODIFIED_BY_FIELD);
        map.put("ownerAccountId", OWNER_ACCOUNT_ID_FIELD);
        map.put("format", FORMAT_FIELD);
        map.put("tableBucketId", TABLE_BUCKET_ID_FIELD);
        map.put("managedTableInformation", MANAGED_TABLE_INFORMATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTableResponse, T> g) {
        return obj -> g.apply((GetTableResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3TablesResponse.BuilderImpl
    implements Builder {
        private String name;
        private String type;
        private String tableARN;
        private List<String> namespace = DefaultSdkAutoConstructList.getInstance();
        private String namespaceId;
        private String versionToken;
        private String metadataLocation;
        private String warehouseLocation;
        private Instant createdAt;
        private String createdBy;
        private String managedByService;
        private Instant modifiedAt;
        private String modifiedBy;
        private String ownerAccountId;
        private String format;
        private String tableBucketId;
        private ManagedTableInformation managedTableInformation;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTableResponse model) {
            super(model);
            this.name(model.name);
            this.type(model.type);
            this.tableARN(model.tableARN);
            this.namespace(model.namespace);
            this.namespaceId(model.namespaceId);
            this.versionToken(model.versionToken);
            this.metadataLocation(model.metadataLocation);
            this.warehouseLocation(model.warehouseLocation);
            this.createdAt(model.createdAt);
            this.createdBy(model.createdBy);
            this.managedByService(model.managedByService);
            this.modifiedAt(model.modifiedAt);
            this.modifiedBy(model.modifiedBy);
            this.ownerAccountId(model.ownerAccountId);
            this.format(model.format);
            this.tableBucketId(model.tableBucketId);
            this.managedTableInformation(model.managedTableInformation);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(TableType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getTableARN() {
            return this.tableARN;
        }

        public final void setTableARN(String tableARN) {
            this.tableARN = tableARN;
        }

        @Override
        public final Builder tableARN(String tableARN) {
            this.tableARN = tableARN;
            return this;
        }

        public final Collection<String> getNamespace() {
            if (this.namespace instanceof SdkAutoConstructList) {
                return null;
            }
            return this.namespace;
        }

        public final void setNamespace(Collection<String> namespace) {
            this.namespace = NamespaceListCopier.copy(namespace);
        }

        @Override
        public final Builder namespace(Collection<String> namespace) {
            this.namespace = NamespaceListCopier.copy(namespace);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder namespace(String ... namespace) {
            this.namespace(Arrays.asList(namespace));
            return this;
        }

        public final String getNamespaceId() {
            return this.namespaceId;
        }

        public final void setNamespaceId(String namespaceId) {
            this.namespaceId = namespaceId;
        }

        @Override
        public final Builder namespaceId(String namespaceId) {
            this.namespaceId = namespaceId;
            return this;
        }

        public final String getVersionToken() {
            return this.versionToken;
        }

        public final void setVersionToken(String versionToken) {
            this.versionToken = versionToken;
        }

        @Override
        public final Builder versionToken(String versionToken) {
            this.versionToken = versionToken;
            return this;
        }

        public final String getMetadataLocation() {
            return this.metadataLocation;
        }

        public final void setMetadataLocation(String metadataLocation) {
            this.metadataLocation = metadataLocation;
        }

        @Override
        public final Builder metadataLocation(String metadataLocation) {
            this.metadataLocation = metadataLocation;
            return this;
        }

        public final String getWarehouseLocation() {
            return this.warehouseLocation;
        }

        public final void setWarehouseLocation(String warehouseLocation) {
            this.warehouseLocation = warehouseLocation;
        }

        @Override
        public final Builder warehouseLocation(String warehouseLocation) {
            this.warehouseLocation = warehouseLocation;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getManagedByService() {
            return this.managedByService;
        }

        public final void setManagedByService(String managedByService) {
            this.managedByService = managedByService;
        }

        @Override
        public final Builder managedByService(String managedByService) {
            this.managedByService = managedByService;
            return this;
        }

        public final Instant getModifiedAt() {
            return this.modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public final String getModifiedBy() {
            return this.modifiedBy;
        }

        public final void setModifiedBy(String modifiedBy) {
            this.modifiedBy = modifiedBy;
        }

        @Override
        public final Builder modifiedBy(String modifiedBy) {
            this.modifiedBy = modifiedBy;
            return this;
        }

        public final String getOwnerAccountId() {
            return this.ownerAccountId;
        }

        public final void setOwnerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
        }

        @Override
        public final Builder ownerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
            return this;
        }

        public final String getFormat() {
            return this.format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(OpenTableFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final String getTableBucketId() {
            return this.tableBucketId;
        }

        public final void setTableBucketId(String tableBucketId) {
            this.tableBucketId = tableBucketId;
        }

        @Override
        public final Builder tableBucketId(String tableBucketId) {
            this.tableBucketId = tableBucketId;
            return this;
        }

        public final ManagedTableInformation.Builder getManagedTableInformation() {
            return this.managedTableInformation != null ? this.managedTableInformation.toBuilder() : null;
        }

        public final void setManagedTableInformation(ManagedTableInformation.BuilderImpl managedTableInformation) {
            this.managedTableInformation = managedTableInformation != null ? managedTableInformation.build() : null;
        }

        @Override
        public final Builder managedTableInformation(ManagedTableInformation managedTableInformation) {
            this.managedTableInformation = managedTableInformation;
            return this;
        }

        @Override
        public GetTableResponse build() {
            return new GetTableResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends S3TablesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTableResponse> {
        public Builder name(String var1);

        public Builder type(String var1);

        public Builder type(TableType var1);

        public Builder tableARN(String var1);

        public Builder namespace(Collection<String> var1);

        public Builder namespace(String ... var1);

        public Builder namespaceId(String var1);

        public Builder versionToken(String var1);

        public Builder metadataLocation(String var1);

        public Builder warehouseLocation(String var1);

        public Builder createdAt(Instant var1);

        public Builder createdBy(String var1);

        public Builder managedByService(String var1);

        public Builder modifiedAt(Instant var1);

        public Builder modifiedBy(String var1);

        public Builder ownerAccountId(String var1);

        public Builder format(String var1);

        public Builder format(OpenTableFormat var1);

        public Builder tableBucketId(String var1);

        public Builder managedTableInformation(ManagedTableInformation var1);

        default public Builder managedTableInformation(Consumer<ManagedTableInformation.Builder> managedTableInformation) {
            return this.managedTableInformation((ManagedTableInformation)((ManagedTableInformation.Builder)ManagedTableInformation.builder().applyMutation(managedTableInformation)).build());
        }
    }
}

