/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3tables.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.s3tables.S3TablesClient;
import software.amazon.awssdk.services.s3tables.internal.UserAgentUtils;
import software.amazon.awssdk.services.s3tables.model.ListTablesRequest;
import software.amazon.awssdk.services.s3tables.model.ListTablesResponse;
import software.amazon.awssdk.services.s3tables.model.TableSummary;

public class ListTablesIterable
implements SdkIterable<ListTablesResponse> {
    private final S3TablesClient client;
    private final ListTablesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTablesIterable(S3TablesClient client, ListTablesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTablesResponseFetcher();
    }

    public Iterator<ListTablesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TableSummary> tables() {
        Function<ListTablesResponse, Iterator> getIterator = response -> {
            if (response != null && response.tables() != null) {
                return response.tables().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTablesResponseFetcher
    implements SyncPageFetcher<ListTablesResponse> {
        private ListTablesResponseFetcher() {
        }

        public boolean hasNextPage(ListTablesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.continuationToken());
        }

        public ListTablesResponse nextPage(ListTablesResponse previousPage) {
            if (previousPage == null) {
                return ListTablesIterable.this.client.listTables(ListTablesIterable.this.firstRequest);
            }
            return ListTablesIterable.this.client.listTables((ListTablesRequest)((Object)ListTablesIterable.this.firstRequest.toBuilder().continuationToken(previousPage.continuationToken()).build()));
        }
    }
}

