/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3tables.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3tables.model.S3TablesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTableBucketsRequest
extends S3TablesRequest
implements ToCopyableBuilder<Builder, ListTableBucketsRequest> {
    private static final SdkField<String> PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("prefix").getter(ListTableBucketsRequest.getter(ListTableBucketsRequest::prefix)).setter(ListTableBucketsRequest.setter(Builder::prefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("prefix").build()}).build();
    private static final SdkField<String> CONTINUATION_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("continuationToken").getter(ListTableBucketsRequest.getter(ListTableBucketsRequest::continuationToken)).setter(ListTableBucketsRequest.setter(Builder::continuationToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("continuationToken").build()}).build();
    private static final SdkField<Integer> MAX_BUCKETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxBuckets").getter(ListTableBucketsRequest.getter(ListTableBucketsRequest::maxBuckets)).setter(ListTableBucketsRequest.setter(Builder::maxBuckets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxBuckets").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREFIX_FIELD, CONTINUATION_TOKEN_FIELD, MAX_BUCKETS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListTableBucketsRequest.memberNameToFieldInitializer();
    private final String prefix;
    private final String continuationToken;
    private final Integer maxBuckets;

    private ListTableBucketsRequest(BuilderImpl builder) {
        super(builder);
        this.prefix = builder.prefix;
        this.continuationToken = builder.continuationToken;
        this.maxBuckets = builder.maxBuckets;
    }

    public final String prefix() {
        return this.prefix;
    }

    public final String continuationToken() {
        return this.continuationToken;
    }

    public final Integer maxBuckets() {
        return this.maxBuckets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.prefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.continuationToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxBuckets());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTableBucketsRequest)) {
            return false;
        }
        ListTableBucketsRequest other = (ListTableBucketsRequest)((Object)obj);
        return Objects.equals(this.prefix(), other.prefix()) && Objects.equals(this.continuationToken(), other.continuationToken()) && Objects.equals(this.maxBuckets(), other.maxBuckets());
    }

    public final String toString() {
        return ToString.builder((String)"ListTableBucketsRequest").add("Prefix", (Object)this.prefix()).add("ContinuationToken", (Object)this.continuationToken()).add("MaxBuckets", (Object)this.maxBuckets()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "prefix": {
                return Optional.ofNullable(clazz.cast(this.prefix()));
            }
            case "continuationToken": {
                return Optional.ofNullable(clazz.cast(this.continuationToken()));
            }
            case "maxBuckets": {
                return Optional.ofNullable(clazz.cast(this.maxBuckets()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("prefix", PREFIX_FIELD);
        map.put("continuationToken", CONTINUATION_TOKEN_FIELD);
        map.put("maxBuckets", MAX_BUCKETS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTableBucketsRequest, T> g) {
        return obj -> g.apply((ListTableBucketsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3TablesRequest.BuilderImpl
    implements Builder {
        private String prefix;
        private String continuationToken;
        private Integer maxBuckets;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTableBucketsRequest model) {
            super(model);
            this.prefix(model.prefix);
            this.continuationToken(model.continuationToken);
            this.maxBuckets(model.maxBuckets);
        }

        public final String getPrefix() {
            return this.prefix;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final String getContinuationToken() {
            return this.continuationToken;
        }

        public final void setContinuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
        }

        @Override
        public final Builder continuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
            return this;
        }

        public final Integer getMaxBuckets() {
            return this.maxBuckets;
        }

        public final void setMaxBuckets(Integer maxBuckets) {
            this.maxBuckets = maxBuckets;
        }

        @Override
        public final Builder maxBuckets(Integer maxBuckets) {
            this.maxBuckets = maxBuckets;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTableBucketsRequest build() {
            return new ListTableBucketsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends S3TablesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTableBucketsRequest> {
        public Builder prefix(String var1);

        public Builder continuationToken(String var1);

        public Builder maxBuckets(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

