/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3tables.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.s3tables.model.NamespaceListCopier;
import software.amazon.awssdk.services.s3tables.model.S3TablesResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateTableMetadataLocationResponse
extends S3TablesResponse
implements ToCopyableBuilder<Builder, UpdateTableMetadataLocationResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateTableMetadataLocationResponse.getter(UpdateTableMetadataLocationResponse::name)).setter(UpdateTableMetadataLocationResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> TABLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tableARN").getter(UpdateTableMetadataLocationResponse.getter(UpdateTableMetadataLocationResponse::tableARN)).setter(UpdateTableMetadataLocationResponse.setter(Builder::tableARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tableARN").build()}).build();
    private static final SdkField<List<String>> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("namespace").getter(UpdateTableMetadataLocationResponse.getter(UpdateTableMetadataLocationResponse::namespace)).setter(UpdateTableMetadataLocationResponse.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespace").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> VERSION_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("versionToken").getter(UpdateTableMetadataLocationResponse.getter(UpdateTableMetadataLocationResponse::versionToken)).setter(UpdateTableMetadataLocationResponse.setter(Builder::versionToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionToken").build()}).build();
    private static final SdkField<String> METADATA_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("metadataLocation").getter(UpdateTableMetadataLocationResponse.getter(UpdateTableMetadataLocationResponse::metadataLocation)).setter(UpdateTableMetadataLocationResponse.setter(Builder::metadataLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadataLocation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TABLE_ARN_FIELD, NAMESPACE_FIELD, VERSION_TOKEN_FIELD, METADATA_LOCATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateTableMetadataLocationResponse.memberNameToFieldInitializer();
    private final String name;
    private final String tableARN;
    private final List<String> namespace;
    private final String versionToken;
    private final String metadataLocation;

    private UpdateTableMetadataLocationResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.tableARN = builder.tableARN;
        this.namespace = builder.namespace;
        this.versionToken = builder.versionToken;
        this.metadataLocation = builder.metadataLocation;
    }

    public final String name() {
        return this.name;
    }

    public final String tableARN() {
        return this.tableARN;
    }

    public final boolean hasNamespace() {
        return this.namespace != null && !(this.namespace instanceof SdkAutoConstructList);
    }

    public final List<String> namespace() {
        return this.namespace;
    }

    public final String versionToken() {
        return this.versionToken;
    }

    public final String metadataLocation() {
        return this.metadataLocation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNamespace() ? this.namespace() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.versionToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadataLocation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTableMetadataLocationResponse)) {
            return false;
        }
        UpdateTableMetadataLocationResponse other = (UpdateTableMetadataLocationResponse)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.tableARN(), other.tableARN()) && this.hasNamespace() == other.hasNamespace() && Objects.equals(this.namespace(), other.namespace()) && Objects.equals(this.versionToken(), other.versionToken()) && Objects.equals(this.metadataLocation(), other.metadataLocation());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateTableMetadataLocationResponse").add("Name", (Object)this.name()).add("TableARN", (Object)this.tableARN()).add("Namespace", this.hasNamespace() ? this.namespace() : null).add("VersionToken", (Object)this.versionToken()).add("MetadataLocation", (Object)this.metadataLocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "tableARN": {
                return Optional.ofNullable(clazz.cast(this.tableARN()));
            }
            case "namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
            case "versionToken": {
                return Optional.ofNullable(clazz.cast(this.versionToken()));
            }
            case "metadataLocation": {
                return Optional.ofNullable(clazz.cast(this.metadataLocation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("tableARN", TABLE_ARN_FIELD);
        map.put("namespace", NAMESPACE_FIELD);
        map.put("versionToken", VERSION_TOKEN_FIELD);
        map.put("metadataLocation", METADATA_LOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateTableMetadataLocationResponse, T> g) {
        return obj -> g.apply((UpdateTableMetadataLocationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3TablesResponse.BuilderImpl
    implements Builder {
        private String name;
        private String tableARN;
        private List<String> namespace = DefaultSdkAutoConstructList.getInstance();
        private String versionToken;
        private String metadataLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTableMetadataLocationResponse model) {
            super(model);
            this.name(model.name);
            this.tableARN(model.tableARN);
            this.namespace(model.namespace);
            this.versionToken(model.versionToken);
            this.metadataLocation(model.metadataLocation);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getTableARN() {
            return this.tableARN;
        }

        public final void setTableARN(String tableARN) {
            this.tableARN = tableARN;
        }

        @Override
        public final Builder tableARN(String tableARN) {
            this.tableARN = tableARN;
            return this;
        }

        public final Collection<String> getNamespace() {
            if (this.namespace instanceof SdkAutoConstructList) {
                return null;
            }
            return this.namespace;
        }

        public final void setNamespace(Collection<String> namespace) {
            this.namespace = NamespaceListCopier.copy(namespace);
        }

        @Override
        public final Builder namespace(Collection<String> namespace) {
            this.namespace = NamespaceListCopier.copy(namespace);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder namespace(String ... namespace) {
            this.namespace(Arrays.asList(namespace));
            return this;
        }

        public final String getVersionToken() {
            return this.versionToken;
        }

        public final void setVersionToken(String versionToken) {
            this.versionToken = versionToken;
        }

        @Override
        public final Builder versionToken(String versionToken) {
            this.versionToken = versionToken;
            return this;
        }

        public final String getMetadataLocation() {
            return this.metadataLocation;
        }

        public final void setMetadataLocation(String metadataLocation) {
            this.metadataLocation = metadataLocation;
        }

        @Override
        public final Builder metadataLocation(String metadataLocation) {
            this.metadataLocation = metadataLocation;
            return this;
        }

        @Override
        public UpdateTableMetadataLocationResponse build() {
            return new UpdateTableMetadataLocationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends S3TablesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateTableMetadataLocationResponse> {
        public Builder name(String var1);

        public Builder tableARN(String var1);

        public Builder namespace(Collection<String> var1);

        public Builder namespace(String ... var1);

        public Builder versionToken(String var1);

        public Builder metadataLocation(String var1);
    }
}

