/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3tables.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.s3tables.model.S3TablesResponse;
import software.amazon.awssdk.services.s3tables.model.TableSummary;
import software.amazon.awssdk.services.s3tables.model.TableSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTablesResponse
extends S3TablesResponse
implements ToCopyableBuilder<Builder, ListTablesResponse> {
    private static final SdkField<List<TableSummary>> TABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tables").getter(ListTablesResponse.getter(ListTablesResponse::tables)).setter(ListTablesResponse.setter(Builder::tables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tables").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TableSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CONTINUATION_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("continuationToken").getter(ListTablesResponse.getter(ListTablesResponse::continuationToken)).setter(ListTablesResponse.setter(Builder::continuationToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("continuationToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLES_FIELD, CONTINUATION_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListTablesResponse.memberNameToFieldInitializer();
    private final List<TableSummary> tables;
    private final String continuationToken;

    private ListTablesResponse(BuilderImpl builder) {
        super(builder);
        this.tables = builder.tables;
        this.continuationToken = builder.continuationToken;
    }

    public final boolean hasTables() {
        return this.tables != null && !(this.tables instanceof SdkAutoConstructList);
    }

    public final List<TableSummary> tables() {
        return this.tables;
    }

    public final String continuationToken() {
        return this.continuationToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTables() ? this.tables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.continuationToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTablesResponse)) {
            return false;
        }
        ListTablesResponse other = (ListTablesResponse)((Object)obj);
        return this.hasTables() == other.hasTables() && Objects.equals(this.tables(), other.tables()) && Objects.equals(this.continuationToken(), other.continuationToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListTablesResponse").add("Tables", this.hasTables() ? this.tables() : null).add("ContinuationToken", (Object)this.continuationToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "tables": {
                return Optional.ofNullable(clazz.cast(this.tables()));
            }
            case "continuationToken": {
                return Optional.ofNullable(clazz.cast(this.continuationToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tables", TABLES_FIELD);
        map.put("continuationToken", CONTINUATION_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTablesResponse, T> g) {
        return obj -> g.apply((ListTablesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3TablesResponse.BuilderImpl
    implements Builder {
        private List<TableSummary> tables = DefaultSdkAutoConstructList.getInstance();
        private String continuationToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTablesResponse model) {
            super(model);
            this.tables(model.tables);
            this.continuationToken(model.continuationToken);
        }

        public final List<TableSummary.Builder> getTables() {
            List<TableSummary.Builder> result = TableSummaryListCopier.copyToBuilder(this.tables);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTables(Collection<TableSummary.BuilderImpl> tables) {
            this.tables = TableSummaryListCopier.copyFromBuilder(tables);
        }

        @Override
        public final Builder tables(Collection<TableSummary> tables) {
            this.tables = TableSummaryListCopier.copy(tables);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tables(TableSummary ... tables) {
            this.tables(Arrays.asList(tables));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tables(Consumer<TableSummary.Builder> ... tables) {
            this.tables(Stream.of(tables).map(c -> (TableSummary)((TableSummary.Builder)TableSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getContinuationToken() {
            return this.continuationToken;
        }

        public final void setContinuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
        }

        @Override
        public final Builder continuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
            return this;
        }

        @Override
        public ListTablesResponse build() {
            return new ListTablesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends S3TablesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTablesResponse> {
        public Builder tables(Collection<TableSummary> var1);

        public Builder tables(TableSummary ... var1);

        public Builder tables(Consumer<TableSummary.Builder> ... var1);

        public Builder continuationToken(String var1);
    }
}

