/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3tables.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.s3tables.model.S3TablesResponse;
import software.amazon.awssdk.services.s3tables.model.TableBucketMaintenanceConfigurationCopier;
import software.amazon.awssdk.services.s3tables.model.TableBucketMaintenanceConfigurationValue;
import software.amazon.awssdk.services.s3tables.model.TableBucketMaintenanceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTableBucketMaintenanceConfigurationResponse
extends S3TablesResponse
implements ToCopyableBuilder<Builder, GetTableBucketMaintenanceConfigurationResponse> {
    private static final SdkField<String> TABLE_BUCKET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tableBucketARN").getter(GetTableBucketMaintenanceConfigurationResponse.getter(GetTableBucketMaintenanceConfigurationResponse::tableBucketARN)).setter(GetTableBucketMaintenanceConfigurationResponse.setter(Builder::tableBucketARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tableBucketARN").build()}).build();
    private static final SdkField<Map<String, TableBucketMaintenanceConfigurationValue>> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("configuration").getter(GetTableBucketMaintenanceConfigurationResponse.getter(GetTableBucketMaintenanceConfigurationResponse::configurationAsStrings)).setter(GetTableBucketMaintenanceConfigurationResponse.setter(Builder::configurationWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TableBucketMaintenanceConfigurationValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_BUCKET_ARN_FIELD, CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetTableBucketMaintenanceConfigurationResponse.memberNameToFieldInitializer();
    private final String tableBucketARN;
    private final Map<String, TableBucketMaintenanceConfigurationValue> configuration;

    private GetTableBucketMaintenanceConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.tableBucketARN = builder.tableBucketARN;
        this.configuration = builder.configuration;
    }

    public final String tableBucketARN() {
        return this.tableBucketARN;
    }

    public final Map<TableBucketMaintenanceType, TableBucketMaintenanceConfigurationValue> configuration() {
        return TableBucketMaintenanceConfigurationCopier.copyStringToEnum(this.configuration);
    }

    public final boolean hasConfiguration() {
        return this.configuration != null && !(this.configuration instanceof SdkAutoConstructMap);
    }

    public final Map<String, TableBucketMaintenanceConfigurationValue> configurationAsStrings() {
        return this.configuration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.tableBucketARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfiguration() ? this.configurationAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTableBucketMaintenanceConfigurationResponse)) {
            return false;
        }
        GetTableBucketMaintenanceConfigurationResponse other = (GetTableBucketMaintenanceConfigurationResponse)((Object)obj);
        return Objects.equals(this.tableBucketARN(), other.tableBucketARN()) && this.hasConfiguration() == other.hasConfiguration() && Objects.equals(this.configurationAsStrings(), other.configurationAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"GetTableBucketMaintenanceConfigurationResponse").add("TableBucketARN", (Object)this.tableBucketARN()).add("Configuration", this.hasConfiguration() ? this.configurationAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "tableBucketARN": {
                return Optional.ofNullable(clazz.cast(this.tableBucketARN()));
            }
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configurationAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tableBucketARN", TABLE_BUCKET_ARN_FIELD);
        map.put("configuration", CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTableBucketMaintenanceConfigurationResponse, T> g) {
        return obj -> g.apply((GetTableBucketMaintenanceConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3TablesResponse.BuilderImpl
    implements Builder {
        private String tableBucketARN;
        private Map<String, TableBucketMaintenanceConfigurationValue> configuration = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetTableBucketMaintenanceConfigurationResponse model) {
            super(model);
            this.tableBucketARN(model.tableBucketARN);
            this.configurationWithStrings(model.configuration);
        }

        public final String getTableBucketARN() {
            return this.tableBucketARN;
        }

        public final void setTableBucketARN(String tableBucketARN) {
            this.tableBucketARN = tableBucketARN;
        }

        @Override
        public final Builder tableBucketARN(String tableBucketARN) {
            this.tableBucketARN = tableBucketARN;
            return this;
        }

        public final Map<String, TableBucketMaintenanceConfigurationValue.Builder> getConfiguration() {
            Map<String, TableBucketMaintenanceConfigurationValue.Builder> result = TableBucketMaintenanceConfigurationCopier.copyToBuilder(this.configuration);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setConfiguration(Map<String, TableBucketMaintenanceConfigurationValue.BuilderImpl> configuration) {
            this.configuration = TableBucketMaintenanceConfigurationCopier.copyFromBuilder(configuration);
        }

        @Override
        public final Builder configurationWithStrings(Map<String, TableBucketMaintenanceConfigurationValue> configuration) {
            this.configuration = TableBucketMaintenanceConfigurationCopier.copy(configuration);
            return this;
        }

        @Override
        public final Builder configuration(Map<TableBucketMaintenanceType, TableBucketMaintenanceConfigurationValue> configuration) {
            this.configuration = TableBucketMaintenanceConfigurationCopier.copyEnumToString(configuration);
            return this;
        }

        @Override
        public GetTableBucketMaintenanceConfigurationResponse build() {
            return new GetTableBucketMaintenanceConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends S3TablesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTableBucketMaintenanceConfigurationResponse> {
        public Builder tableBucketARN(String var1);

        public Builder configurationWithStrings(Map<String, TableBucketMaintenanceConfigurationValue> var1);

        public Builder configuration(Map<TableBucketMaintenanceType, TableBucketMaintenanceConfigurationValue> var1);
    }
}

