/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.s3control.S3ControlAsyncClient;
import software.amazon.awssdk.services.s3control.internal.UserAgentUtils;
import software.amazon.awssdk.services.s3control.model.ListAccessGrantsInstancesRequest;
import software.amazon.awssdk.services.s3control.model.ListAccessGrantsInstancesResponse;

public class ListAccessGrantsInstancesPublisher
implements SdkPublisher<ListAccessGrantsInstancesResponse> {
    private final S3ControlAsyncClient client;
    private final ListAccessGrantsInstancesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAccessGrantsInstancesPublisher(S3ControlAsyncClient client, ListAccessGrantsInstancesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAccessGrantsInstancesPublisher(S3ControlAsyncClient client, ListAccessGrantsInstancesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAccessGrantsInstancesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAccessGrantsInstancesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListAccessGrantsInstancesResponseFetcher
    implements AsyncPageFetcher<ListAccessGrantsInstancesResponse> {
        private ListAccessGrantsInstancesResponseFetcher() {
        }

        public boolean hasNextPage(ListAccessGrantsInstancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAccessGrantsInstancesResponse> nextPage(ListAccessGrantsInstancesResponse previousPage) {
            if (previousPage == null) {
                return ListAccessGrantsInstancesPublisher.this.client.listAccessGrantsInstances(ListAccessGrantsInstancesPublisher.this.firstRequest);
            }
            return ListAccessGrantsInstancesPublisher.this.client.listAccessGrantsInstances((ListAccessGrantsInstancesRequest)((Object)ListAccessGrantsInstancesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

