/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.s3control.model.AccessGrantsInstancesListCopier;
import software.amazon.awssdk.services.s3control.model.ListAccessGrantsInstanceEntry;
import software.amazon.awssdk.services.s3control.model.S3ControlResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAccessGrantsInstancesResponse
extends S3ControlResponse
implements ToCopyableBuilder<Builder, ListAccessGrantsInstancesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListAccessGrantsInstancesResponse.getter(ListAccessGrantsInstancesResponse::nextToken)).setter(ListAccessGrantsInstancesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("NextToken").build()}).build();
    private static final SdkField<List<ListAccessGrantsInstanceEntry>> ACCESS_GRANTS_INSTANCES_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AccessGrantsInstancesList").getter(ListAccessGrantsInstancesResponse.getter(ListAccessGrantsInstancesResponse::accessGrantsInstancesList)).setter(ListAccessGrantsInstancesResponse.setter(Builder::accessGrantsInstancesList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessGrantsInstancesList").unmarshallLocationName("AccessGrantsInstancesList").build(), ListTrait.builder().memberLocationName("AccessGrantsInstance").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ListAccessGrantsInstanceEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessGrantsInstance").unmarshallLocationName("AccessGrantsInstance").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, ACCESS_GRANTS_INSTANCES_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAccessGrantsInstancesResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<ListAccessGrantsInstanceEntry> accessGrantsInstancesList;

    private ListAccessGrantsInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.accessGrantsInstancesList = builder.accessGrantsInstancesList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasAccessGrantsInstancesList() {
        return this.accessGrantsInstancesList != null && !(this.accessGrantsInstancesList instanceof SdkAutoConstructList);
    }

    public final List<ListAccessGrantsInstanceEntry> accessGrantsInstancesList() {
        return this.accessGrantsInstancesList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccessGrantsInstancesList() ? this.accessGrantsInstancesList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAccessGrantsInstancesResponse)) {
            return false;
        }
        ListAccessGrantsInstancesResponse other = (ListAccessGrantsInstancesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasAccessGrantsInstancesList() == other.hasAccessGrantsInstancesList() && Objects.equals(this.accessGrantsInstancesList(), other.accessGrantsInstancesList());
    }

    public final String toString() {
        return ToString.builder((String)"ListAccessGrantsInstancesResponse").add("NextToken", (Object)this.nextToken()).add("AccessGrantsInstancesList", this.hasAccessGrantsInstancesList() ? this.accessGrantsInstancesList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "AccessGrantsInstancesList": {
                return Optional.ofNullable(clazz.cast(this.accessGrantsInstancesList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("AccessGrantsInstancesList", ACCESS_GRANTS_INSTANCES_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAccessGrantsInstancesResponse, T> g) {
        return obj -> g.apply((ListAccessGrantsInstancesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3ControlResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ListAccessGrantsInstanceEntry> accessGrantsInstancesList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListAccessGrantsInstancesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.accessGrantsInstancesList(model.accessGrantsInstancesList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ListAccessGrantsInstanceEntry.Builder> getAccessGrantsInstancesList() {
            List<ListAccessGrantsInstanceEntry.Builder> result = AccessGrantsInstancesListCopier.copyToBuilder(this.accessGrantsInstancesList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccessGrantsInstancesList(Collection<ListAccessGrantsInstanceEntry.BuilderImpl> accessGrantsInstancesList) {
            this.accessGrantsInstancesList = AccessGrantsInstancesListCopier.copyFromBuilder(accessGrantsInstancesList);
        }

        @Override
        public final Builder accessGrantsInstancesList(Collection<ListAccessGrantsInstanceEntry> accessGrantsInstancesList) {
            this.accessGrantsInstancesList = AccessGrantsInstancesListCopier.copy(accessGrantsInstancesList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessGrantsInstancesList(ListAccessGrantsInstanceEntry ... accessGrantsInstancesList) {
            this.accessGrantsInstancesList(Arrays.asList(accessGrantsInstancesList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessGrantsInstancesList(Consumer<ListAccessGrantsInstanceEntry.Builder> ... accessGrantsInstancesList) {
            this.accessGrantsInstancesList(Stream.of(accessGrantsInstancesList).map(c -> (ListAccessGrantsInstanceEntry)((ListAccessGrantsInstanceEntry.Builder)ListAccessGrantsInstanceEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListAccessGrantsInstancesResponse build() {
            return new ListAccessGrantsInstancesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends S3ControlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAccessGrantsInstancesResponse> {
        public Builder nextToken(String var1);

        public Builder accessGrantsInstancesList(Collection<ListAccessGrantsInstanceEntry> var1);

        public Builder accessGrantsInstancesList(ListAccessGrantsInstanceEntry ... var1);

        public Builder accessGrantsInstancesList(Consumer<ListAccessGrantsInstanceEntry.Builder> ... var1);
    }
}

