/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.s3control.model.MultiRegionAccessPointReport;
import software.amazon.awssdk.services.s3control.model.MultiRegionAccessPointReportListCopier;
import software.amazon.awssdk.services.s3control.model.S3ControlResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListMultiRegionAccessPointsResponse
extends S3ControlResponse
implements ToCopyableBuilder<Builder, ListMultiRegionAccessPointsResponse> {
    private static final SdkField<List<MultiRegionAccessPointReport>> ACCESS_POINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AccessPoints").getter(ListMultiRegionAccessPointsResponse.getter(ListMultiRegionAccessPointsResponse::accessPoints)).setter(ListMultiRegionAccessPointsResponse.setter(Builder::accessPoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessPoints").unmarshallLocationName("AccessPoints").build(), ListTrait.builder().memberLocationName("AccessPoint").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MultiRegionAccessPointReport::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessPoint").unmarshallLocationName("AccessPoint").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListMultiRegionAccessPointsResponse.getter(ListMultiRegionAccessPointsResponse::nextToken)).setter(ListMultiRegionAccessPointsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_POINTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListMultiRegionAccessPointsResponse.memberNameToFieldInitializer();
    private final List<MultiRegionAccessPointReport> accessPoints;
    private final String nextToken;

    private ListMultiRegionAccessPointsResponse(BuilderImpl builder) {
        super(builder);
        this.accessPoints = builder.accessPoints;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAccessPoints() {
        return this.accessPoints != null && !(this.accessPoints instanceof SdkAutoConstructList);
    }

    public final List<MultiRegionAccessPointReport> accessPoints() {
        return this.accessPoints;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccessPoints() ? this.accessPoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMultiRegionAccessPointsResponse)) {
            return false;
        }
        ListMultiRegionAccessPointsResponse other = (ListMultiRegionAccessPointsResponse)((Object)obj);
        return this.hasAccessPoints() == other.hasAccessPoints() && Objects.equals(this.accessPoints(), other.accessPoints()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListMultiRegionAccessPointsResponse").add("AccessPoints", this.hasAccessPoints() ? this.accessPoints() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccessPoints": {
                return Optional.ofNullable(clazz.cast(this.accessPoints()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AccessPoints", ACCESS_POINTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListMultiRegionAccessPointsResponse, T> g) {
        return obj -> g.apply((ListMultiRegionAccessPointsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3ControlResponse.BuilderImpl
    implements Builder {
        private List<MultiRegionAccessPointReport> accessPoints = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMultiRegionAccessPointsResponse model) {
            super(model);
            this.accessPoints(model.accessPoints);
            this.nextToken(model.nextToken);
        }

        public final List<MultiRegionAccessPointReport.Builder> getAccessPoints() {
            List<MultiRegionAccessPointReport.Builder> result = MultiRegionAccessPointReportListCopier.copyToBuilder(this.accessPoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccessPoints(Collection<MultiRegionAccessPointReport.BuilderImpl> accessPoints) {
            this.accessPoints = MultiRegionAccessPointReportListCopier.copyFromBuilder(accessPoints);
        }

        @Override
        public final Builder accessPoints(Collection<MultiRegionAccessPointReport> accessPoints) {
            this.accessPoints = MultiRegionAccessPointReportListCopier.copy(accessPoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessPoints(MultiRegionAccessPointReport ... accessPoints) {
            this.accessPoints(Arrays.asList(accessPoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessPoints(Consumer<MultiRegionAccessPointReport.Builder> ... accessPoints) {
            this.accessPoints(Stream.of(accessPoints).map(c -> (MultiRegionAccessPointReport)((MultiRegionAccessPointReport.Builder)MultiRegionAccessPointReport.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListMultiRegionAccessPointsResponse build() {
            return new ListMultiRegionAccessPointsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends S3ControlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListMultiRegionAccessPointsResponse> {
        public Builder accessPoints(Collection<MultiRegionAccessPointReport> var1);

        public Builder accessPoints(MultiRegionAccessPointReport ... var1);

        public Builder accessPoints(Consumer<MultiRegionAccessPointReport.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

