/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3control.model.S3Grantee;
import software.amazon.awssdk.services.s3control.model.S3Permission;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3Grant
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3Grant> {
    private static final SdkField<S3Grantee> GRANTEE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Grantee").getter(S3Grant.getter(S3Grant::grantee)).setter(S3Grant.setter(Builder::grantee)).constructor(S3Grantee::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Grantee").unmarshallLocationName("Grantee").build()}).build();
    private static final SdkField<String> PERMISSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Permission").getter(S3Grant.getter(S3Grant::permissionAsString)).setter(S3Grant.setter(Builder::permission)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permission").unmarshallLocationName("Permission").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRANTEE_FIELD, PERMISSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = S3Grant.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final S3Grantee grantee;
    private final String permission;

    private S3Grant(BuilderImpl builder) {
        this.grantee = builder.grantee;
        this.permission = builder.permission;
    }

    public final S3Grantee grantee() {
        return this.grantee;
    }

    public final S3Permission permission() {
        return S3Permission.fromValue(this.permission);
    }

    public final String permissionAsString() {
        return this.permission;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.grantee());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Grant)) {
            return false;
        }
        S3Grant other = (S3Grant)obj;
        return Objects.equals(this.grantee(), other.grantee()) && Objects.equals(this.permissionAsString(), other.permissionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"S3Grant").add("Grantee", (Object)this.grantee()).add("Permission", (Object)this.permissionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Grantee": {
                return Optional.ofNullable(clazz.cast(this.grantee()));
            }
            case "Permission": {
                return Optional.ofNullable(clazz.cast(this.permissionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Grantee", GRANTEE_FIELD);
        map.put("Permission", PERMISSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3Grant, T> g) {
        return obj -> g.apply((S3Grant)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private S3Grantee grantee;
        private String permission;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Grant model) {
            this.grantee(model.grantee);
            this.permission(model.permission);
        }

        public final S3Grantee.Builder getGrantee() {
            return this.grantee != null ? this.grantee.toBuilder() : null;
        }

        public final void setGrantee(S3Grantee.BuilderImpl grantee) {
            this.grantee = grantee != null ? grantee.build() : null;
        }

        @Override
        public final Builder grantee(S3Grantee grantee) {
            this.grantee = grantee;
            return this;
        }

        public final String getPermission() {
            return this.permission;
        }

        public final void setPermission(String permission) {
            this.permission = permission;
        }

        @Override
        public final Builder permission(String permission) {
            this.permission = permission;
            return this;
        }

        @Override
        public final Builder permission(S3Permission permission) {
            this.permission(permission == null ? null : permission.toString());
            return this;
        }

        public S3Grant build() {
            return new S3Grant(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3Grant> {
        public Builder grantee(S3Grantee var1);

        default public Builder grantee(Consumer<S3Grantee.Builder> grantee) {
            return this.grantee((S3Grantee)((S3Grantee.Builder)S3Grantee.builder().applyMutation(grantee)).build());
        }

        public Builder permission(String var1);

        public Builder permission(S3Permission var1);
    }
}

