/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.s3control.model.UserArgumentsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LambdaInvokeOperation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LambdaInvokeOperation> {
    private static final SdkField<String> FUNCTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FunctionArn").getter(LambdaInvokeOperation.getter(LambdaInvokeOperation::functionArn)).setter(LambdaInvokeOperation.setter(Builder::functionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionArn").unmarshallLocationName("FunctionArn").build()}).build();
    private static final SdkField<String> INVOCATION_SCHEMA_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InvocationSchemaVersion").getter(LambdaInvokeOperation.getter(LambdaInvokeOperation::invocationSchemaVersion)).setter(LambdaInvokeOperation.setter(Builder::invocationSchemaVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvocationSchemaVersion").unmarshallLocationName("InvocationSchemaVersion").build()}).build();
    private static final SdkField<Map<String, String>> USER_ARGUMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("UserArguments").getter(LambdaInvokeOperation.getter(LambdaInvokeOperation::userArguments)).setter(LambdaInvokeOperation.setter(Builder::userArguments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserArguments").unmarshallLocationName("UserArguments").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").unmarshallLocationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_ARN_FIELD, INVOCATION_SCHEMA_VERSION_FIELD, USER_ARGUMENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LambdaInvokeOperation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String functionArn;
    private final String invocationSchemaVersion;
    private final Map<String, String> userArguments;

    private LambdaInvokeOperation(BuilderImpl builder) {
        this.functionArn = builder.functionArn;
        this.invocationSchemaVersion = builder.invocationSchemaVersion;
        this.userArguments = builder.userArguments;
    }

    public final String functionArn() {
        return this.functionArn;
    }

    public final String invocationSchemaVersion() {
        return this.invocationSchemaVersion;
    }

    public final boolean hasUserArguments() {
        return this.userArguments != null && !(this.userArguments instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> userArguments() {
        return this.userArguments;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.functionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.invocationSchemaVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserArguments() ? this.userArguments() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaInvokeOperation)) {
            return false;
        }
        LambdaInvokeOperation other = (LambdaInvokeOperation)obj;
        return Objects.equals(this.functionArn(), other.functionArn()) && Objects.equals(this.invocationSchemaVersion(), other.invocationSchemaVersion()) && this.hasUserArguments() == other.hasUserArguments() && Objects.equals(this.userArguments(), other.userArguments());
    }

    public final String toString() {
        return ToString.builder((String)"LambdaInvokeOperation").add("FunctionArn", (Object)this.functionArn()).add("InvocationSchemaVersion", (Object)this.invocationSchemaVersion()).add("UserArguments", this.hasUserArguments() ? this.userArguments() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FunctionArn": {
                return Optional.ofNullable(clazz.cast(this.functionArn()));
            }
            case "InvocationSchemaVersion": {
                return Optional.ofNullable(clazz.cast(this.invocationSchemaVersion()));
            }
            case "UserArguments": {
                return Optional.ofNullable(clazz.cast(this.userArguments()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FunctionArn", FUNCTION_ARN_FIELD);
        map.put("InvocationSchemaVersion", INVOCATION_SCHEMA_VERSION_FIELD);
        map.put("UserArguments", USER_ARGUMENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LambdaInvokeOperation, T> g) {
        return obj -> g.apply((LambdaInvokeOperation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String functionArn;
        private String invocationSchemaVersion;
        private Map<String, String> userArguments = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LambdaInvokeOperation model) {
            this.functionArn(model.functionArn);
            this.invocationSchemaVersion(model.invocationSchemaVersion);
            this.userArguments(model.userArguments);
        }

        public final String getFunctionArn() {
            return this.functionArn;
        }

        public final void setFunctionArn(String functionArn) {
            this.functionArn = functionArn;
        }

        @Override
        public final Builder functionArn(String functionArn) {
            this.functionArn = functionArn;
            return this;
        }

        public final String getInvocationSchemaVersion() {
            return this.invocationSchemaVersion;
        }

        public final void setInvocationSchemaVersion(String invocationSchemaVersion) {
            this.invocationSchemaVersion = invocationSchemaVersion;
        }

        @Override
        public final Builder invocationSchemaVersion(String invocationSchemaVersion) {
            this.invocationSchemaVersion = invocationSchemaVersion;
            return this;
        }

        public final Map<String, String> getUserArguments() {
            if (this.userArguments instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.userArguments;
        }

        public final void setUserArguments(Map<String, String> userArguments) {
            this.userArguments = UserArgumentsCopier.copy(userArguments);
        }

        @Override
        public final Builder userArguments(Map<String, String> userArguments) {
            this.userArguments = UserArgumentsCopier.copy(userArguments);
            return this;
        }

        public LambdaInvokeOperation build() {
            return new LambdaInvokeOperation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LambdaInvokeOperation> {
        public Builder functionArn(String var1);

        public Builder invocationSchemaVersion(String var1);

        public Builder userArguments(Map<String, String> var1);
    }
}

