/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.s3control.model.MultiRegionAccessPointStatus;
import software.amazon.awssdk.services.s3control.model.PublicAccessBlockConfiguration;
import software.amazon.awssdk.services.s3control.model.RegionReport;
import software.amazon.awssdk.services.s3control.model.RegionReportListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MultiRegionAccessPointReport
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MultiRegionAccessPointReport> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(MultiRegionAccessPointReport.getter(MultiRegionAccessPointReport::name)).setter(MultiRegionAccessPointReport.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").unmarshallLocationName("Name").build()}).build();
    private static final SdkField<String> ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Alias").getter(MultiRegionAccessPointReport.getter(MultiRegionAccessPointReport::alias)).setter(MultiRegionAccessPointReport.setter(Builder::alias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Alias").unmarshallLocationName("Alias").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(MultiRegionAccessPointReport.getter(MultiRegionAccessPointReport::createdAt)).setter(MultiRegionAccessPointReport.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").unmarshallLocationName("CreatedAt").build()}).build();
    private static final SdkField<PublicAccessBlockConfiguration> PUBLIC_ACCESS_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PublicAccessBlock").getter(MultiRegionAccessPointReport.getter(MultiRegionAccessPointReport::publicAccessBlock)).setter(MultiRegionAccessPointReport.setter(Builder::publicAccessBlock)).constructor(PublicAccessBlockConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicAccessBlock").unmarshallLocationName("PublicAccessBlock").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(MultiRegionAccessPointReport.getter(MultiRegionAccessPointReport::statusAsString)).setter(MultiRegionAccessPointReport.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").unmarshallLocationName("Status").build()}).build();
    private static final SdkField<List<RegionReport>> REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Regions").getter(MultiRegionAccessPointReport.getter(MultiRegionAccessPointReport::regions)).setter(MultiRegionAccessPointReport.setter(Builder::regions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Regions").unmarshallLocationName("Regions").build(), ListTrait.builder().memberLocationName("Region").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RegionReport::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").unmarshallLocationName("Region").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ALIAS_FIELD, CREATED_AT_FIELD, PUBLIC_ACCESS_BLOCK_FIELD, STATUS_FIELD, REGIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MultiRegionAccessPointReport.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String alias;
    private final Instant createdAt;
    private final PublicAccessBlockConfiguration publicAccessBlock;
    private final String status;
    private final List<RegionReport> regions;

    private MultiRegionAccessPointReport(BuilderImpl builder) {
        this.name = builder.name;
        this.alias = builder.alias;
        this.createdAt = builder.createdAt;
        this.publicAccessBlock = builder.publicAccessBlock;
        this.status = builder.status;
        this.regions = builder.regions;
    }

    public final String name() {
        return this.name;
    }

    public final String alias() {
        return this.alias;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final PublicAccessBlockConfiguration publicAccessBlock() {
        return this.publicAccessBlock;
    }

    public final MultiRegionAccessPointStatus status() {
        return MultiRegionAccessPointStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasRegions() {
        return this.regions != null && !(this.regions instanceof SdkAutoConstructList);
    }

    public final List<RegionReport> regions() {
        return this.regions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.alias());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicAccessBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegions() ? this.regions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MultiRegionAccessPointReport)) {
            return false;
        }
        MultiRegionAccessPointReport other = (MultiRegionAccessPointReport)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.alias(), other.alias()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.publicAccessBlock(), other.publicAccessBlock()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasRegions() == other.hasRegions() && Objects.equals(this.regions(), other.regions());
    }

    public final String toString() {
        return ToString.builder((String)"MultiRegionAccessPointReport").add("Name", (Object)this.name()).add("Alias", (Object)this.alias()).add("CreatedAt", (Object)this.createdAt()).add("PublicAccessBlock", (Object)this.publicAccessBlock()).add("Status", (Object)this.statusAsString()).add("Regions", this.hasRegions() ? this.regions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Alias": {
                return Optional.ofNullable(clazz.cast(this.alias()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "PublicAccessBlock": {
                return Optional.ofNullable(clazz.cast(this.publicAccessBlock()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Regions": {
                return Optional.ofNullable(clazz.cast(this.regions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Alias", ALIAS_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("PublicAccessBlock", PUBLIC_ACCESS_BLOCK_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Regions", REGIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MultiRegionAccessPointReport, T> g) {
        return obj -> g.apply((MultiRegionAccessPointReport)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String alias;
        private Instant createdAt;
        private PublicAccessBlockConfiguration publicAccessBlock;
        private String status;
        private List<RegionReport> regions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MultiRegionAccessPointReport model) {
            this.name(model.name);
            this.alias(model.alias);
            this.createdAt(model.createdAt);
            this.publicAccessBlock(model.publicAccessBlock);
            this.status(model.status);
            this.regions(model.regions);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getAlias() {
            return this.alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final PublicAccessBlockConfiguration.Builder getPublicAccessBlock() {
            return this.publicAccessBlock != null ? this.publicAccessBlock.toBuilder() : null;
        }

        public final void setPublicAccessBlock(PublicAccessBlockConfiguration.BuilderImpl publicAccessBlock) {
            this.publicAccessBlock = publicAccessBlock != null ? publicAccessBlock.build() : null;
        }

        @Override
        public final Builder publicAccessBlock(PublicAccessBlockConfiguration publicAccessBlock) {
            this.publicAccessBlock = publicAccessBlock;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MultiRegionAccessPointStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final List<RegionReport.Builder> getRegions() {
            List<RegionReport.Builder> result = RegionReportListCopier.copyToBuilder(this.regions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRegions(Collection<RegionReport.BuilderImpl> regions) {
            this.regions = RegionReportListCopier.copyFromBuilder(regions);
        }

        @Override
        public final Builder regions(Collection<RegionReport> regions) {
            this.regions = RegionReportListCopier.copy(regions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regions(RegionReport ... regions) {
            this.regions(Arrays.asList(regions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regions(Consumer<RegionReport.Builder> ... regions) {
            this.regions(Stream.of(regions).map(c -> (RegionReport)((RegionReport.Builder)RegionReport.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public MultiRegionAccessPointReport build() {
            return new MultiRegionAccessPointReport(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MultiRegionAccessPointReport> {
        public Builder name(String var1);

        public Builder alias(String var1);

        public Builder createdAt(Instant var1);

        public Builder publicAccessBlock(PublicAccessBlockConfiguration var1);

        default public Builder publicAccessBlock(Consumer<PublicAccessBlockConfiguration.Builder> publicAccessBlock) {
            return this.publicAccessBlock((PublicAccessBlockConfiguration)((PublicAccessBlockConfiguration.Builder)PublicAccessBlockConfiguration.builder().applyMutation(publicAccessBlock)).build());
        }

        public Builder status(String var1);

        public Builder status(MultiRegionAccessPointStatus var1);

        public Builder regions(Collection<RegionReport> var1);

        public Builder regions(RegionReport ... var1);

        public Builder regions(Consumer<RegionReport.Builder> ... var1);
    }
}

