/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.s3control.model.NonEmptyMaxLength1024StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KeyNameConstraint
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KeyNameConstraint> {
    private static final SdkField<List<String>> MATCH_ANY_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MatchAnyPrefix").getter(KeyNameConstraint.getter(KeyNameConstraint::matchAnyPrefix)).setter(KeyNameConstraint.setter(Builder::matchAnyPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchAnyPrefix").unmarshallLocationName("MatchAnyPrefix").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> MATCH_ANY_SUFFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MatchAnySuffix").getter(KeyNameConstraint.getter(KeyNameConstraint::matchAnySuffix)).setter(KeyNameConstraint.setter(Builder::matchAnySuffix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchAnySuffix").unmarshallLocationName("MatchAnySuffix").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> MATCH_ANY_SUBSTRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MatchAnySubstring").getter(KeyNameConstraint.getter(KeyNameConstraint::matchAnySubstring)).setter(KeyNameConstraint.setter(Builder::matchAnySubstring)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchAnySubstring").unmarshallLocationName("MatchAnySubstring").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MATCH_ANY_PREFIX_FIELD, MATCH_ANY_SUFFIX_FIELD, MATCH_ANY_SUBSTRING_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = KeyNameConstraint.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> matchAnyPrefix;
    private final List<String> matchAnySuffix;
    private final List<String> matchAnySubstring;

    private KeyNameConstraint(BuilderImpl builder) {
        this.matchAnyPrefix = builder.matchAnyPrefix;
        this.matchAnySuffix = builder.matchAnySuffix;
        this.matchAnySubstring = builder.matchAnySubstring;
    }

    public final boolean hasMatchAnyPrefix() {
        return this.matchAnyPrefix != null && !(this.matchAnyPrefix instanceof SdkAutoConstructList);
    }

    public final List<String> matchAnyPrefix() {
        return this.matchAnyPrefix;
    }

    public final boolean hasMatchAnySuffix() {
        return this.matchAnySuffix != null && !(this.matchAnySuffix instanceof SdkAutoConstructList);
    }

    public final List<String> matchAnySuffix() {
        return this.matchAnySuffix;
    }

    public final boolean hasMatchAnySubstring() {
        return this.matchAnySubstring != null && !(this.matchAnySubstring instanceof SdkAutoConstructList);
    }

    public final List<String> matchAnySubstring() {
        return this.matchAnySubstring;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMatchAnyPrefix() ? this.matchAnyPrefix() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMatchAnySuffix() ? this.matchAnySuffix() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMatchAnySubstring() ? this.matchAnySubstring() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeyNameConstraint)) {
            return false;
        }
        KeyNameConstraint other = (KeyNameConstraint)obj;
        return this.hasMatchAnyPrefix() == other.hasMatchAnyPrefix() && Objects.equals(this.matchAnyPrefix(), other.matchAnyPrefix()) && this.hasMatchAnySuffix() == other.hasMatchAnySuffix() && Objects.equals(this.matchAnySuffix(), other.matchAnySuffix()) && this.hasMatchAnySubstring() == other.hasMatchAnySubstring() && Objects.equals(this.matchAnySubstring(), other.matchAnySubstring());
    }

    public final String toString() {
        return ToString.builder((String)"KeyNameConstraint").add("MatchAnyPrefix", this.hasMatchAnyPrefix() ? this.matchAnyPrefix() : null).add("MatchAnySuffix", this.hasMatchAnySuffix() ? this.matchAnySuffix() : null).add("MatchAnySubstring", this.hasMatchAnySubstring() ? this.matchAnySubstring() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MatchAnyPrefix": {
                return Optional.ofNullable(clazz.cast(this.matchAnyPrefix()));
            }
            case "MatchAnySuffix": {
                return Optional.ofNullable(clazz.cast(this.matchAnySuffix()));
            }
            case "MatchAnySubstring": {
                return Optional.ofNullable(clazz.cast(this.matchAnySubstring()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("MatchAnyPrefix", MATCH_ANY_PREFIX_FIELD);
        map.put("MatchAnySuffix", MATCH_ANY_SUFFIX_FIELD);
        map.put("MatchAnySubstring", MATCH_ANY_SUBSTRING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KeyNameConstraint, T> g) {
        return obj -> g.apply((KeyNameConstraint)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> matchAnyPrefix = DefaultSdkAutoConstructList.getInstance();
        private List<String> matchAnySuffix = DefaultSdkAutoConstructList.getInstance();
        private List<String> matchAnySubstring = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(KeyNameConstraint model) {
            this.matchAnyPrefix(model.matchAnyPrefix);
            this.matchAnySuffix(model.matchAnySuffix);
            this.matchAnySubstring(model.matchAnySubstring);
        }

        public final Collection<String> getMatchAnyPrefix() {
            if (this.matchAnyPrefix instanceof SdkAutoConstructList) {
                return null;
            }
            return this.matchAnyPrefix;
        }

        public final void setMatchAnyPrefix(Collection<String> matchAnyPrefix) {
            this.matchAnyPrefix = NonEmptyMaxLength1024StringListCopier.copy(matchAnyPrefix);
        }

        @Override
        public final Builder matchAnyPrefix(Collection<String> matchAnyPrefix) {
            this.matchAnyPrefix = NonEmptyMaxLength1024StringListCopier.copy(matchAnyPrefix);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchAnyPrefix(String ... matchAnyPrefix) {
            this.matchAnyPrefix(Arrays.asList(matchAnyPrefix));
            return this;
        }

        public final Collection<String> getMatchAnySuffix() {
            if (this.matchAnySuffix instanceof SdkAutoConstructList) {
                return null;
            }
            return this.matchAnySuffix;
        }

        public final void setMatchAnySuffix(Collection<String> matchAnySuffix) {
            this.matchAnySuffix = NonEmptyMaxLength1024StringListCopier.copy(matchAnySuffix);
        }

        @Override
        public final Builder matchAnySuffix(Collection<String> matchAnySuffix) {
            this.matchAnySuffix = NonEmptyMaxLength1024StringListCopier.copy(matchAnySuffix);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchAnySuffix(String ... matchAnySuffix) {
            this.matchAnySuffix(Arrays.asList(matchAnySuffix));
            return this;
        }

        public final Collection<String> getMatchAnySubstring() {
            if (this.matchAnySubstring instanceof SdkAutoConstructList) {
                return null;
            }
            return this.matchAnySubstring;
        }

        public final void setMatchAnySubstring(Collection<String> matchAnySubstring) {
            this.matchAnySubstring = NonEmptyMaxLength1024StringListCopier.copy(matchAnySubstring);
        }

        @Override
        public final Builder matchAnySubstring(Collection<String> matchAnySubstring) {
            this.matchAnySubstring = NonEmptyMaxLength1024StringListCopier.copy(matchAnySubstring);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchAnySubstring(String ... matchAnySubstring) {
            this.matchAnySubstring(Arrays.asList(matchAnySubstring));
            return this;
        }

        public KeyNameConstraint build() {
            return new KeyNameConstraint(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KeyNameConstraint> {
        public Builder matchAnyPrefix(Collection<String> var1);

        public Builder matchAnyPrefix(String ... var1);

        public Builder matchAnySuffix(Collection<String> var1);

        public Builder matchAnySuffix(String ... var1);

        public Builder matchAnySubstring(Collection<String> var1);

        public Builder matchAnySubstring(String ... var1);
    }
}

