/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.s3control.S3ControlClient;
import software.amazon.awssdk.services.s3control.internal.UserAgentUtils;
import software.amazon.awssdk.services.s3control.model.ListAccessGrantsInstancesRequest;
import software.amazon.awssdk.services.s3control.model.ListAccessGrantsInstancesResponse;

public class ListAccessGrantsInstancesIterable
implements SdkIterable<ListAccessGrantsInstancesResponse> {
    private final S3ControlClient client;
    private final ListAccessGrantsInstancesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAccessGrantsInstancesIterable(S3ControlClient client, ListAccessGrantsInstancesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAccessGrantsInstancesResponseFetcher();
    }

    public Iterator<ListAccessGrantsInstancesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListAccessGrantsInstancesResponseFetcher
    implements SyncPageFetcher<ListAccessGrantsInstancesResponse> {
        private ListAccessGrantsInstancesResponseFetcher() {
        }

        public boolean hasNextPage(ListAccessGrantsInstancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAccessGrantsInstancesResponse nextPage(ListAccessGrantsInstancesResponse previousPage) {
            if (previousPage == null) {
                return ListAccessGrantsInstancesIterable.this.client.listAccessGrantsInstances(ListAccessGrantsInstancesIterable.this.firstRequest);
            }
            return ListAccessGrantsInstancesIterable.this.client.listAccessGrantsInstances((ListAccessGrantsInstancesRequest)((Object)ListAccessGrantsInstancesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

