/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.s3control.S3ControlClient;
import software.amazon.awssdk.services.s3control.model.ListAccessPointsRequest;
import software.amazon.awssdk.services.s3control.model.ListAccessPointsResponse;

public class ListAccessPointsIterable
implements SdkIterable<ListAccessPointsResponse> {
    private final S3ControlClient client;
    private final ListAccessPointsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAccessPointsIterable(S3ControlClient client, ListAccessPointsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListAccessPointsResponseFetcher();
    }

    public Iterator<ListAccessPointsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListAccessPointsResponseFetcher
    implements SyncPageFetcher<ListAccessPointsResponse> {
        private ListAccessPointsResponseFetcher() {
        }

        public boolean hasNextPage(ListAccessPointsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAccessPointsResponse nextPage(ListAccessPointsResponse previousPage) {
            if (previousPage == null) {
                return ListAccessPointsIterable.this.client.listAccessPoints(ListAccessPointsIterable.this.firstRequest);
            }
            return ListAccessPointsIterable.this.client.listAccessPoints((ListAccessPointsRequest)((Object)ListAccessPointsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

