/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.s3control.S3ControlAsyncClient;
import software.amazon.awssdk.services.s3control.model.ListStorageLensConfigurationsRequest;
import software.amazon.awssdk.services.s3control.model.ListStorageLensConfigurationsResponse;

public class ListStorageLensConfigurationsPublisher
implements SdkPublisher<ListStorageLensConfigurationsResponse> {
    private final S3ControlAsyncClient client;
    private final ListStorageLensConfigurationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListStorageLensConfigurationsPublisher(S3ControlAsyncClient client, ListStorageLensConfigurationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListStorageLensConfigurationsPublisher(S3ControlAsyncClient client, ListStorageLensConfigurationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListStorageLensConfigurationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListStorageLensConfigurationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListStorageLensConfigurationsResponseFetcher
    implements AsyncPageFetcher<ListStorageLensConfigurationsResponse> {
        private ListStorageLensConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListStorageLensConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListStorageLensConfigurationsResponse> nextPage(ListStorageLensConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListStorageLensConfigurationsPublisher.this.client.listStorageLensConfigurations(ListStorageLensConfigurationsPublisher.this.firstRequest);
            }
            return ListStorageLensConfigurationsPublisher.this.client.listStorageLensConfigurations((ListStorageLensConfigurationsRequest)((Object)ListStorageLensConfigurationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

