/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3control.model.AsyncOperationName;
import software.amazon.awssdk.services.s3control.model.AsyncRequestParameters;
import software.amazon.awssdk.services.s3control.model.AsyncResponseDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AsyncOperation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AsyncOperation> {
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(AsyncOperation.getter(AsyncOperation::creationTime)).setter(AsyncOperation.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").unmarshallLocationName("CreationTime").build()}).build();
    private static final SdkField<String> OPERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Operation").getter(AsyncOperation.getter(AsyncOperation::operationAsString)).setter(AsyncOperation.setter(Builder::operation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operation").unmarshallLocationName("Operation").build()}).build();
    private static final SdkField<String> REQUEST_TOKEN_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestTokenARN").getter(AsyncOperation.getter(AsyncOperation::requestTokenARN)).setter(AsyncOperation.setter(Builder::requestTokenARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestTokenARN").unmarshallLocationName("RequestTokenARN").build()}).build();
    private static final SdkField<AsyncRequestParameters> REQUEST_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RequestParameters").getter(AsyncOperation.getter(AsyncOperation::requestParameters)).setter(AsyncOperation.setter(Builder::requestParameters)).constructor(AsyncRequestParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestParameters").unmarshallLocationName("RequestParameters").build()}).build();
    private static final SdkField<String> REQUEST_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestStatus").getter(AsyncOperation.getter(AsyncOperation::requestStatus)).setter(AsyncOperation.setter(Builder::requestStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestStatus").unmarshallLocationName("RequestStatus").build()}).build();
    private static final SdkField<AsyncResponseDetails> RESPONSE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResponseDetails").getter(AsyncOperation.getter(AsyncOperation::responseDetails)).setter(AsyncOperation.setter(Builder::responseDetails)).constructor(AsyncResponseDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResponseDetails").unmarshallLocationName("ResponseDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_TIME_FIELD, OPERATION_FIELD, REQUEST_TOKEN_ARN_FIELD, REQUEST_PARAMETERS_FIELD, REQUEST_STATUS_FIELD, RESPONSE_DETAILS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant creationTime;
    private final String operation;
    private final String requestTokenARN;
    private final AsyncRequestParameters requestParameters;
    private final String requestStatus;
    private final AsyncResponseDetails responseDetails;

    private AsyncOperation(BuilderImpl builder) {
        this.creationTime = builder.creationTime;
        this.operation = builder.operation;
        this.requestTokenARN = builder.requestTokenARN;
        this.requestParameters = builder.requestParameters;
        this.requestStatus = builder.requestStatus;
        this.responseDetails = builder.responseDetails;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final AsyncOperationName operation() {
        return AsyncOperationName.fromValue(this.operation);
    }

    public final String operationAsString() {
        return this.operation;
    }

    public final String requestTokenARN() {
        return this.requestTokenARN;
    }

    public final AsyncRequestParameters requestParameters() {
        return this.requestParameters;
    }

    public final String requestStatus() {
        return this.requestStatus;
    }

    public final AsyncResponseDetails responseDetails() {
        return this.responseDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestTokenARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.responseDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AsyncOperation)) {
            return false;
        }
        AsyncOperation other = (AsyncOperation)obj;
        return Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.operationAsString(), other.operationAsString()) && Objects.equals(this.requestTokenARN(), other.requestTokenARN()) && Objects.equals(this.requestParameters(), other.requestParameters()) && Objects.equals(this.requestStatus(), other.requestStatus()) && Objects.equals(this.responseDetails(), other.responseDetails());
    }

    public final String toString() {
        return ToString.builder((String)"AsyncOperation").add("CreationTime", (Object)this.creationTime()).add("Operation", (Object)this.operationAsString()).add("RequestTokenARN", (Object)this.requestTokenARN()).add("RequestParameters", (Object)this.requestParameters()).add("RequestStatus", (Object)this.requestStatus()).add("ResponseDetails", (Object)this.responseDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "Operation": {
                return Optional.ofNullable(clazz.cast(this.operationAsString()));
            }
            case "RequestTokenARN": {
                return Optional.ofNullable(clazz.cast(this.requestTokenARN()));
            }
            case "RequestParameters": {
                return Optional.ofNullable(clazz.cast(this.requestParameters()));
            }
            case "RequestStatus": {
                return Optional.ofNullable(clazz.cast(this.requestStatus()));
            }
            case "ResponseDetails": {
                return Optional.ofNullable(clazz.cast(this.responseDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AsyncOperation, T> g) {
        return obj -> g.apply((AsyncOperation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant creationTime;
        private String operation;
        private String requestTokenARN;
        private AsyncRequestParameters requestParameters;
        private String requestStatus;
        private AsyncResponseDetails responseDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(AsyncOperation model) {
            this.creationTime(model.creationTime);
            this.operation(model.operation);
            this.requestTokenARN(model.requestTokenARN);
            this.requestParameters(model.requestParameters);
            this.requestStatus(model.requestStatus);
            this.responseDetails(model.responseDetails);
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        @Transient
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getOperation() {
            return this.operation;
        }

        public final void setOperation(String operation) {
            this.operation = operation;
        }

        @Override
        @Transient
        public final Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        @Override
        @Transient
        public final Builder operation(AsyncOperationName operation) {
            this.operation(operation == null ? null : operation.toString());
            return this;
        }

        public final String getRequestTokenARN() {
            return this.requestTokenARN;
        }

        public final void setRequestTokenARN(String requestTokenARN) {
            this.requestTokenARN = requestTokenARN;
        }

        @Override
        @Transient
        public final Builder requestTokenARN(String requestTokenARN) {
            this.requestTokenARN = requestTokenARN;
            return this;
        }

        public final AsyncRequestParameters.Builder getRequestParameters() {
            return this.requestParameters != null ? this.requestParameters.toBuilder() : null;
        }

        public final void setRequestParameters(AsyncRequestParameters.BuilderImpl requestParameters) {
            this.requestParameters = requestParameters != null ? requestParameters.build() : null;
        }

        @Override
        @Transient
        public final Builder requestParameters(AsyncRequestParameters requestParameters) {
            this.requestParameters = requestParameters;
            return this;
        }

        public final String getRequestStatus() {
            return this.requestStatus;
        }

        public final void setRequestStatus(String requestStatus) {
            this.requestStatus = requestStatus;
        }

        @Override
        @Transient
        public final Builder requestStatus(String requestStatus) {
            this.requestStatus = requestStatus;
            return this;
        }

        public final AsyncResponseDetails.Builder getResponseDetails() {
            return this.responseDetails != null ? this.responseDetails.toBuilder() : null;
        }

        public final void setResponseDetails(AsyncResponseDetails.BuilderImpl responseDetails) {
            this.responseDetails = responseDetails != null ? responseDetails.build() : null;
        }

        @Override
        @Transient
        public final Builder responseDetails(AsyncResponseDetails responseDetails) {
            this.responseDetails = responseDetails;
            return this;
        }

        public AsyncOperation build() {
            return new AsyncOperation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AsyncOperation> {
        public Builder creationTime(Instant var1);

        public Builder operation(String var1);

        public Builder operation(AsyncOperationName var1);

        public Builder requestTokenARN(String var1);

        public Builder requestParameters(AsyncRequestParameters var1);

        default public Builder requestParameters(Consumer<AsyncRequestParameters.Builder> requestParameters) {
            return this.requestParameters((AsyncRequestParameters)((AsyncRequestParameters.Builder)AsyncRequestParameters.builder().applyMutation(requestParameters)).build());
        }

        public Builder requestStatus(String var1);

        public Builder responseDetails(AsyncResponseDetails var1);

        default public Builder responseDetails(Consumer<AsyncResponseDetails.Builder> responseDetails) {
            return this.responseDetails((AsyncResponseDetails)((AsyncResponseDetails.Builder)AsyncResponseDetails.builder().applyMutation(responseDetails)).build());
        }
    }
}

