/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutStorageLensConfigurationRequest extends S3ControlRequest implements
        ToCopyableBuilder<PutStorageLensConfigurationRequest.Builder, PutStorageLensConfigurationRequest> {
    private static final SdkField<String> CONFIG_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ConfigId")
            .getter(getter(PutStorageLensConfigurationRequest::configId))
            .setter(setter(Builder::configId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("storagelensid")
                    .unmarshallLocationName("storagelensid").build()).build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AccountId")
            .getter(getter(PutStorageLensConfigurationRequest::accountId))
            .setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-account-id")
                    .unmarshallLocationName("x-amz-account-id").build()).build();

    private static final SdkField<StorageLensConfiguration> STORAGE_LENS_CONFIGURATION_FIELD = SdkField
            .<StorageLensConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("StorageLensConfiguration")
            .getter(getter(PutStorageLensConfigurationRequest::storageLensConfiguration))
            .setter(setter(Builder::storageLensConfiguration))
            .constructor(StorageLensConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageLensConfiguration")
                    .unmarshallLocationName("StorageLensConfiguration").build()).build();

    private static final SdkField<List<StorageLensTag>> TAGS_FIELD = SdkField
            .<List<StorageLensTag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(PutStorageLensConfigurationRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags")
                    .unmarshallLocationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Tag")
                            .memberFieldInfo(
                                    SdkField.<StorageLensTag> builder(MarshallingType.SDK_POJO)
                                            .constructor(StorageLensTag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Tag").unmarshallLocationName("Tag").build()).build()).build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIG_ID_FIELD,
            ACCOUNT_ID_FIELD, STORAGE_LENS_CONFIGURATION_FIELD, TAGS_FIELD));

    private final String configId;

    private final String accountId;

    private final StorageLensConfiguration storageLensConfiguration;

    private final List<StorageLensTag> tags;

    private PutStorageLensConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.configId = builder.configId;
        this.accountId = builder.accountId;
        this.storageLensConfiguration = builder.storageLensConfiguration;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ID of the S3 Storage Lens configuration.
     * </p>
     * 
     * @return The ID of the S3 Storage Lens configuration.
     */
    public final String configId() {
        return configId;
    }

    /**
     * <p>
     * The account ID of the requester.
     * </p>
     * 
     * @return The account ID of the requester.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The S3 Storage Lens configuration.
     * </p>
     * 
     * @return The S3 Storage Lens configuration.
     */
    public final StorageLensConfiguration storageLensConfiguration() {
        return storageLensConfiguration;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tag set of the S3 Storage Lens configuration.
     * </p>
     * <note>
     * <p>
     * You can set up to a maximum of 50 tags.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tag set of the S3 Storage Lens configuration.</p> <note>
     *         <p>
     *         You can set up to a maximum of 50 tags.
     *         </p>
     */
    public final List<StorageLensTag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configId());
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(storageLensConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutStorageLensConfigurationRequest)) {
            return false;
        }
        PutStorageLensConfigurationRequest other = (PutStorageLensConfigurationRequest) obj;
        return Objects.equals(configId(), other.configId()) && Objects.equals(accountId(), other.accountId())
                && Objects.equals(storageLensConfiguration(), other.storageLensConfiguration()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutStorageLensConfigurationRequest").add("ConfigId", configId()).add("AccountId", accountId())
                .add("StorageLensConfiguration", storageLensConfiguration()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigId":
            return Optional.ofNullable(clazz.cast(configId()));
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "StorageLensConfiguration":
            return Optional.ofNullable(clazz.cast(storageLensConfiguration()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutStorageLensConfigurationRequest, T> g) {
        return obj -> g.apply((PutStorageLensConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends S3ControlRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutStorageLensConfigurationRequest> {
        /**
         * <p>
         * The ID of the S3 Storage Lens configuration.
         * </p>
         * 
         * @param configId
         *        The ID of the S3 Storage Lens configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configId(String configId);

        /**
         * <p>
         * The account ID of the requester.
         * </p>
         * 
         * @param accountId
         *        The account ID of the requester.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The S3 Storage Lens configuration.
         * </p>
         * 
         * @param storageLensConfiguration
         *        The S3 Storage Lens configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageLensConfiguration(StorageLensConfiguration storageLensConfiguration);

        /**
         * <p>
         * The S3 Storage Lens configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link StorageLensConfiguration.Builder} avoiding the
         * need to create one manually via {@link StorageLensConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link StorageLensConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #storageLensConfiguration(StorageLensConfiguration)}.
         * 
         * @param storageLensConfiguration
         *        a consumer that will call methods on {@link StorageLensConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storageLensConfiguration(StorageLensConfiguration)
         */
        default Builder storageLensConfiguration(Consumer<StorageLensConfiguration.Builder> storageLensConfiguration) {
            return storageLensConfiguration(StorageLensConfiguration.builder().applyMutation(storageLensConfiguration).build());
        }

        /**
         * <p>
         * The tag set of the S3 Storage Lens configuration.
         * </p>
         * <note>
         * <p>
         * You can set up to a maximum of 50 tags.
         * </p>
         * </note>
         * 
         * @param tags
         *        The tag set of the S3 Storage Lens configuration.</p> <note>
         *        <p>
         *        You can set up to a maximum of 50 tags.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<StorageLensTag> tags);

        /**
         * <p>
         * The tag set of the S3 Storage Lens configuration.
         * </p>
         * <note>
         * <p>
         * You can set up to a maximum of 50 tags.
         * </p>
         * </note>
         * 
         * @param tags
         *        The tag set of the S3 Storage Lens configuration.</p> <note>
         *        <p>
         *        You can set up to a maximum of 50 tags.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(StorageLensTag... tags);

        /**
         * <p>
         * The tag set of the S3 Storage Lens configuration.
         * </p>
         * <note>
         * <p>
         * You can set up to a maximum of 50 tags.
         * </p>
         * </note> This is a convenience that creates an instance of the {@link List<StorageLensTag>.Builder} avoiding
         * the need to create one manually via {@link List<StorageLensTag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StorageLensTag>.Builder#build()} is called immediately and
         * its result is passed to {@link #tags(List<StorageLensTag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<StorageLensTag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<StorageLensTag>)
         */
        Builder tags(Consumer<StorageLensTag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends S3ControlRequest.BuilderImpl implements Builder {
        private String configId;

        private String accountId;

        private StorageLensConfiguration storageLensConfiguration;

        private List<StorageLensTag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutStorageLensConfigurationRequest model) {
            super(model);
            configId(model.configId);
            accountId(model.accountId);
            storageLensConfiguration(model.storageLensConfiguration);
            tags(model.tags);
        }

        public final String getConfigId() {
            return configId;
        }

        @Override
        public final Builder configId(String configId) {
            this.configId = configId;
            return this;
        }

        public final void setConfigId(String configId) {
            this.configId = configId;
        }

        public final String getAccountId() {
            return accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final StorageLensConfiguration.Builder getStorageLensConfiguration() {
            return storageLensConfiguration != null ? storageLensConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder storageLensConfiguration(StorageLensConfiguration storageLensConfiguration) {
            this.storageLensConfiguration = storageLensConfiguration;
            return this;
        }

        public final void setStorageLensConfiguration(StorageLensConfiguration.BuilderImpl storageLensConfiguration) {
            this.storageLensConfiguration = storageLensConfiguration != null ? storageLensConfiguration.build() : null;
        }

        public final Collection<StorageLensTag.Builder> getTags() {
            if (tags instanceof SdkAutoConstructList) {
                return null;
            }
            return tags != null ? tags.stream().map(StorageLensTag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<StorageLensTag> tags) {
            this.tags = StorageLensTagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(StorageLensTag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<StorageLensTag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> StorageLensTag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<StorageLensTag.BuilderImpl> tags) {
            this.tags = StorageLensTagsCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutStorageLensConfigurationRequest build() {
            return new PutStorageLensConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
