/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the configuration parameters for a <code>Lambda Invoke</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LambdaInvokeOperation implements SdkPojo, Serializable,
        ToCopyableBuilder<LambdaInvokeOperation.Builder, LambdaInvokeOperation> {
    private static final SdkField<String> FUNCTION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("FunctionArn")
            .getter(getter(LambdaInvokeOperation::functionArn))
            .setter(setter(Builder::functionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionArn")
                    .unmarshallLocationName("FunctionArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String functionArn;

    private LambdaInvokeOperation(BuilderImpl builder) {
        this.functionArn = builder.functionArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the AWS Lambda function that the specified job will invoke on every object in
     * the manifest.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the AWS Lambda function that the specified job will invoke on every
     *         object in the manifest.
     */
    public final String functionArn() {
        return functionArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(functionArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaInvokeOperation)) {
            return false;
        }
        LambdaInvokeOperation other = (LambdaInvokeOperation) obj;
        return Objects.equals(functionArn(), other.functionArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LambdaInvokeOperation").add("FunctionArn", functionArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FunctionArn":
            return Optional.ofNullable(clazz.cast(functionArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LambdaInvokeOperation, T> g) {
        return obj -> g.apply((LambdaInvokeOperation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LambdaInvokeOperation> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for the AWS Lambda function that the specified job will invoke on every object
         * in the manifest.
         * </p>
         * 
         * @param functionArn
         *        The Amazon Resource Name (ARN) for the AWS Lambda function that the specified job will invoke on every
         *        object in the manifest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionArn(String functionArn);
    }

    static final class BuilderImpl implements Builder {
        private String functionArn;

        private BuilderImpl() {
        }

        private BuilderImpl(LambdaInvokeOperation model) {
            functionArn(model.functionArn);
        }

        public final String getFunctionArn() {
            return functionArn;
        }

        @Override
        public final Builder functionArn(String functionArn) {
            this.functionArn = functionArn;
            return this;
        }

        public final void setFunctionArn(String functionArn) {
            this.functionArn = functionArn;
        }

        @Override
        public LambdaInvokeOperation build() {
            return new LambdaInvokeOperation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
