/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.internal.interceptors;

import java.net.URI;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.arns.Arn;
import software.amazon.awssdk.auth.signer.AwsSignerExecutionAttribute;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.regions.PartitionMetadata;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.internal.resource.S3OutpostResource;
import software.amazon.awssdk.services.s3.internal.resource.S3Resource;
import software.amazon.awssdk.services.s3.internal.usearnregion.UseArnRegionProviderChain;
import software.amazon.awssdk.services.s3control.S3ControlConfiguration;
import software.amazon.awssdk.services.s3control.internal.HandlerUtils;
import software.amazon.awssdk.services.s3control.internal.S3ArnableField;
import software.amazon.awssdk.services.s3control.internal.S3ControlArnConverter;
import software.amazon.awssdk.services.s3control.internal.S3ControlInternalExecutionAttribute;
import software.amazon.awssdk.utils.StringUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class EndpointAddressInterceptor
implements ExecutionInterceptor {
    private static final String X_AMZ_OUTPOST_ID_HEADER = "x-amz-outpost-id";
    private static final UseArnRegionProviderChain USE_ARN_REGION_RESOLVER = UseArnRegionProviderChain.create();

    public SdkHttpRequest modifyHttpRequest(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        Optional<Arn> requestArn = this.getRequestArn(executionAttributes);
        if (requestArn.isPresent()) {
            return this.resolveHostForOutpostArnRequest(context.httpRequest(), executionAttributes, requestArn.get());
        }
        if (this.isNonArnOutpostRequest(context.request())) {
            return this.resolveHostForOutpostNonArnRequest(context.httpRequest(), executionAttributes);
        }
        return this.resolveHostForNonOutpostNonArnRequest(context.httpRequest(), executionAttributes);
    }

    private SdkHttpRequest resolveHostForOutpostArnRequest(SdkHttpRequest request, ExecutionAttributes executionAttributes, Arn arn) {
        S3Resource s3Resource = S3ControlArnConverter.getInstance().convertArn(arn);
        S3ControlConfiguration serviceConfig = this.getServiceConfig(executionAttributes);
        String signingRegion = ((Region)executionAttributes.getAttribute(AwsSignerExecutionAttribute.SIGNING_REGION)).id();
        String arnRegion = (String)s3Resource.region().orElseThrow(() -> new IllegalArgumentException("Region is missing from ARN."));
        String arnPartion = arn.partition();
        S3Resource parentS3Resource = s3Resource.parentS3Resource().orElse(null);
        Validate.isTrue((!this.isFipsInvolved(signingRegion, arnRegion, serviceConfig) ? 1 : 0) != 0, (String)"FIPS is not supported for outpost requests.", (Object[])new Object[0]);
        signingRegion = this.removeFipsIfNeeded(signingRegion);
        String signingPartition = PartitionMetadata.of((Region)Region.of((String)signingRegion)).id();
        S3OutpostResource outpostResource = (S3OutpostResource)Validate.isInstanceOf(S3OutpostResource.class, (Object)parentS3Resource, (String)"The ARN passed must have a parent outpost resource.", (Object[])new Object[0]);
        Validate.isTrue((!HandlerUtils.isDualstackEnabled(serviceConfig) ? 1 : 0) != 0, (String)"Dual stack endpoints are not supported for outpost requests.", (Object[])new Object[0]);
        Validate.isTrue((boolean)arnPartion.equals(signingPartition), (String)"The partition field of the ARN being passed as a bucket parameter to an S3 operation does not match the partition the client has been configured with. Provided partition: '%s'; client partition: '%s'.", (Object[])new Object[]{arnPartion, signingPartition});
        Validate.isTrue((this.useArnRegion(serviceConfig) || arnRegion.equals(signingRegion) ? 1 : 0) != 0, (String)"The region field of the ARN being passed as a bucket parameter to an operation does not match the region the client was configured with. Provided region: '%s'; client region: '%s'.", (Object[])new Object[]{arnRegion, signingRegion});
        executionAttributes.putAttribute(AwsSignerExecutionAttribute.SIGNING_REGION, (Object)Region.of((String)arnRegion));
        executionAttributes.putAttribute(AwsSignerExecutionAttribute.SERVICE_SIGNING_NAME, (Object)"s3-outposts");
        SdkHttpRequest.Builder requestBuilder = ((SdkHttpRequest.Builder)request.toBuilder()).appendHeader(X_AMZ_OUTPOST_ID_HEADER, outpostResource.outpostId());
        if (this.isEndpointOverridden(executionAttributes)) {
            requestBuilder.host(this.endpointOverride(executionAttributes).getHost());
        } else {
            String arnPartitionDnsSuffix = PartitionMetadata.of((String)arnPartion).dnsSuffix();
            requestBuilder.host(String.format("s3-outposts.%s.%s", arnRegion, arnPartitionDnsSuffix));
        }
        return (SdkHttpRequest)requestBuilder.build();
    }

    private SdkHttpRequest resolveHostForOutpostNonArnRequest(SdkHttpRequest sdkHttpRequest, ExecutionAttributes executionAttributes) {
        S3ControlConfiguration serviceConfig = this.getServiceConfig(executionAttributes);
        Region signingRegion = (Region)executionAttributes.getAttribute(AwsSignerExecutionAttribute.SIGNING_REGION);
        Validate.isTrue((!HandlerUtils.isDualstackEnabled(serviceConfig) ? 1 : 0) != 0, (String)"Dual stack is not supported for outpost requests.", (Object[])new Object[0]);
        Validate.isTrue((!HandlerUtils.isFipsEnabledInClientConfig(serviceConfig) && !HandlerUtils.isFipsRegion(signingRegion.id()) ? 1 : 0) != 0, (String)"FIPS endpoints are not supported for outpost requests.", (Object[])new Object[0]);
        executionAttributes.putAttribute(AwsSignerExecutionAttribute.SERVICE_SIGNING_NAME, (Object)"s3-outposts");
        if (this.isEndpointOverridden(executionAttributes)) {
            return sdkHttpRequest;
        }
        String signingDnsSuffix = PartitionMetadata.of((Region)signingRegion).dnsSuffix();
        return (SdkHttpRequest)sdkHttpRequest.copy(r -> r.host(String.format("s3-outposts.%s.%s", signingRegion, signingDnsSuffix)));
    }

    private SdkHttpRequest resolveHostForNonOutpostNonArnRequest(SdkHttpRequest request, ExecutionAttributes executionAttributes) {
        S3ControlConfiguration serviceConfig = this.getServiceConfig(executionAttributes);
        boolean isDualStackEnabled = HandlerUtils.isDualstackEnabled(serviceConfig);
        boolean isFipsEnabledInClient = HandlerUtils.isFipsEnabledInClientConfig(serviceConfig);
        Validate.isTrue((!isDualStackEnabled || !isFipsEnabledInClient ? 1 : 0) != 0, (String)"Dual stack and FIPS are not supported together.", (Object[])new Object[0]);
        if (this.isEndpointOverridden(executionAttributes)) {
            Validate.isTrue((!isDualStackEnabled ? 1 : 0) != 0, (String)"Dual stack is not supported with endpoint overrides.", (Object[])new Object[0]);
            Validate.isTrue((!isFipsEnabledInClient ? 1 : 0) != 0, (String)"FIPS is not supported with endpoint overrides.", (Object[])new Object[0]);
            return request;
        }
        if (isDualStackEnabled) {
            String newEndpointPrefix = String.format("%s.%s", "s3-control", "dualstack");
            return (SdkHttpRequest)request.copy(r -> r.host(request.host().replace("s3-control", newEndpointPrefix)));
        }
        if (isFipsEnabledInClient) {
            String newEndpointPrefix = String.format("%s-%s", "s3-control", "fips");
            return (SdkHttpRequest)request.copy(r -> r.host(request.host().replace("s3-control", newEndpointPrefix)));
        }
        return request;
    }

    private Optional<Arn> getRequestArn(ExecutionAttributes executionAttributes) {
        return Optional.ofNullable(executionAttributes.getAttribute(S3ControlInternalExecutionAttribute.S3_ARNABLE_FIELD)).map(S3ArnableField::arn);
    }

    private boolean isNonArnOutpostRequest(SdkRequest request) {
        return request.getValueForField("OutpostId", String.class).map(StringUtils::isNotBlank).orElse(false);
    }

    private S3ControlConfiguration getServiceConfig(ExecutionAttributes executionAttributes) {
        return (S3ControlConfiguration)executionAttributes.getAttribute(AwsSignerExecutionAttribute.SERVICE_CONFIG);
    }

    private boolean useArnRegion(S3ControlConfiguration configuration) {
        if (HandlerUtils.isUseArnRegionEnabledInClientConfig(configuration)) {
            return true;
        }
        return USE_ARN_REGION_RESOLVER.resolveUseArnRegion().orElse(false);
    }

    private boolean isEndpointOverridden(ExecutionAttributes executionAttributes) {
        return Boolean.TRUE.equals(executionAttributes.getAttribute(SdkExecutionAttribute.ENDPOINT_OVERRIDDEN));
    }

    private URI endpointOverride(ExecutionAttributes executionAttributes) {
        return (URI)executionAttributes.getAttribute(SdkExecutionAttribute.CLIENT_ENDPOINT);
    }

    private boolean isFipsInvolved(String signingRegion, String arnRegion, S3ControlConfiguration serviceConfig) {
        if (serviceConfig.fipsModeEnabled()) {
            return true;
        }
        return HandlerUtils.isFipsRegion(signingRegion) || HandlerUtils.isFipsRegion(arnRegion);
    }

    private String removeFipsIfNeeded(String region) {
        if (region.startsWith("fips-")) {
            return region.replace("fips-", "");
        }
        if (region.endsWith("-fips")) {
            return region.replace("-fips", "");
        }
        return region;
    }
}

