/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.arns.Arn;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.interceptor.SdkInternalExecutionAttribute;
import software.amazon.awssdk.core.interceptor.trait.HttpChecksumRequired;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.xml.AwsXmlProtocolFactory;
import software.amazon.awssdk.protocols.xml.XmlOperationMetadata;
import software.amazon.awssdk.services.s3.internal.resource.S3AccessPointResource;
import software.amazon.awssdk.services.s3.internal.resource.S3Resource;
import software.amazon.awssdk.services.s3control.S3ControlBucketResource;
import software.amazon.awssdk.services.s3control.S3ControlClient;
import software.amazon.awssdk.services.s3control.internal.S3ArnableField;
import software.amazon.awssdk.services.s3control.internal.S3ControlArnConverter;
import software.amazon.awssdk.services.s3control.internal.S3ControlInternalExecutionAttribute;
import software.amazon.awssdk.services.s3control.model.BadRequestException;
import software.amazon.awssdk.services.s3control.model.BucketAlreadyExistsException;
import software.amazon.awssdk.services.s3control.model.BucketAlreadyOwnedByYouException;
import software.amazon.awssdk.services.s3control.model.CreateAccessPointRequest;
import software.amazon.awssdk.services.s3control.model.CreateAccessPointResponse;
import software.amazon.awssdk.services.s3control.model.CreateBucketRequest;
import software.amazon.awssdk.services.s3control.model.CreateBucketResponse;
import software.amazon.awssdk.services.s3control.model.CreateJobRequest;
import software.amazon.awssdk.services.s3control.model.CreateJobResponse;
import software.amazon.awssdk.services.s3control.model.DeleteAccessPointPolicyRequest;
import software.amazon.awssdk.services.s3control.model.DeleteAccessPointPolicyResponse;
import software.amazon.awssdk.services.s3control.model.DeleteAccessPointRequest;
import software.amazon.awssdk.services.s3control.model.DeleteAccessPointResponse;
import software.amazon.awssdk.services.s3control.model.DeleteBucketLifecycleConfigurationRequest;
import software.amazon.awssdk.services.s3control.model.DeleteBucketLifecycleConfigurationResponse;
import software.amazon.awssdk.services.s3control.model.DeleteBucketPolicyRequest;
import software.amazon.awssdk.services.s3control.model.DeleteBucketPolicyResponse;
import software.amazon.awssdk.services.s3control.model.DeleteBucketRequest;
import software.amazon.awssdk.services.s3control.model.DeleteBucketResponse;
import software.amazon.awssdk.services.s3control.model.DeleteBucketTaggingRequest;
import software.amazon.awssdk.services.s3control.model.DeleteBucketTaggingResponse;
import software.amazon.awssdk.services.s3control.model.DeleteJobTaggingRequest;
import software.amazon.awssdk.services.s3control.model.DeleteJobTaggingResponse;
import software.amazon.awssdk.services.s3control.model.DeletePublicAccessBlockRequest;
import software.amazon.awssdk.services.s3control.model.DeletePublicAccessBlockResponse;
import software.amazon.awssdk.services.s3control.model.DescribeJobRequest;
import software.amazon.awssdk.services.s3control.model.DescribeJobResponse;
import software.amazon.awssdk.services.s3control.model.GetAccessPointPolicyRequest;
import software.amazon.awssdk.services.s3control.model.GetAccessPointPolicyResponse;
import software.amazon.awssdk.services.s3control.model.GetAccessPointPolicyStatusRequest;
import software.amazon.awssdk.services.s3control.model.GetAccessPointPolicyStatusResponse;
import software.amazon.awssdk.services.s3control.model.GetAccessPointRequest;
import software.amazon.awssdk.services.s3control.model.GetAccessPointResponse;
import software.amazon.awssdk.services.s3control.model.GetBucketLifecycleConfigurationRequest;
import software.amazon.awssdk.services.s3control.model.GetBucketLifecycleConfigurationResponse;
import software.amazon.awssdk.services.s3control.model.GetBucketPolicyRequest;
import software.amazon.awssdk.services.s3control.model.GetBucketPolicyResponse;
import software.amazon.awssdk.services.s3control.model.GetBucketRequest;
import software.amazon.awssdk.services.s3control.model.GetBucketResponse;
import software.amazon.awssdk.services.s3control.model.GetBucketTaggingRequest;
import software.amazon.awssdk.services.s3control.model.GetBucketTaggingResponse;
import software.amazon.awssdk.services.s3control.model.GetJobTaggingRequest;
import software.amazon.awssdk.services.s3control.model.GetJobTaggingResponse;
import software.amazon.awssdk.services.s3control.model.GetPublicAccessBlockRequest;
import software.amazon.awssdk.services.s3control.model.GetPublicAccessBlockResponse;
import software.amazon.awssdk.services.s3control.model.IdempotencyException;
import software.amazon.awssdk.services.s3control.model.InternalServiceException;
import software.amazon.awssdk.services.s3control.model.InvalidNextTokenException;
import software.amazon.awssdk.services.s3control.model.InvalidRequestException;
import software.amazon.awssdk.services.s3control.model.JobStatusException;
import software.amazon.awssdk.services.s3control.model.ListAccessPointsRequest;
import software.amazon.awssdk.services.s3control.model.ListAccessPointsResponse;
import software.amazon.awssdk.services.s3control.model.ListJobsRequest;
import software.amazon.awssdk.services.s3control.model.ListJobsResponse;
import software.amazon.awssdk.services.s3control.model.ListRegionalBucketsRequest;
import software.amazon.awssdk.services.s3control.model.ListRegionalBucketsResponse;
import software.amazon.awssdk.services.s3control.model.NoSuchPublicAccessBlockConfigurationException;
import software.amazon.awssdk.services.s3control.model.NotFoundException;
import software.amazon.awssdk.services.s3control.model.PutAccessPointPolicyRequest;
import software.amazon.awssdk.services.s3control.model.PutAccessPointPolicyResponse;
import software.amazon.awssdk.services.s3control.model.PutBucketLifecycleConfigurationRequest;
import software.amazon.awssdk.services.s3control.model.PutBucketLifecycleConfigurationResponse;
import software.amazon.awssdk.services.s3control.model.PutBucketPolicyRequest;
import software.amazon.awssdk.services.s3control.model.PutBucketPolicyResponse;
import software.amazon.awssdk.services.s3control.model.PutBucketTaggingRequest;
import software.amazon.awssdk.services.s3control.model.PutBucketTaggingResponse;
import software.amazon.awssdk.services.s3control.model.PutJobTaggingRequest;
import software.amazon.awssdk.services.s3control.model.PutJobTaggingResponse;
import software.amazon.awssdk.services.s3control.model.PutPublicAccessBlockRequest;
import software.amazon.awssdk.services.s3control.model.PutPublicAccessBlockResponse;
import software.amazon.awssdk.services.s3control.model.S3ControlException;
import software.amazon.awssdk.services.s3control.model.S3ControlRequest;
import software.amazon.awssdk.services.s3control.model.TooManyRequestsException;
import software.amazon.awssdk.services.s3control.model.TooManyTagsException;
import software.amazon.awssdk.services.s3control.model.UpdateJobPriorityRequest;
import software.amazon.awssdk.services.s3control.model.UpdateJobPriorityResponse;
import software.amazon.awssdk.services.s3control.model.UpdateJobStatusRequest;
import software.amazon.awssdk.services.s3control.model.UpdateJobStatusResponse;
import software.amazon.awssdk.services.s3control.paginators.ListAccessPointsIterable;
import software.amazon.awssdk.services.s3control.paginators.ListJobsIterable;
import software.amazon.awssdk.services.s3control.paginators.ListRegionalBucketsIterable;
import software.amazon.awssdk.services.s3control.transform.CreateAccessPointRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.CreateBucketRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.CreateJobRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DeleteAccessPointPolicyRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DeleteAccessPointRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DeleteBucketLifecycleConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DeleteBucketPolicyRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DeleteBucketRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DeleteBucketTaggingRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DeleteJobTaggingRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DeletePublicAccessBlockRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DescribeJobRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetAccessPointPolicyRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetAccessPointPolicyStatusRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetAccessPointRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetBucketLifecycleConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetBucketPolicyRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetBucketRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetBucketTaggingRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetJobTaggingRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetPublicAccessBlockRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.ListAccessPointsRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.ListJobsRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.ListRegionalBucketsRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.PutAccessPointPolicyRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.PutBucketLifecycleConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.PutBucketPolicyRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.PutBucketTaggingRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.PutJobTaggingRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.PutPublicAccessBlockRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.UpdateJobPriorityRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.UpdateJobStatusRequestMarshaller;
import software.amazon.awssdk.utils.HostnameValidator;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultS3ControlClient
implements S3ControlClient {
    private static final Logger log = Logger.loggerFor(DefaultS3ControlClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsXmlProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultS3ControlClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init();
    }

    public final String serviceName() {
        return "s3";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAccessPointResponse createAccessPoint(CreateAccessPointRequest createAccessPointRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateAccessPointResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, createAccessPointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAccessPoint");
            String bucket = createAccessPointRequest.bucket();
            Arn arn = null;
            if (bucket != null && bucket.startsWith("arn:")) {
                arn = Arn.fromString((String)bucket);
                S3Resource s3Resource = S3ControlArnConverter.getInstance().convertArn(arn);
                if (!(s3Resource instanceof S3ControlBucketResource)) {
                    throw new IllegalArgumentException(String.format("Unsupported ARN type: %s", s3Resource.type()));
                }
                S3ControlBucketResource resource = (S3ControlBucketResource)s3Resource;
                String accountId = createAccessPointRequest.accountId();
                String accountIdInArn = resource.accountId().orElseThrow(() -> new IllegalArgumentException("accountId cannot be null"));
                if (accountId != null && !accountId.equals(accountIdInArn)) {
                    throw new IllegalArgumentException(String.format("%s field provided from the request (%s) is different from the one in the ARN (%s)", "accountId", accountId, accountIdInArn));
                }
                createAccessPointRequest = (CreateAccessPointRequest)((Object)createAccessPointRequest.toBuilder().bucket(resource.bucketName()).accountId(accountIdInArn).build());
            }
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)createAccessPointRequest.accountId(), (String)"AccountId", (String)"createAccessPointRequest");
            String resolvedHostExpression = String.format("%s.", createAccessPointRequest.accountId());
            CreateAccessPointResponse createAccessPointResponse = (CreateAccessPointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAccessPoint").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)createAccessPointRequest).putExecutionAttribute(S3ControlInternalExecutionAttribute.S3_ARNABLE_FIELD, (Object)S3ArnableField.builder().arn(arn).build()).withMarshaller((Marshaller)new CreateAccessPointRequestMarshaller(this.protocolFactory)));
            return createAccessPointResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$createAccessPoint$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateBucketResponse createBucket(CreateBucketRequest createBucketRequest) throws BucketAlreadyExistsException, BucketAlreadyOwnedByYouException, AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateBucketResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, createBucketRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateBucket");
            CreateBucketResponse createBucketResponse = (CreateBucketResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateBucket").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createBucketRequest).putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED, (Object)HttpChecksumRequired.create()).withMarshaller((Marshaller)new CreateBucketRequestMarshaller(this.protocolFactory)));
            return createBucketResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$createBucket$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateJobResponse createJob(CreateJobRequest createJobRequest) throws TooManyRequestsException, BadRequestException, IdempotencyException, InternalServiceException, AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateJobResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, createJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateJob");
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)createJobRequest.accountId(), (String)"AccountId", (String)"createJobRequest");
            String resolvedHostExpression = String.format("%s.", createJobRequest.accountId());
            CreateJobResponse createJobResponse = (CreateJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateJob").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)createJobRequest).withMarshaller((Marshaller)new CreateJobRequestMarshaller(this.protocolFactory)));
            return createJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$createJob$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAccessPointResponse deleteAccessPoint(DeleteAccessPointRequest deleteAccessPointRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteAccessPointResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, deleteAccessPointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAccessPoint");
            String name = deleteAccessPointRequest.name();
            Arn arn = null;
            if (name != null && name.startsWith("arn:")) {
                arn = Arn.fromString((String)name);
                S3Resource s3Resource = S3ControlArnConverter.getInstance().convertArn(arn);
                if (!(s3Resource instanceof S3AccessPointResource)) {
                    throw new IllegalArgumentException(String.format("Unsupported ARN type: %s", s3Resource.type()));
                }
                S3AccessPointResource resource = (S3AccessPointResource)s3Resource;
                String accountId = deleteAccessPointRequest.accountId();
                String accountIdInArn = (String)resource.accountId().orElseThrow(() -> new IllegalArgumentException("accountId cannot be null"));
                if (accountId != null && !accountId.equals(accountIdInArn)) {
                    throw new IllegalArgumentException(String.format("%s field provided from the request (%s) is different from the one in the ARN (%s)", "accountId", accountId, accountIdInArn));
                }
                deleteAccessPointRequest = (DeleteAccessPointRequest)((Object)deleteAccessPointRequest.toBuilder().name(resource.accessPointName()).accountId(accountIdInArn).build());
            }
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)deleteAccessPointRequest.accountId(), (String)"AccountId", (String)"deleteAccessPointRequest");
            String resolvedHostExpression = String.format("%s.", deleteAccessPointRequest.accountId());
            DeleteAccessPointResponse deleteAccessPointResponse = (DeleteAccessPointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAccessPoint").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)deleteAccessPointRequest).putExecutionAttribute(S3ControlInternalExecutionAttribute.S3_ARNABLE_FIELD, (Object)S3ArnableField.builder().arn(arn).build()).withMarshaller((Marshaller)new DeleteAccessPointRequestMarshaller(this.protocolFactory)));
            return deleteAccessPointResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$deleteAccessPoint$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAccessPointPolicyResponse deleteAccessPointPolicy(DeleteAccessPointPolicyRequest deleteAccessPointPolicyRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteAccessPointPolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, deleteAccessPointPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAccessPointPolicy");
            String name = deleteAccessPointPolicyRequest.name();
            Arn arn = null;
            if (name != null && name.startsWith("arn:")) {
                arn = Arn.fromString((String)name);
                S3Resource s3Resource = S3ControlArnConverter.getInstance().convertArn(arn);
                if (!(s3Resource instanceof S3AccessPointResource)) {
                    throw new IllegalArgumentException(String.format("Unsupported ARN type: %s", s3Resource.type()));
                }
                S3AccessPointResource resource = (S3AccessPointResource)s3Resource;
                String accountId = deleteAccessPointPolicyRequest.accountId();
                String accountIdInArn = (String)resource.accountId().orElseThrow(() -> new IllegalArgumentException("accountId cannot be null"));
                if (accountId != null && !accountId.equals(accountIdInArn)) {
                    throw new IllegalArgumentException(String.format("%s field provided from the request (%s) is different from the one in the ARN (%s)", "accountId", accountId, accountIdInArn));
                }
                deleteAccessPointPolicyRequest = (DeleteAccessPointPolicyRequest)((Object)deleteAccessPointPolicyRequest.toBuilder().name(resource.accessPointName()).accountId(accountIdInArn).build());
            }
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)deleteAccessPointPolicyRequest.accountId(), (String)"AccountId", (String)"deleteAccessPointPolicyRequest");
            String resolvedHostExpression = String.format("%s.", deleteAccessPointPolicyRequest.accountId());
            DeleteAccessPointPolicyResponse deleteAccessPointPolicyResponse = (DeleteAccessPointPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAccessPointPolicy").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)deleteAccessPointPolicyRequest).putExecutionAttribute(S3ControlInternalExecutionAttribute.S3_ARNABLE_FIELD, (Object)S3ArnableField.builder().arn(arn).build()).withMarshaller((Marshaller)new DeleteAccessPointPolicyRequestMarshaller(this.protocolFactory)));
            return deleteAccessPointPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$deleteAccessPointPolicy$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteBucketResponse deleteBucket(DeleteBucketRequest deleteBucketRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteBucketResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, deleteBucketRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteBucket");
            String bucket = deleteBucketRequest.bucket();
            Arn arn = null;
            if (bucket != null && bucket.startsWith("arn:")) {
                arn = Arn.fromString((String)bucket);
                S3Resource s3Resource = S3ControlArnConverter.getInstance().convertArn(arn);
                if (!(s3Resource instanceof S3ControlBucketResource)) {
                    throw new IllegalArgumentException(String.format("Unsupported ARN type: %s", s3Resource.type()));
                }
                S3ControlBucketResource resource = (S3ControlBucketResource)s3Resource;
                String accountId = deleteBucketRequest.accountId();
                String accountIdInArn = resource.accountId().orElseThrow(() -> new IllegalArgumentException("accountId cannot be null"));
                if (accountId != null && !accountId.equals(accountIdInArn)) {
                    throw new IllegalArgumentException(String.format("%s field provided from the request (%s) is different from the one in the ARN (%s)", "accountId", accountId, accountIdInArn));
                }
                deleteBucketRequest = (DeleteBucketRequest)((Object)deleteBucketRequest.toBuilder().bucket(resource.bucketName()).accountId(accountIdInArn).build());
            }
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)deleteBucketRequest.accountId(), (String)"AccountId", (String)"deleteBucketRequest");
            String resolvedHostExpression = String.format("%s.", deleteBucketRequest.accountId());
            DeleteBucketResponse deleteBucketResponse = (DeleteBucketResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBucket").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)deleteBucketRequest).putExecutionAttribute(S3ControlInternalExecutionAttribute.S3_ARNABLE_FIELD, (Object)S3ArnableField.builder().arn(arn).build()).withMarshaller((Marshaller)new DeleteBucketRequestMarshaller(this.protocolFactory)));
            return deleteBucketResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$deleteBucket$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteBucketLifecycleConfigurationResponse deleteBucketLifecycleConfiguration(DeleteBucketLifecycleConfigurationRequest deleteBucketLifecycleConfigurationRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteBucketLifecycleConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, deleteBucketLifecycleConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteBucketLifecycleConfiguration");
            String bucket = deleteBucketLifecycleConfigurationRequest.bucket();
            Arn arn = null;
            if (bucket != null && bucket.startsWith("arn:")) {
                arn = Arn.fromString((String)bucket);
                S3Resource s3Resource = S3ControlArnConverter.getInstance().convertArn(arn);
                if (!(s3Resource instanceof S3ControlBucketResource)) {
                    throw new IllegalArgumentException(String.format("Unsupported ARN type: %s", s3Resource.type()));
                }
                S3ControlBucketResource resource = (S3ControlBucketResource)s3Resource;
                String accountId = deleteBucketLifecycleConfigurationRequest.accountId();
                String accountIdInArn = resource.accountId().orElseThrow(() -> new IllegalArgumentException("accountId cannot be null"));
                if (accountId != null && !accountId.equals(accountIdInArn)) {
                    throw new IllegalArgumentException(String.format("%s field provided from the request (%s) is different from the one in the ARN (%s)", "accountId", accountId, accountIdInArn));
                }
                deleteBucketLifecycleConfigurationRequest = (DeleteBucketLifecycleConfigurationRequest)((Object)deleteBucketLifecycleConfigurationRequest.toBuilder().bucket(resource.bucketName()).accountId(accountIdInArn).build());
            }
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)deleteBucketLifecycleConfigurationRequest.accountId(), (String)"AccountId", (String)"deleteBucketLifecycleConfigurationRequest");
            String resolvedHostExpression = String.format("%s.", deleteBucketLifecycleConfigurationRequest.accountId());
            DeleteBucketLifecycleConfigurationResponse deleteBucketLifecycleConfigurationResponse = (DeleteBucketLifecycleConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBucketLifecycleConfiguration").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)deleteBucketLifecycleConfigurationRequest).putExecutionAttribute(S3ControlInternalExecutionAttribute.S3_ARNABLE_FIELD, (Object)S3ArnableField.builder().arn(arn).build()).withMarshaller((Marshaller)new DeleteBucketLifecycleConfigurationRequestMarshaller(this.protocolFactory)));
            return deleteBucketLifecycleConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$deleteBucketLifecycleConfiguration$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteBucketPolicyResponse deleteBucketPolicy(DeleteBucketPolicyRequest deleteBucketPolicyRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteBucketPolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, deleteBucketPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteBucketPolicy");
            String bucket = deleteBucketPolicyRequest.bucket();
            Arn arn = null;
            if (bucket != null && bucket.startsWith("arn:")) {
                arn = Arn.fromString((String)bucket);
                S3Resource s3Resource = S3ControlArnConverter.getInstance().convertArn(arn);
                if (!(s3Resource instanceof S3ControlBucketResource)) {
                    throw new IllegalArgumentException(String.format("Unsupported ARN type: %s", s3Resource.type()));
                }
                S3ControlBucketResource resource = (S3ControlBucketResource)s3Resource;
                String accountId = deleteBucketPolicyRequest.accountId();
                String accountIdInArn = resource.accountId().orElseThrow(() -> new IllegalArgumentException("accountId cannot be null"));
                if (accountId != null && !accountId.equals(accountIdInArn)) {
                    throw new IllegalArgumentException(String.format("%s field provided from the request (%s) is different from the one in the ARN (%s)", "accountId", accountId, accountIdInArn));
                }
                deleteBucketPolicyRequest = (DeleteBucketPolicyRequest)((Object)deleteBucketPolicyRequest.toBuilder().bucket(resource.bucketName()).accountId(accountIdInArn).build());
            }
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)deleteBucketPolicyRequest.accountId(), (String)"AccountId", (String)"deleteBucketPolicyRequest");
            String resolvedHostExpression = String.format("%s.", deleteBucketPolicyRequest.accountId());
            DeleteBucketPolicyResponse deleteBucketPolicyResponse = (DeleteBucketPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBucketPolicy").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)deleteBucketPolicyRequest).putExecutionAttribute(S3ControlInternalExecutionAttribute.S3_ARNABLE_FIELD, (Object)S3ArnableField.builder().arn(arn).build()).withMarshaller((Marshaller)new DeleteBucketPolicyRequestMarshaller(this.protocolFactory)));
            return deleteBucketPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$deleteBucketPolicy$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteBucketTaggingResponse deleteBucketTagging(DeleteBucketTaggingRequest deleteBucketTaggingRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteBucketTaggingResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, deleteBucketTaggingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteBucketTagging");
            String bucket = deleteBucketTaggingRequest.bucket();
            Arn arn = null;
            if (bucket != null && bucket.startsWith("arn:")) {
                arn = Arn.fromString((String)bucket);
                S3Resource s3Resource = S3ControlArnConverter.getInstance().convertArn(arn);
                if (!(s3Resource instanceof S3ControlBucketResource)) {
                    throw new IllegalArgumentException(String.format("Unsupported ARN type: %s", s3Resource.type()));
                }
                S3ControlBucketResource resource = (S3ControlBucketResource)s3Resource;
                String accountId = deleteBucketTaggingRequest.accountId();
                String accountIdInArn = resource.accountId().orElseThrow(() -> new IllegalArgumentException("accountId cannot be null"));
                if (accountId != null && !accountId.equals(accountIdInArn)) {
                    throw new IllegalArgumentException(String.format("%s field provided from the request (%s) is different from the one in the ARN (%s)", "accountId", accountId, accountIdInArn));
                }
                deleteBucketTaggingRequest = (DeleteBucketTaggingRequest)((Object)deleteBucketTaggingRequest.toBuilder().bucket(resource.bucketName()).accountId(accountIdInArn).build());
            }
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)deleteBucketTaggingRequest.accountId(), (String)"AccountId", (String)"deleteBucketTaggingRequest");
            String resolvedHostExpression = String.format("%s.", deleteBucketTaggingRequest.accountId());
            DeleteBucketTaggingResponse deleteBucketTaggingResponse = (DeleteBucketTaggingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBucketTagging").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)deleteBucketTaggingRequest).putExecutionAttribute(S3ControlInternalExecutionAttribute.S3_ARNABLE_FIELD, (Object)S3ArnableField.builder().arn(arn).build()).withMarshaller((Marshaller)new DeleteBucketTaggingRequestMarshaller(this.protocolFactory)));
            return deleteBucketTaggingResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$deleteBucketTagging$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteJobTaggingResponse deleteJobTagging(DeleteJobTaggingRequest deleteJobTaggingRequest) throws InternalServiceException, TooManyRequestsException, NotFoundException, AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteJobTaggingResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, deleteJobTaggingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteJobTagging");
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)deleteJobTaggingRequest.accountId(), (String)"AccountId", (String)"deleteJobTaggingRequest");
            String resolvedHostExpression = String.format("%s.", deleteJobTaggingRequest.accountId());
            DeleteJobTaggingResponse deleteJobTaggingResponse = (DeleteJobTaggingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteJobTagging").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)deleteJobTaggingRequest).withMarshaller((Marshaller)new DeleteJobTaggingRequestMarshaller(this.protocolFactory)));
            return deleteJobTaggingResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$deleteJobTagging$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeletePublicAccessBlockResponse deletePublicAccessBlock(DeletePublicAccessBlockRequest deletePublicAccessBlockRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeletePublicAccessBlockResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, deletePublicAccessBlockRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeletePublicAccessBlock");
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)deletePublicAccessBlockRequest.accountId(), (String)"AccountId", (String)"deletePublicAccessBlockRequest");
            String resolvedHostExpression = String.format("%s.", deletePublicAccessBlockRequest.accountId());
            DeletePublicAccessBlockResponse deletePublicAccessBlockResponse = (DeletePublicAccessBlockResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePublicAccessBlock").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)deletePublicAccessBlockRequest).withMarshaller((Marshaller)new DeletePublicAccessBlockRequestMarshaller(this.protocolFactory)));
            return deletePublicAccessBlockResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$deletePublicAccessBlock$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeJobResponse describeJob(DescribeJobRequest describeJobRequest) throws BadRequestException, TooManyRequestsException, NotFoundException, InternalServiceException, AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DescribeJobResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, describeJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeJob");
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)describeJobRequest.accountId(), (String)"AccountId", (String)"describeJobRequest");
            String resolvedHostExpression = String.format("%s.", describeJobRequest.accountId());
            DescribeJobResponse describeJobResponse = (DescribeJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeJob").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)describeJobRequest).withMarshaller((Marshaller)new DescribeJobRequestMarshaller(this.protocolFactory)));
            return describeJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$describeJob$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAccessPointResponse getAccessPoint(GetAccessPointRequest getAccessPointRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetAccessPointResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, getAccessPointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAccessPoint");
            String name = getAccessPointRequest.name();
            Arn arn = null;
            if (name != null && name.startsWith("arn:")) {
                arn = Arn.fromString((String)name);
                S3Resource s3Resource = S3ControlArnConverter.getInstance().convertArn(arn);
                if (!(s3Resource instanceof S3AccessPointResource)) {
                    throw new IllegalArgumentException(String.format("Unsupported ARN type: %s", s3Resource.type()));
                }
                S3AccessPointResource resource = (S3AccessPointResource)s3Resource;
                String accountId = getAccessPointRequest.accountId();
                String accountIdInArn = (String)resource.accountId().orElseThrow(() -> new IllegalArgumentException("accountId cannot be null"));
                if (accountId != null && !accountId.equals(accountIdInArn)) {
                    throw new IllegalArgumentException(String.format("%s field provided from the request (%s) is different from the one in the ARN (%s)", "accountId", accountId, accountIdInArn));
                }
                getAccessPointRequest = (GetAccessPointRequest)((Object)getAccessPointRequest.toBuilder().name(resource.accessPointName()).accountId(accountIdInArn).build());
            }
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)getAccessPointRequest.accountId(), (String)"AccountId", (String)"getAccessPointRequest");
            String resolvedHostExpression = String.format("%s.", getAccessPointRequest.accountId());
            GetAccessPointResponse getAccessPointResponse = (GetAccessPointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAccessPoint").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)getAccessPointRequest).putExecutionAttribute(S3ControlInternalExecutionAttribute.S3_ARNABLE_FIELD, (Object)S3ArnableField.builder().arn(arn).build()).withMarshaller((Marshaller)new GetAccessPointRequestMarshaller(this.protocolFactory)));
            return getAccessPointResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$getAccessPoint$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAccessPointPolicyResponse getAccessPointPolicy(GetAccessPointPolicyRequest getAccessPointPolicyRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetAccessPointPolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, getAccessPointPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAccessPointPolicy");
            String name = getAccessPointPolicyRequest.name();
            Arn arn = null;
            if (name != null && name.startsWith("arn:")) {
                arn = Arn.fromString((String)name);
                S3Resource s3Resource = S3ControlArnConverter.getInstance().convertArn(arn);
                if (!(s3Resource instanceof S3AccessPointResource)) {
                    throw new IllegalArgumentException(String.format("Unsupported ARN type: %s", s3Resource.type()));
                }
                S3AccessPointResource resource = (S3AccessPointResource)s3Resource;
                String accountId = getAccessPointPolicyRequest.accountId();
                String accountIdInArn = (String)resource.accountId().orElseThrow(() -> new IllegalArgumentException("accountId cannot be null"));
                if (accountId != null && !accountId.equals(accountIdInArn)) {
                    throw new IllegalArgumentException(String.format("%s field provided from the request (%s) is different from the one in the ARN (%s)", "accountId", accountId, accountIdInArn));
                }
                getAccessPointPolicyRequest = (GetAccessPointPolicyRequest)((Object)getAccessPointPolicyRequest.toBuilder().name(resource.accessPointName()).accountId(accountIdInArn).build());
            }
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)getAccessPointPolicyRequest.accountId(), (String)"AccountId", (String)"getAccessPointPolicyRequest");
            String resolvedHostExpression = String.format("%s.", getAccessPointPolicyRequest.accountId());
            GetAccessPointPolicyResponse getAccessPointPolicyResponse = (GetAccessPointPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAccessPointPolicy").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)getAccessPointPolicyRequest).putExecutionAttribute(S3ControlInternalExecutionAttribute.S3_ARNABLE_FIELD, (Object)S3ArnableField.builder().arn(arn).build()).withMarshaller((Marshaller)new GetAccessPointPolicyRequestMarshaller(this.protocolFactory)));
            return getAccessPointPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$getAccessPointPolicy$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAccessPointPolicyStatusResponse getAccessPointPolicyStatus(GetAccessPointPolicyStatusRequest getAccessPointPolicyStatusRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetAccessPointPolicyStatusResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, getAccessPointPolicyStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAccessPointPolicyStatus");
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)getAccessPointPolicyStatusRequest.accountId(), (String)"AccountId", (String)"getAccessPointPolicyStatusRequest");
            String resolvedHostExpression = String.format("%s.", getAccessPointPolicyStatusRequest.accountId());
            GetAccessPointPolicyStatusResponse getAccessPointPolicyStatusResponse = (GetAccessPointPolicyStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAccessPointPolicyStatus").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)getAccessPointPolicyStatusRequest).withMarshaller((Marshaller)new GetAccessPointPolicyStatusRequestMarshaller(this.protocolFactory)));
            return getAccessPointPolicyStatusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$getAccessPointPolicyStatus$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetBucketResponse getBucket(GetBucketRequest getBucketRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, getBucketRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetBucket");
            String bucket = getBucketRequest.bucket();
            Arn arn = null;
            if (bucket != null && bucket.startsWith("arn:")) {
                arn = Arn.fromString((String)bucket);
                S3Resource s3Resource = S3ControlArnConverter.getInstance().convertArn(arn);
                if (!(s3Resource instanceof S3ControlBucketResource)) {
                    throw new IllegalArgumentException(String.format("Unsupported ARN type: %s", s3Resource.type()));
                }
                S3ControlBucketResource resource = (S3ControlBucketResource)s3Resource;
                String accountId = getBucketRequest.accountId();
                String accountIdInArn = resource.accountId().orElseThrow(() -> new IllegalArgumentException("accountId cannot be null"));
                if (accountId != null && !accountId.equals(accountIdInArn)) {
                    throw new IllegalArgumentException(String.format("%s field provided from the request (%s) is different from the one in the ARN (%s)", "accountId", accountId, accountIdInArn));
                }
                getBucketRequest = (GetBucketRequest)((Object)getBucketRequest.toBuilder().bucket(resource.bucketName()).accountId(accountIdInArn).build());
            }
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)getBucketRequest.accountId(), (String)"AccountId", (String)"getBucketRequest");
            String resolvedHostExpression = String.format("%s.", getBucketRequest.accountId());
            GetBucketResponse getBucketResponse = (GetBucketResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucket").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)getBucketRequest).putExecutionAttribute(S3ControlInternalExecutionAttribute.S3_ARNABLE_FIELD, (Object)S3ArnableField.builder().arn(arn).build()).withMarshaller((Marshaller)new GetBucketRequestMarshaller(this.protocolFactory)));
            return getBucketResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$getBucket$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetBucketLifecycleConfigurationResponse getBucketLifecycleConfiguration(GetBucketLifecycleConfigurationRequest getBucketLifecycleConfigurationRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketLifecycleConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, getBucketLifecycleConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetBucketLifecycleConfiguration");
            String bucket = getBucketLifecycleConfigurationRequest.bucket();
            Arn arn = null;
            if (bucket != null && bucket.startsWith("arn:")) {
                arn = Arn.fromString((String)bucket);
                S3Resource s3Resource = S3ControlArnConverter.getInstance().convertArn(arn);
                if (!(s3Resource instanceof S3ControlBucketResource)) {
                    throw new IllegalArgumentException(String.format("Unsupported ARN type: %s", s3Resource.type()));
                }
                S3ControlBucketResource resource = (S3ControlBucketResource)s3Resource;
                String accountId = getBucketLifecycleConfigurationRequest.accountId();
                String accountIdInArn = resource.accountId().orElseThrow(() -> new IllegalArgumentException("accountId cannot be null"));
                if (accountId != null && !accountId.equals(accountIdInArn)) {
                    throw new IllegalArgumentException(String.format("%s field provided from the request (%s) is different from the one in the ARN (%s)", "accountId", accountId, accountIdInArn));
                }
                getBucketLifecycleConfigurationRequest = (GetBucketLifecycleConfigurationRequest)((Object)getBucketLifecycleConfigurationRequest.toBuilder().bucket(resource.bucketName()).accountId(accountIdInArn).build());
            }
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)getBucketLifecycleConfigurationRequest.accountId(), (String)"AccountId", (String)"getBucketLifecycleConfigurationRequest");
            String resolvedHostExpression = String.format("%s.", getBucketLifecycleConfigurationRequest.accountId());
            GetBucketLifecycleConfigurationResponse getBucketLifecycleConfigurationResponse = (GetBucketLifecycleConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketLifecycleConfiguration").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)getBucketLifecycleConfigurationRequest).putExecutionAttribute(S3ControlInternalExecutionAttribute.S3_ARNABLE_FIELD, (Object)S3ArnableField.builder().arn(arn).build()).withMarshaller((Marshaller)new GetBucketLifecycleConfigurationRequestMarshaller(this.protocolFactory)));
            return getBucketLifecycleConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$getBucketLifecycleConfiguration$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetBucketPolicyResponse getBucketPolicy(GetBucketPolicyRequest getBucketPolicyRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketPolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, getBucketPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetBucketPolicy");
            String bucket = getBucketPolicyRequest.bucket();
            Arn arn = null;
            if (bucket != null && bucket.startsWith("arn:")) {
                arn = Arn.fromString((String)bucket);
                S3Resource s3Resource = S3ControlArnConverter.getInstance().convertArn(arn);
                if (!(s3Resource instanceof S3ControlBucketResource)) {
                    throw new IllegalArgumentException(String.format("Unsupported ARN type: %s", s3Resource.type()));
                }
                S3ControlBucketResource resource = (S3ControlBucketResource)s3Resource;
                String accountId = getBucketPolicyRequest.accountId();
                String accountIdInArn = resource.accountId().orElseThrow(() -> new IllegalArgumentException("accountId cannot be null"));
                if (accountId != null && !accountId.equals(accountIdInArn)) {
                    throw new IllegalArgumentException(String.format("%s field provided from the request (%s) is different from the one in the ARN (%s)", "accountId", accountId, accountIdInArn));
                }
                getBucketPolicyRequest = (GetBucketPolicyRequest)((Object)getBucketPolicyRequest.toBuilder().bucket(resource.bucketName()).accountId(accountIdInArn).build());
            }
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)getBucketPolicyRequest.accountId(), (String)"AccountId", (String)"getBucketPolicyRequest");
            String resolvedHostExpression = String.format("%s.", getBucketPolicyRequest.accountId());
            GetBucketPolicyResponse getBucketPolicyResponse = (GetBucketPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketPolicy").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)getBucketPolicyRequest).putExecutionAttribute(S3ControlInternalExecutionAttribute.S3_ARNABLE_FIELD, (Object)S3ArnableField.builder().arn(arn).build()).withMarshaller((Marshaller)new GetBucketPolicyRequestMarshaller(this.protocolFactory)));
            return getBucketPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$getBucketPolicy$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetBucketTaggingResponse getBucketTagging(GetBucketTaggingRequest getBucketTaggingRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketTaggingResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, getBucketTaggingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetBucketTagging");
            String bucket = getBucketTaggingRequest.bucket();
            Arn arn = null;
            if (bucket != null && bucket.startsWith("arn:")) {
                arn = Arn.fromString((String)bucket);
                S3Resource s3Resource = S3ControlArnConverter.getInstance().convertArn(arn);
                if (!(s3Resource instanceof S3ControlBucketResource)) {
                    throw new IllegalArgumentException(String.format("Unsupported ARN type: %s", s3Resource.type()));
                }
                S3ControlBucketResource resource = (S3ControlBucketResource)s3Resource;
                String accountId = getBucketTaggingRequest.accountId();
                String accountIdInArn = resource.accountId().orElseThrow(() -> new IllegalArgumentException("accountId cannot be null"));
                if (accountId != null && !accountId.equals(accountIdInArn)) {
                    throw new IllegalArgumentException(String.format("%s field provided from the request (%s) is different from the one in the ARN (%s)", "accountId", accountId, accountIdInArn));
                }
                getBucketTaggingRequest = (GetBucketTaggingRequest)((Object)getBucketTaggingRequest.toBuilder().bucket(resource.bucketName()).accountId(accountIdInArn).build());
            }
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)getBucketTaggingRequest.accountId(), (String)"AccountId", (String)"getBucketTaggingRequest");
            String resolvedHostExpression = String.format("%s.", getBucketTaggingRequest.accountId());
            GetBucketTaggingResponse getBucketTaggingResponse = (GetBucketTaggingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketTagging").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)getBucketTaggingRequest).putExecutionAttribute(S3ControlInternalExecutionAttribute.S3_ARNABLE_FIELD, (Object)S3ArnableField.builder().arn(arn).build()).withMarshaller((Marshaller)new GetBucketTaggingRequestMarshaller(this.protocolFactory)));
            return getBucketTaggingResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$getBucketTagging$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetJobTaggingResponse getJobTagging(GetJobTaggingRequest getJobTaggingRequest) throws InternalServiceException, TooManyRequestsException, NotFoundException, AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetJobTaggingResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, getJobTaggingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetJobTagging");
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)getJobTaggingRequest.accountId(), (String)"AccountId", (String)"getJobTaggingRequest");
            String resolvedHostExpression = String.format("%s.", getJobTaggingRequest.accountId());
            GetJobTaggingResponse getJobTaggingResponse = (GetJobTaggingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetJobTagging").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)getJobTaggingRequest).withMarshaller((Marshaller)new GetJobTaggingRequestMarshaller(this.protocolFactory)));
            return getJobTaggingResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$getJobTagging$32((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetPublicAccessBlockResponse getPublicAccessBlock(GetPublicAccessBlockRequest getPublicAccessBlockRequest) throws NoSuchPublicAccessBlockConfigurationException, AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetPublicAccessBlockResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, getPublicAccessBlockRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPublicAccessBlock");
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)getPublicAccessBlockRequest.accountId(), (String)"AccountId", (String)"getPublicAccessBlockRequest");
            String resolvedHostExpression = String.format("%s.", getPublicAccessBlockRequest.accountId());
            GetPublicAccessBlockResponse getPublicAccessBlockResponse = (GetPublicAccessBlockResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPublicAccessBlock").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)getPublicAccessBlockRequest).withMarshaller((Marshaller)new GetPublicAccessBlockRequestMarshaller(this.protocolFactory)));
            return getPublicAccessBlockResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$getPublicAccessBlock$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAccessPointsResponse listAccessPoints(ListAccessPointsRequest listAccessPointsRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListAccessPointsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, listAccessPointsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAccessPoints");
            String bucket = listAccessPointsRequest.bucket();
            Arn arn = null;
            if (bucket != null && bucket.startsWith("arn:")) {
                arn = Arn.fromString((String)bucket);
                S3Resource s3Resource = S3ControlArnConverter.getInstance().convertArn(arn);
                if (!(s3Resource instanceof S3ControlBucketResource)) {
                    throw new IllegalArgumentException(String.format("Unsupported ARN type: %s", s3Resource.type()));
                }
                S3ControlBucketResource resource = (S3ControlBucketResource)s3Resource;
                String accountId = listAccessPointsRequest.accountId();
                String accountIdInArn = resource.accountId().orElseThrow(() -> new IllegalArgumentException("accountId cannot be null"));
                if (accountId != null && !accountId.equals(accountIdInArn)) {
                    throw new IllegalArgumentException(String.format("%s field provided from the request (%s) is different from the one in the ARN (%s)", "accountId", accountId, accountIdInArn));
                }
                listAccessPointsRequest = (ListAccessPointsRequest)((Object)listAccessPointsRequest.toBuilder().bucket(resource.bucketName()).accountId(accountIdInArn).build());
            }
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)listAccessPointsRequest.accountId(), (String)"AccountId", (String)"listAccessPointsRequest");
            String resolvedHostExpression = String.format("%s.", listAccessPointsRequest.accountId());
            ListAccessPointsResponse listAccessPointsResponse = (ListAccessPointsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAccessPoints").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)listAccessPointsRequest).putExecutionAttribute(S3ControlInternalExecutionAttribute.S3_ARNABLE_FIELD, (Object)S3ArnableField.builder().arn(arn).build()).withMarshaller((Marshaller)new ListAccessPointsRequestMarshaller(this.protocolFactory)));
            return listAccessPointsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$listAccessPoints$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListAccessPointsIterable listAccessPointsPaginator(ListAccessPointsRequest listAccessPointsRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        return new ListAccessPointsIterable(this, this.applyPaginatorUserAgent(listAccessPointsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListJobsResponse listJobs(ListJobsRequest listJobsRequest) throws InvalidRequestException, InternalServiceException, InvalidNextTokenException, AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListJobsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, listJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListJobs");
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)listJobsRequest.accountId(), (String)"AccountId", (String)"listJobsRequest");
            String resolvedHostExpression = String.format("%s.", listJobsRequest.accountId());
            ListJobsResponse listJobsResponse = (ListJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListJobs").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)listJobsRequest).withMarshaller((Marshaller)new ListJobsRequestMarshaller(this.protocolFactory)));
            return listJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$listJobs$36((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListJobsIterable listJobsPaginator(ListJobsRequest listJobsRequest) throws InvalidRequestException, InternalServiceException, InvalidNextTokenException, AwsServiceException, SdkClientException, S3ControlException {
        return new ListJobsIterable(this, this.applyPaginatorUserAgent(listJobsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListRegionalBucketsResponse listRegionalBuckets(ListRegionalBucketsRequest listRegionalBucketsRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListRegionalBucketsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, listRegionalBucketsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRegionalBuckets");
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)listRegionalBucketsRequest.accountId(), (String)"AccountId", (String)"listRegionalBucketsRequest");
            String resolvedHostExpression = String.format("%s.", listRegionalBucketsRequest.accountId());
            ListRegionalBucketsResponse listRegionalBucketsResponse = (ListRegionalBucketsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRegionalBuckets").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)listRegionalBucketsRequest).withMarshaller((Marshaller)new ListRegionalBucketsRequestMarshaller(this.protocolFactory)));
            return listRegionalBucketsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$listRegionalBuckets$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListRegionalBucketsIterable listRegionalBucketsPaginator(ListRegionalBucketsRequest listRegionalBucketsRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        return new ListRegionalBucketsIterable(this, this.applyPaginatorUserAgent(listRegionalBucketsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutAccessPointPolicyResponse putAccessPointPolicy(PutAccessPointPolicyRequest putAccessPointPolicyRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutAccessPointPolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, putAccessPointPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutAccessPointPolicy");
            String name = putAccessPointPolicyRequest.name();
            Arn arn = null;
            if (name != null && name.startsWith("arn:")) {
                arn = Arn.fromString((String)name);
                S3Resource s3Resource = S3ControlArnConverter.getInstance().convertArn(arn);
                if (!(s3Resource instanceof S3AccessPointResource)) {
                    throw new IllegalArgumentException(String.format("Unsupported ARN type: %s", s3Resource.type()));
                }
                S3AccessPointResource resource = (S3AccessPointResource)s3Resource;
                String accountId = putAccessPointPolicyRequest.accountId();
                String accountIdInArn = (String)resource.accountId().orElseThrow(() -> new IllegalArgumentException("accountId cannot be null"));
                if (accountId != null && !accountId.equals(accountIdInArn)) {
                    throw new IllegalArgumentException(String.format("%s field provided from the request (%s) is different from the one in the ARN (%s)", "accountId", accountId, accountIdInArn));
                }
                putAccessPointPolicyRequest = (PutAccessPointPolicyRequest)((Object)putAccessPointPolicyRequest.toBuilder().name(resource.accessPointName()).accountId(accountIdInArn).build());
            }
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)putAccessPointPolicyRequest.accountId(), (String)"AccountId", (String)"putAccessPointPolicyRequest");
            String resolvedHostExpression = String.format("%s.", putAccessPointPolicyRequest.accountId());
            PutAccessPointPolicyResponse putAccessPointPolicyResponse = (PutAccessPointPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutAccessPointPolicy").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)putAccessPointPolicyRequest).putExecutionAttribute(S3ControlInternalExecutionAttribute.S3_ARNABLE_FIELD, (Object)S3ArnableField.builder().arn(arn).build()).withMarshaller((Marshaller)new PutAccessPointPolicyRequestMarshaller(this.protocolFactory)));
            return putAccessPointPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$putAccessPointPolicy$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutBucketLifecycleConfigurationResponse putBucketLifecycleConfiguration(PutBucketLifecycleConfigurationRequest putBucketLifecycleConfigurationRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutBucketLifecycleConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, putBucketLifecycleConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutBucketLifecycleConfiguration");
            String bucket = putBucketLifecycleConfigurationRequest.bucket();
            Arn arn = null;
            if (bucket != null && bucket.startsWith("arn:")) {
                arn = Arn.fromString((String)bucket);
                S3Resource s3Resource = S3ControlArnConverter.getInstance().convertArn(arn);
                if (!(s3Resource instanceof S3ControlBucketResource)) {
                    throw new IllegalArgumentException(String.format("Unsupported ARN type: %s", s3Resource.type()));
                }
                S3ControlBucketResource resource = (S3ControlBucketResource)s3Resource;
                String accountId = putBucketLifecycleConfigurationRequest.accountId();
                String accountIdInArn = resource.accountId().orElseThrow(() -> new IllegalArgumentException("accountId cannot be null"));
                if (accountId != null && !accountId.equals(accountIdInArn)) {
                    throw new IllegalArgumentException(String.format("%s field provided from the request (%s) is different from the one in the ARN (%s)", "accountId", accountId, accountIdInArn));
                }
                putBucketLifecycleConfigurationRequest = (PutBucketLifecycleConfigurationRequest)((Object)putBucketLifecycleConfigurationRequest.toBuilder().bucket(resource.bucketName()).accountId(accountIdInArn).build());
            }
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)putBucketLifecycleConfigurationRequest.accountId(), (String)"AccountId", (String)"putBucketLifecycleConfigurationRequest");
            String resolvedHostExpression = String.format("%s.", putBucketLifecycleConfigurationRequest.accountId());
            PutBucketLifecycleConfigurationResponse putBucketLifecycleConfigurationResponse = (PutBucketLifecycleConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutBucketLifecycleConfiguration").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)putBucketLifecycleConfigurationRequest).putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED, (Object)HttpChecksumRequired.create()).putExecutionAttribute(S3ControlInternalExecutionAttribute.S3_ARNABLE_FIELD, (Object)S3ArnableField.builder().arn(arn).build()).withMarshaller((Marshaller)new PutBucketLifecycleConfigurationRequestMarshaller(this.protocolFactory)));
            return putBucketLifecycleConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$putBucketLifecycleConfiguration$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutBucketPolicyResponse putBucketPolicy(PutBucketPolicyRequest putBucketPolicyRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutBucketPolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, putBucketPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutBucketPolicy");
            String bucket = putBucketPolicyRequest.bucket();
            Arn arn = null;
            if (bucket != null && bucket.startsWith("arn:")) {
                arn = Arn.fromString((String)bucket);
                S3Resource s3Resource = S3ControlArnConverter.getInstance().convertArn(arn);
                if (!(s3Resource instanceof S3ControlBucketResource)) {
                    throw new IllegalArgumentException(String.format("Unsupported ARN type: %s", s3Resource.type()));
                }
                S3ControlBucketResource resource = (S3ControlBucketResource)s3Resource;
                String accountId = putBucketPolicyRequest.accountId();
                String accountIdInArn = resource.accountId().orElseThrow(() -> new IllegalArgumentException("accountId cannot be null"));
                if (accountId != null && !accountId.equals(accountIdInArn)) {
                    throw new IllegalArgumentException(String.format("%s field provided from the request (%s) is different from the one in the ARN (%s)", "accountId", accountId, accountIdInArn));
                }
                putBucketPolicyRequest = (PutBucketPolicyRequest)((Object)putBucketPolicyRequest.toBuilder().bucket(resource.bucketName()).accountId(accountIdInArn).build());
            }
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)putBucketPolicyRequest.accountId(), (String)"AccountId", (String)"putBucketPolicyRequest");
            String resolvedHostExpression = String.format("%s.", putBucketPolicyRequest.accountId());
            PutBucketPolicyResponse putBucketPolicyResponse = (PutBucketPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutBucketPolicy").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)putBucketPolicyRequest).putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED, (Object)HttpChecksumRequired.create()).putExecutionAttribute(S3ControlInternalExecutionAttribute.S3_ARNABLE_FIELD, (Object)S3ArnableField.builder().arn(arn).build()).withMarshaller((Marshaller)new PutBucketPolicyRequestMarshaller(this.protocolFactory)));
            return putBucketPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$putBucketPolicy$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutBucketTaggingResponse putBucketTagging(PutBucketTaggingRequest putBucketTaggingRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutBucketTaggingResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, putBucketTaggingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutBucketTagging");
            String bucket = putBucketTaggingRequest.bucket();
            Arn arn = null;
            if (bucket != null && bucket.startsWith("arn:")) {
                arn = Arn.fromString((String)bucket);
                S3Resource s3Resource = S3ControlArnConverter.getInstance().convertArn(arn);
                if (!(s3Resource instanceof S3ControlBucketResource)) {
                    throw new IllegalArgumentException(String.format("Unsupported ARN type: %s", s3Resource.type()));
                }
                S3ControlBucketResource resource = (S3ControlBucketResource)s3Resource;
                String accountId = putBucketTaggingRequest.accountId();
                String accountIdInArn = resource.accountId().orElseThrow(() -> new IllegalArgumentException("accountId cannot be null"));
                if (accountId != null && !accountId.equals(accountIdInArn)) {
                    throw new IllegalArgumentException(String.format("%s field provided from the request (%s) is different from the one in the ARN (%s)", "accountId", accountId, accountIdInArn));
                }
                putBucketTaggingRequest = (PutBucketTaggingRequest)((Object)putBucketTaggingRequest.toBuilder().bucket(resource.bucketName()).accountId(accountIdInArn).build());
            }
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)putBucketTaggingRequest.accountId(), (String)"AccountId", (String)"putBucketTaggingRequest");
            String resolvedHostExpression = String.format("%s.", putBucketTaggingRequest.accountId());
            PutBucketTaggingResponse putBucketTaggingResponse = (PutBucketTaggingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutBucketTagging").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)putBucketTaggingRequest).putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED, (Object)HttpChecksumRequired.create()).putExecutionAttribute(S3ControlInternalExecutionAttribute.S3_ARNABLE_FIELD, (Object)S3ArnableField.builder().arn(arn).build()).withMarshaller((Marshaller)new PutBucketTaggingRequestMarshaller(this.protocolFactory)));
            return putBucketTaggingResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$putBucketTagging$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutJobTaggingResponse putJobTagging(PutJobTaggingRequest putJobTaggingRequest) throws InternalServiceException, TooManyRequestsException, NotFoundException, TooManyTagsException, AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutJobTaggingResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, putJobTaggingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutJobTagging");
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)putJobTaggingRequest.accountId(), (String)"AccountId", (String)"putJobTaggingRequest");
            String resolvedHostExpression = String.format("%s.", putJobTaggingRequest.accountId());
            PutJobTaggingResponse putJobTaggingResponse = (PutJobTaggingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutJobTagging").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)putJobTaggingRequest).withMarshaller((Marshaller)new PutJobTaggingRequestMarshaller(this.protocolFactory)));
            return putJobTaggingResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$putJobTagging$46((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutPublicAccessBlockResponse putPublicAccessBlock(PutPublicAccessBlockRequest putPublicAccessBlockRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutPublicAccessBlockResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, putPublicAccessBlockRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutPublicAccessBlock");
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)putPublicAccessBlockRequest.accountId(), (String)"AccountId", (String)"putPublicAccessBlockRequest");
            String resolvedHostExpression = String.format("%s.", putPublicAccessBlockRequest.accountId());
            PutPublicAccessBlockResponse putPublicAccessBlockResponse = (PutPublicAccessBlockResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutPublicAccessBlock").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)putPublicAccessBlockRequest).withMarshaller((Marshaller)new PutPublicAccessBlockRequestMarshaller(this.protocolFactory)));
            return putPublicAccessBlockResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$putPublicAccessBlock$47((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateJobPriorityResponse updateJobPriority(UpdateJobPriorityRequest updateJobPriorityRequest) throws BadRequestException, TooManyRequestsException, NotFoundException, InternalServiceException, AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(UpdateJobPriorityResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, updateJobPriorityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateJobPriority");
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)updateJobPriorityRequest.accountId(), (String)"AccountId", (String)"updateJobPriorityRequest");
            String resolvedHostExpression = String.format("%s.", updateJobPriorityRequest.accountId());
            UpdateJobPriorityResponse updateJobPriorityResponse = (UpdateJobPriorityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateJobPriority").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)updateJobPriorityRequest).withMarshaller((Marshaller)new UpdateJobPriorityRequestMarshaller(this.protocolFactory)));
            return updateJobPriorityResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$updateJobPriority$48((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateJobStatusResponse updateJobStatus(UpdateJobStatusRequest updateJobStatusRequest) throws BadRequestException, TooManyRequestsException, NotFoundException, JobStatusException, InternalServiceException, AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(UpdateJobStatusResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, updateJobStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateJobStatus");
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)updateJobStatusRequest.accountId(), (String)"AccountId", (String)"updateJobStatusRequest");
            String resolvedHostExpression = String.format("%s.", updateJobStatusRequest.accountId());
            UpdateJobStatusResponse updateJobStatusResponse = (UpdateJobStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateJobStatus").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)updateJobStatusRequest).withMarshaller((Marshaller)new UpdateJobStatusRequestMarshaller(this.protocolFactory)));
            return updateJobStatusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$updateJobStatus$49((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private AwsXmlProtocolFactory init() {
        return AwsXmlProtocolFactory.builder().registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BucketAlreadyExists").exceptionBuilderSupplier(BucketAlreadyExistsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NotFoundException").exceptionBuilderSupplier(NotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").exceptionBuilderSupplier(InvalidNextTokenException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyTagsException").exceptionBuilderSupplier(TooManyTagsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("JobStatusException").exceptionBuilderSupplier(JobStatusException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("IdempotencyException").exceptionBuilderSupplier(IdempotencyException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchPublicAccessBlockConfiguration").exceptionBuilderSupplier(NoSuchPublicAccessBlockConfigurationException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServiceException").exceptionBuilderSupplier(InternalServiceException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BucketAlreadyOwnedByYou").exceptionBuilderSupplier(BucketAlreadyOwnedByYouException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyRequestsException").exceptionBuilderSupplier(TooManyRequestsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BadRequestException").exceptionBuilderSupplier(BadRequestException::builder).build()).clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(S3ControlException::builder).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends S3ControlRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.15.27").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((S3ControlRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private static /* synthetic */ void lambda$updateJobStatus$49(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateJobPriority$48(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putPublicAccessBlock$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putJobTagging$46(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putBucketTagging$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putBucketPolicy$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putBucketLifecycleConfiguration$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putAccessPointPolicy$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listRegionalBuckets$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listJobs$36(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAccessPoints$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getPublicAccessBlock$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getJobTagging$32(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getBucketTagging$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getBucketPolicy$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getBucketLifecycleConfiguration$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getBucket$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAccessPointPolicyStatus$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAccessPointPolicy$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAccessPoint$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeJob$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deletePublicAccessBlock$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteJobTagging$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteBucketTagging$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteBucketPolicy$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteBucketLifecycleConfiguration$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteBucket$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAccessPointPolicy$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAccessPoint$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createJob$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createBucket$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createAccessPoint$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

