/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3control.model.S3ControlResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAccessPointResponse
extends S3ControlResponse
implements ToCopyableBuilder<Builder, CreateAccessPointResponse> {
    private static final SdkField<String> ACCESS_POINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessPointArn").getter(CreateAccessPointResponse.getter(CreateAccessPointResponse::accessPointArn)).setter(CreateAccessPointResponse.setter(Builder::accessPointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessPointArn").unmarshallLocationName("AccessPointArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_POINT_ARN_FIELD));
    private final String accessPointArn;

    private CreateAccessPointResponse(BuilderImpl builder) {
        super(builder);
        this.accessPointArn = builder.accessPointArn;
    }

    public String accessPointArn() {
        return this.accessPointArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accessPointArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAccessPointResponse)) {
            return false;
        }
        CreateAccessPointResponse other = (CreateAccessPointResponse)((Object)obj);
        return Objects.equals(this.accessPointArn(), other.accessPointArn());
    }

    public String toString() {
        return ToString.builder((String)"CreateAccessPointResponse").add("AccessPointArn", (Object)this.accessPointArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccessPointArn": {
                return Optional.ofNullable(clazz.cast(this.accessPointArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAccessPointResponse, T> g) {
        return obj -> g.apply((CreateAccessPointResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3ControlResponse.BuilderImpl
    implements Builder {
        private String accessPointArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAccessPointResponse model) {
            super(model);
            this.accessPointArn(model.accessPointArn);
        }

        public final String getAccessPointArn() {
            return this.accessPointArn;
        }

        @Override
        public final Builder accessPointArn(String accessPointArn) {
            this.accessPointArn = accessPointArn;
            return this;
        }

        public final void setAccessPointArn(String accessPointArn) {
            this.accessPointArn = accessPointArn;
        }

        @Override
        public CreateAccessPointResponse build() {
            return new CreateAccessPointResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends S3ControlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAccessPointResponse> {
        public Builder accessPointArn(String var1);
    }
}

