/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateJobStatusResponse extends S3ControlResponse implements
        ToCopyableBuilder<UpdateJobStatusResponse.Builder, UpdateJobStatusResponse> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateJobStatusResponse::jobId))
            .setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId")
                    .unmarshallLocationName("JobId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateJobStatusResponse::statusAsString))
            .setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status")
                    .unmarshallLocationName("Status").build()).build();

    private static final SdkField<String> STATUS_UPDATE_REASON_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateJobStatusResponse::statusUpdateReason))
            .setter(setter(Builder::statusUpdateReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusUpdateReason")
                    .unmarshallLocationName("StatusUpdateReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, STATUS_FIELD,
            STATUS_UPDATE_REASON_FIELD));

    private final String jobId;

    private final String status;

    private final String statusUpdateReason;

    private UpdateJobStatusResponse(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.status = builder.status;
        this.statusUpdateReason = builder.statusUpdateReason;
    }

    /**
     * <p>
     * The ID for the job whose status was updated.
     * </p>
     * 
     * @return The ID for the job whose status was updated.
     */
    public String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The current status for the specified job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status for the specified job.
     * @see JobStatus
     */
    public JobStatus status() {
        return JobStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status for the specified job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status for the specified job.
     * @see JobStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The reason that the specified job's status was updated.
     * </p>
     * 
     * @return The reason that the specified job's status was updated.
     */
    public String statusUpdateReason() {
        return statusUpdateReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusUpdateReason());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateJobStatusResponse)) {
            return false;
        }
        UpdateJobStatusResponse other = (UpdateJobStatusResponse) obj;
        return Objects.equals(jobId(), other.jobId()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusUpdateReason(), other.statusUpdateReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateJobStatusResponse").add("JobId", jobId()).add("Status", statusAsString())
                .add("StatusUpdateReason", statusUpdateReason()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusUpdateReason":
            return Optional.ofNullable(clazz.cast(statusUpdateReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateJobStatusResponse, T> g) {
        return obj -> g.apply((UpdateJobStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends S3ControlResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateJobStatusResponse> {
        /**
         * <p>
         * The ID for the job whose status was updated.
         * </p>
         * 
         * @param jobId
         *        The ID for the job whose status was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The current status for the specified job.
         * </p>
         * 
         * @param status
         *        The current status for the specified job.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status for the specified job.
         * </p>
         * 
         * @param status
         *        The current status for the specified job.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder status(JobStatus status);

        /**
         * <p>
         * The reason that the specified job's status was updated.
         * </p>
         * 
         * @param statusUpdateReason
         *        The reason that the specified job's status was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusUpdateReason(String statusUpdateReason);
    }

    static final class BuilderImpl extends S3ControlResponse.BuilderImpl implements Builder {
        private String jobId;

        private String status;

        private String statusUpdateReason;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateJobStatusResponse model) {
            super(model);
            jobId(model.jobId);
            status(model.status);
            statusUpdateReason(model.statusUpdateReason);
        }

        public final String getJobId() {
            return jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final String getStatusAsString() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(JobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusUpdateReason() {
            return statusUpdateReason;
        }

        @Override
        public final Builder statusUpdateReason(String statusUpdateReason) {
            this.statusUpdateReason = statusUpdateReason;
            return this;
        }

        public final void setStatusUpdateReason(String statusUpdateReason) {
            this.statusUpdateReason = statusUpdateReason;
        }

        @Override
        public UpdateJobStatusResponse build() {
            return new UpdateJobStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
