/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the configuration parameters for an Initiate Glacier Restore job. Amazon S3 batch operations passes each
 * value through to the underlying POST Object restore API. For more information about the parameters for this
 * operation, see <a href=
 * "https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectPOSTrestore.html#RESTObjectPOSTrestore-restore-request"
 * >Restoring Archives</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3InitiateRestoreObjectOperation implements SdkPojo, Serializable,
        ToCopyableBuilder<S3InitiateRestoreObjectOperation.Builder, S3InitiateRestoreObjectOperation> {
    private static final SdkField<Integer> EXPIRATION_IN_DAYS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(S3InitiateRestoreObjectOperation::expirationInDays))
            .setter(setter(Builder::expirationInDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationInDays")
                    .unmarshallLocationName("ExpirationInDays").build()).build();

    private static final SdkField<String> GLACIER_JOB_TIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(S3InitiateRestoreObjectOperation::glacierJobTierAsString))
            .setter(setter(Builder::glacierJobTier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlacierJobTier")
                    .unmarshallLocationName("GlacierJobTier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPIRATION_IN_DAYS_FIELD,
            GLACIER_JOB_TIER_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer expirationInDays;

    private final String glacierJobTier;

    private S3InitiateRestoreObjectOperation(BuilderImpl builder) {
        this.expirationInDays = builder.expirationInDays;
        this.glacierJobTier = builder.glacierJobTier;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public Integer expirationInDays() {
        return expirationInDays;
    }

    /**
     * <p/>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #glacierJobTier}
     * will return {@link S3GlacierJobTier#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #glacierJobTierAsString}.
     * </p>
     * 
     * @return
     * @see S3GlacierJobTier
     */
    public S3GlacierJobTier glacierJobTier() {
        return S3GlacierJobTier.fromValue(glacierJobTier);
    }

    /**
     * <p/>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #glacierJobTier}
     * will return {@link S3GlacierJobTier#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #glacierJobTierAsString}.
     * </p>
     * 
     * @return
     * @see S3GlacierJobTier
     */
    public String glacierJobTierAsString() {
        return glacierJobTier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(expirationInDays());
        hashCode = 31 * hashCode + Objects.hashCode(glacierJobTierAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3InitiateRestoreObjectOperation)) {
            return false;
        }
        S3InitiateRestoreObjectOperation other = (S3InitiateRestoreObjectOperation) obj;
        return Objects.equals(expirationInDays(), other.expirationInDays())
                && Objects.equals(glacierJobTierAsString(), other.glacierJobTierAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("S3InitiateRestoreObjectOperation").add("ExpirationInDays", expirationInDays())
                .add("GlacierJobTier", glacierJobTierAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExpirationInDays":
            return Optional.ofNullable(clazz.cast(expirationInDays()));
        case "GlacierJobTier":
            return Optional.ofNullable(clazz.cast(glacierJobTierAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3InitiateRestoreObjectOperation, T> g) {
        return obj -> g.apply((S3InitiateRestoreObjectOperation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3InitiateRestoreObjectOperation> {
        /**
         * <p/>
         * 
         * @param expirationInDays
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expirationInDays(Integer expirationInDays);

        /**
         * <p/>
         * 
         * @param glacierJobTier
         * @see S3GlacierJobTier
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see S3GlacierJobTier
         */
        Builder glacierJobTier(String glacierJobTier);

        /**
         * <p/>
         * 
         * @param glacierJobTier
         * @see S3GlacierJobTier
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see S3GlacierJobTier
         */
        Builder glacierJobTier(S3GlacierJobTier glacierJobTier);
    }

    static final class BuilderImpl implements Builder {
        private Integer expirationInDays;

        private String glacierJobTier;

        private BuilderImpl() {
        }

        private BuilderImpl(S3InitiateRestoreObjectOperation model) {
            expirationInDays(model.expirationInDays);
            glacierJobTier(model.glacierJobTier);
        }

        public final Integer getExpirationInDays() {
            return expirationInDays;
        }

        @Override
        public final Builder expirationInDays(Integer expirationInDays) {
            this.expirationInDays = expirationInDays;
            return this;
        }

        public final void setExpirationInDays(Integer expirationInDays) {
            this.expirationInDays = expirationInDays;
        }

        public final String getGlacierJobTierAsString() {
            return glacierJobTier;
        }

        @Override
        public final Builder glacierJobTier(String glacierJobTier) {
            this.glacierJobTier = glacierJobTier;
            return this;
        }

        @Override
        public final Builder glacierJobTier(S3GlacierJobTier glacierJobTier) {
            this.glacierJobTier(glacierJobTier == null ? null : glacierJobTier.toString());
            return this;
        }

        public final void setGlacierJobTier(String glacierJobTier) {
            this.glacierJobTier = glacierJobTier;
        }

        @Override
        public S3InitiateRestoreObjectOperation build() {
            return new S3InitiateRestoreObjectOperation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
