/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutPublicAccessBlockRequest extends S3ControlRequest implements
        ToCopyableBuilder<PutPublicAccessBlockRequest.Builder, PutPublicAccessBlockRequest> {
    private static final SdkField<PublicAccessBlockConfiguration> PUBLIC_ACCESS_BLOCK_CONFIGURATION_FIELD = SdkField
            .<PublicAccessBlockConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(PutPublicAccessBlockRequest::publicAccessBlockConfiguration))
            .setter(setter(Builder::publicAccessBlockConfiguration))
            .constructor(PublicAccessBlockConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicAccessBlockConfiguration")
                    .unmarshallLocationName("PublicAccessBlockConfiguration").build(), PayloadTrait.create()).build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(PutPublicAccessBlockRequest::accountId))
            .setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-account-id")
                    .unmarshallLocationName("x-amz-account-id").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PUBLIC_ACCESS_BLOCK_CONFIGURATION_FIELD, ACCOUNT_ID_FIELD));

    private final PublicAccessBlockConfiguration publicAccessBlockConfiguration;

    private final String accountId;

    private PutPublicAccessBlockRequest(BuilderImpl builder) {
        super(builder);
        this.publicAccessBlockConfiguration = builder.publicAccessBlockConfiguration;
        this.accountId = builder.accountId;
    }

    /**
     * <p>
     * The <code>PublicAccessBlock</code> configuration that you want to apply to the specified Amazon Web Services
     * account.
     * </p>
     * 
     * @return The <code>PublicAccessBlock</code> configuration that you want to apply to the specified Amazon Web
     *         Services account.
     */
    public PublicAccessBlockConfiguration publicAccessBlockConfiguration() {
        return publicAccessBlockConfiguration;
    }

    /**
     * <p>
     * The account ID for the Amazon Web Services account whose <code>PublicAccessBlock</code> configuration you want to
     * set.
     * </p>
     * 
     * @return The account ID for the Amazon Web Services account whose <code>PublicAccessBlock</code> configuration you
     *         want to set.
     */
    public String accountId() {
        return accountId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(publicAccessBlockConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutPublicAccessBlockRequest)) {
            return false;
        }
        PutPublicAccessBlockRequest other = (PutPublicAccessBlockRequest) obj;
        return Objects.equals(publicAccessBlockConfiguration(), other.publicAccessBlockConfiguration())
                && Objects.equals(accountId(), other.accountId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutPublicAccessBlockRequest")
                .add("PublicAccessBlockConfiguration", publicAccessBlockConfiguration()).add("AccountId", accountId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PublicAccessBlockConfiguration":
            return Optional.ofNullable(clazz.cast(publicAccessBlockConfiguration()));
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutPublicAccessBlockRequest, T> g) {
        return obj -> g.apply((PutPublicAccessBlockRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends S3ControlRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutPublicAccessBlockRequest> {
        /**
         * <p>
         * The <code>PublicAccessBlock</code> configuration that you want to apply to the specified Amazon Web Services
         * account.
         * </p>
         * 
         * @param publicAccessBlockConfiguration
         *        The <code>PublicAccessBlock</code> configuration that you want to apply to the specified Amazon Web
         *        Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicAccessBlockConfiguration(PublicAccessBlockConfiguration publicAccessBlockConfiguration);

        /**
         * <p>
         * The <code>PublicAccessBlock</code> configuration that you want to apply to the specified Amazon Web Services
         * account.
         * </p>
         * This is a convenience that creates an instance of the {@link PublicAccessBlockConfiguration.Builder} avoiding
         * the need to create one manually via {@link PublicAccessBlockConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link PublicAccessBlockConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #publicAccessBlockConfiguration(PublicAccessBlockConfiguration)}.
         * 
         * @param publicAccessBlockConfiguration
         *        a consumer that will call methods on {@link PublicAccessBlockConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #publicAccessBlockConfiguration(PublicAccessBlockConfiguration)
         */
        default Builder publicAccessBlockConfiguration(
                Consumer<PublicAccessBlockConfiguration.Builder> publicAccessBlockConfiguration) {
            return publicAccessBlockConfiguration(PublicAccessBlockConfiguration.builder()
                    .applyMutation(publicAccessBlockConfiguration).build());
        }

        /**
         * <p>
         * The account ID for the Amazon Web Services account whose <code>PublicAccessBlock</code> configuration you
         * want to set.
         * </p>
         * 
         * @param accountId
         *        The account ID for the Amazon Web Services account whose <code>PublicAccessBlock</code> configuration
         *        you want to set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends S3ControlRequest.BuilderImpl implements Builder {
        private PublicAccessBlockConfiguration publicAccessBlockConfiguration;

        private String accountId;

        private BuilderImpl() {
        }

        private BuilderImpl(PutPublicAccessBlockRequest model) {
            super(model);
            publicAccessBlockConfiguration(model.publicAccessBlockConfiguration);
            accountId(model.accountId);
        }

        public final PublicAccessBlockConfiguration.Builder getPublicAccessBlockConfiguration() {
            return publicAccessBlockConfiguration != null ? publicAccessBlockConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder publicAccessBlockConfiguration(PublicAccessBlockConfiguration publicAccessBlockConfiguration) {
            this.publicAccessBlockConfiguration = publicAccessBlockConfiguration;
            return this;
        }

        public final void setPublicAccessBlockConfiguration(
                PublicAccessBlockConfiguration.BuilderImpl publicAccessBlockConfiguration) {
            this.publicAccessBlockConfiguration = publicAccessBlockConfiguration != null ? publicAccessBlockConfiguration.build()
                    : null;
        }

        public final String getAccountId() {
            return accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutPublicAccessBlockRequest build() {
            return new PutPublicAccessBlockRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
