/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAccessPointResponse extends S3ControlResponse implements
        ToCopyableBuilder<GetAccessPointResponse.Builder, GetAccessPointResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(GetAccessPointResponse::name))
            .setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name")
                    .unmarshallLocationName("Name").build()).build();

    private static final SdkField<String> BUCKET_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(GetAccessPointResponse::bucket))
            .setter(setter(Builder::bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bucket")
                    .unmarshallLocationName("Bucket").build()).build();

    private static final SdkField<String> NETWORK_ORIGIN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(GetAccessPointResponse::networkOriginAsString))
            .setter(setter(Builder::networkOrigin))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkOrigin")
                    .unmarshallLocationName("NetworkOrigin").build()).build();

    private static final SdkField<VpcConfiguration> VPC_CONFIGURATION_FIELD = SdkField
            .<VpcConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetAccessPointResponse::vpcConfiguration))
            .setter(setter(Builder::vpcConfiguration))
            .constructor(VpcConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfiguration")
                    .unmarshallLocationName("VpcConfiguration").build()).build();

    private static final SdkField<PublicAccessBlockConfiguration> PUBLIC_ACCESS_BLOCK_CONFIGURATION_FIELD = SdkField
            .<PublicAccessBlockConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetAccessPointResponse::publicAccessBlockConfiguration))
            .setter(setter(Builder::publicAccessBlockConfiguration))
            .constructor(PublicAccessBlockConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicAccessBlockConfiguration")
                    .unmarshallLocationName("PublicAccessBlockConfiguration").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(GetAccessPointResponse::creationDate))
            .setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate")
                    .unmarshallLocationName("CreationDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, BUCKET_FIELD,
            NETWORK_ORIGIN_FIELD, VPC_CONFIGURATION_FIELD, PUBLIC_ACCESS_BLOCK_CONFIGURATION_FIELD, CREATION_DATE_FIELD));

    private final String name;

    private final String bucket;

    private final String networkOrigin;

    private final VpcConfiguration vpcConfiguration;

    private final PublicAccessBlockConfiguration publicAccessBlockConfiguration;

    private final Instant creationDate;

    private GetAccessPointResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.bucket = builder.bucket;
        this.networkOrigin = builder.networkOrigin;
        this.vpcConfiguration = builder.vpcConfiguration;
        this.publicAccessBlockConfiguration = builder.publicAccessBlockConfiguration;
        this.creationDate = builder.creationDate;
    }

    /**
     * <p>
     * The name of the specified access point.
     * </p>
     * 
     * @return The name of the specified access point.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The name of the bucket associated with the specified access point.
     * </p>
     * 
     * @return The name of the bucket associated with the specified access point.
     */
    public String bucket() {
        return bucket;
    }

    /**
     * <p>
     * Indicates whether this access point allows access from the public Internet. If <code>VpcConfiguration</code> is
     * specified for this access point, then <code>NetworkOrigin</code> is <code>VPC</code>, and the access point
     * doesn't allow access from the public Internet. Otherwise, <code>NetworkOrigin</code> is <code>Internet</code>,
     * and the access point allows access from the public Internet, subject to the access point and bucket access
     * policies.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #networkOrigin}
     * will return {@link NetworkOrigin#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #networkOriginAsString}.
     * </p>
     * 
     * @return Indicates whether this access point allows access from the public Internet. If
     *         <code>VpcConfiguration</code> is specified for this access point, then <code>NetworkOrigin</code> is
     *         <code>VPC</code>, and the access point doesn't allow access from the public Internet. Otherwise,
     *         <code>NetworkOrigin</code> is <code>Internet</code>, and the access point allows access from the public
     *         Internet, subject to the access point and bucket access policies.
     * @see NetworkOrigin
     */
    public NetworkOrigin networkOrigin() {
        return NetworkOrigin.fromValue(networkOrigin);
    }

    /**
     * <p>
     * Indicates whether this access point allows access from the public Internet. If <code>VpcConfiguration</code> is
     * specified for this access point, then <code>NetworkOrigin</code> is <code>VPC</code>, and the access point
     * doesn't allow access from the public Internet. Otherwise, <code>NetworkOrigin</code> is <code>Internet</code>,
     * and the access point allows access from the public Internet, subject to the access point and bucket access
     * policies.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #networkOrigin}
     * will return {@link NetworkOrigin#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #networkOriginAsString}.
     * </p>
     * 
     * @return Indicates whether this access point allows access from the public Internet. If
     *         <code>VpcConfiguration</code> is specified for this access point, then <code>NetworkOrigin</code> is
     *         <code>VPC</code>, and the access point doesn't allow access from the public Internet. Otherwise,
     *         <code>NetworkOrigin</code> is <code>Internet</code>, and the access point allows access from the public
     *         Internet, subject to the access point and bucket access policies.
     * @see NetworkOrigin
     */
    public String networkOriginAsString() {
        return networkOrigin;
    }

    /**
     * <p>
     * Contains the Virtual Private Cloud (VPC) configuration for the specified access point.
     * </p>
     * 
     * @return Contains the Virtual Private Cloud (VPC) configuration for the specified access point.
     */
    public VpcConfiguration vpcConfiguration() {
        return vpcConfiguration;
    }

    /**
     * Returns the value of the PublicAccessBlockConfiguration property for this object.
     * 
     * @return The value of the PublicAccessBlockConfiguration property for this object.
     */
    public PublicAccessBlockConfiguration publicAccessBlockConfiguration() {
        return publicAccessBlockConfiguration;
    }

    /**
     * <p>
     * The date and time when the specified access point was created.
     * </p>
     * 
     * @return The date and time when the specified access point was created.
     */
    public Instant creationDate() {
        return creationDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(bucket());
        hashCode = 31 * hashCode + Objects.hashCode(networkOriginAsString());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(publicAccessBlockConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAccessPointResponse)) {
            return false;
        }
        GetAccessPointResponse other = (GetAccessPointResponse) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(bucket(), other.bucket())
                && Objects.equals(networkOriginAsString(), other.networkOriginAsString())
                && Objects.equals(vpcConfiguration(), other.vpcConfiguration())
                && Objects.equals(publicAccessBlockConfiguration(), other.publicAccessBlockConfiguration())
                && Objects.equals(creationDate(), other.creationDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetAccessPointResponse").add("Name", name()).add("Bucket", bucket())
                .add("NetworkOrigin", networkOriginAsString()).add("VpcConfiguration", vpcConfiguration())
                .add("PublicAccessBlockConfiguration", publicAccessBlockConfiguration()).add("CreationDate", creationDate())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Bucket":
            return Optional.ofNullable(clazz.cast(bucket()));
        case "NetworkOrigin":
            return Optional.ofNullable(clazz.cast(networkOriginAsString()));
        case "VpcConfiguration":
            return Optional.ofNullable(clazz.cast(vpcConfiguration()));
        case "PublicAccessBlockConfiguration":
            return Optional.ofNullable(clazz.cast(publicAccessBlockConfiguration()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAccessPointResponse, T> g) {
        return obj -> g.apply((GetAccessPointResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends S3ControlResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetAccessPointResponse> {
        /**
         * <p>
         * The name of the specified access point.
         * </p>
         * 
         * @param name
         *        The name of the specified access point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The name of the bucket associated with the specified access point.
         * </p>
         * 
         * @param bucket
         *        The name of the bucket associated with the specified access point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * <p>
         * Indicates whether this access point allows access from the public Internet. If <code>VpcConfiguration</code>
         * is specified for this access point, then <code>NetworkOrigin</code> is <code>VPC</code>, and the access point
         * doesn't allow access from the public Internet. Otherwise, <code>NetworkOrigin</code> is <code>Internet</code>
         * , and the access point allows access from the public Internet, subject to the access point and bucket access
         * policies.
         * </p>
         * 
         * @param networkOrigin
         *        Indicates whether this access point allows access from the public Internet. If
         *        <code>VpcConfiguration</code> is specified for this access point, then <code>NetworkOrigin</code> is
         *        <code>VPC</code>, and the access point doesn't allow access from the public Internet. Otherwise,
         *        <code>NetworkOrigin</code> is <code>Internet</code>, and the access point allows access from the
         *        public Internet, subject to the access point and bucket access policies.
         * @see NetworkOrigin
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkOrigin
         */
        Builder networkOrigin(String networkOrigin);

        /**
         * <p>
         * Indicates whether this access point allows access from the public Internet. If <code>VpcConfiguration</code>
         * is specified for this access point, then <code>NetworkOrigin</code> is <code>VPC</code>, and the access point
         * doesn't allow access from the public Internet. Otherwise, <code>NetworkOrigin</code> is <code>Internet</code>
         * , and the access point allows access from the public Internet, subject to the access point and bucket access
         * policies.
         * </p>
         * 
         * @param networkOrigin
         *        Indicates whether this access point allows access from the public Internet. If
         *        <code>VpcConfiguration</code> is specified for this access point, then <code>NetworkOrigin</code> is
         *        <code>VPC</code>, and the access point doesn't allow access from the public Internet. Otherwise,
         *        <code>NetworkOrigin</code> is <code>Internet</code>, and the access point allows access from the
         *        public Internet, subject to the access point and bucket access policies.
         * @see NetworkOrigin
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkOrigin
         */
        Builder networkOrigin(NetworkOrigin networkOrigin);

        /**
         * <p>
         * Contains the Virtual Private Cloud (VPC) configuration for the specified access point.
         * </p>
         * 
         * @param vpcConfiguration
         *        Contains the Virtual Private Cloud (VPC) configuration for the specified access point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfiguration(VpcConfiguration vpcConfiguration);

        /**
         * <p>
         * Contains the Virtual Private Cloud (VPC) configuration for the specified access point.
         * </p>
         * This is a convenience that creates an instance of the {@link VpcConfiguration.Builder} avoiding the need to
         * create one manually via {@link VpcConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link VpcConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #vpcConfiguration(VpcConfiguration)}.
         * 
         * @param vpcConfiguration
         *        a consumer that will call methods on {@link VpcConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfiguration(VpcConfiguration)
         */
        default Builder vpcConfiguration(Consumer<VpcConfiguration.Builder> vpcConfiguration) {
            return vpcConfiguration(VpcConfiguration.builder().applyMutation(vpcConfiguration).build());
        }

        /**
         * Sets the value of the PublicAccessBlockConfiguration property for this object.
         *
         * @param publicAccessBlockConfiguration
         *        The new value for the PublicAccessBlockConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicAccessBlockConfiguration(PublicAccessBlockConfiguration publicAccessBlockConfiguration);

        /**
         * Sets the value of the PublicAccessBlockConfiguration property for this object.
         *
         * This is a convenience that creates an instance of the {@link PublicAccessBlockConfiguration.Builder} avoiding
         * the need to create one manually via {@link PublicAccessBlockConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link PublicAccessBlockConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #publicAccessBlockConfiguration(PublicAccessBlockConfiguration)}.
         * 
         * @param publicAccessBlockConfiguration
         *        a consumer that will call methods on {@link PublicAccessBlockConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #publicAccessBlockConfiguration(PublicAccessBlockConfiguration)
         */
        default Builder publicAccessBlockConfiguration(
                Consumer<PublicAccessBlockConfiguration.Builder> publicAccessBlockConfiguration) {
            return publicAccessBlockConfiguration(PublicAccessBlockConfiguration.builder()
                    .applyMutation(publicAccessBlockConfiguration).build());
        }

        /**
         * <p>
         * The date and time when the specified access point was created.
         * </p>
         * 
         * @param creationDate
         *        The date and time when the specified access point was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);
    }

    static final class BuilderImpl extends S3ControlResponse.BuilderImpl implements Builder {
        private String name;

        private String bucket;

        private String networkOrigin;

        private VpcConfiguration vpcConfiguration;

        private PublicAccessBlockConfiguration publicAccessBlockConfiguration;

        private Instant creationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAccessPointResponse model) {
            super(model);
            name(model.name);
            bucket(model.bucket);
            networkOrigin(model.networkOrigin);
            vpcConfiguration(model.vpcConfiguration);
            publicAccessBlockConfiguration(model.publicAccessBlockConfiguration);
            creationDate(model.creationDate);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getBucket() {
            return bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getNetworkOriginAsString() {
            return networkOrigin;
        }

        @Override
        public final Builder networkOrigin(String networkOrigin) {
            this.networkOrigin = networkOrigin;
            return this;
        }

        @Override
        public final Builder networkOrigin(NetworkOrigin networkOrigin) {
            this.networkOrigin(networkOrigin == null ? null : networkOrigin.toString());
            return this;
        }

        public final void setNetworkOrigin(String networkOrigin) {
            this.networkOrigin = networkOrigin;
        }

        public final VpcConfiguration.Builder getVpcConfiguration() {
            return vpcConfiguration != null ? vpcConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder vpcConfiguration(VpcConfiguration vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration;
            return this;
        }

        public final void setVpcConfiguration(VpcConfiguration.BuilderImpl vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration != null ? vpcConfiguration.build() : null;
        }

        public final PublicAccessBlockConfiguration.Builder getPublicAccessBlockConfiguration() {
            return publicAccessBlockConfiguration != null ? publicAccessBlockConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder publicAccessBlockConfiguration(PublicAccessBlockConfiguration publicAccessBlockConfiguration) {
            this.publicAccessBlockConfiguration = publicAccessBlockConfiguration;
            return this;
        }

        public final void setPublicAccessBlockConfiguration(
                PublicAccessBlockConfiguration.BuilderImpl publicAccessBlockConfiguration) {
            this.publicAccessBlockConfiguration = publicAccessBlockConfiguration != null ? publicAccessBlockConfiguration.build()
                    : null;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public GetAccessPointResponse build() {
            return new GetAccessPointResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
