/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateJobResponse extends S3ControlResponse implements
        ToCopyableBuilder<CreateJobResponse.Builder, CreateJobResponse> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateJobResponse::jobId))
            .setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId")
                    .unmarshallLocationName("JobId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD));

    private final String jobId;

    private CreateJobResponse(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
    }

    /**
     * <p>
     * The ID for this job. Amazon S3 generates this ID automatically and returns it after a successful
     * <code>Create Job</code> request.
     * </p>
     * 
     * @return The ID for this job. Amazon S3 generates this ID automatically and returns it after a successful
     *         <code>Create Job</code> request.
     */
    public String jobId() {
        return jobId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateJobResponse)) {
            return false;
        }
        CreateJobResponse other = (CreateJobResponse) obj;
        return Objects.equals(jobId(), other.jobId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateJobResponse").add("JobId", jobId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateJobResponse, T> g) {
        return obj -> g.apply((CreateJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends S3ControlResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateJobResponse> {
        /**
         * <p>
         * The ID for this job. Amazon S3 generates this ID automatically and returns it after a successful
         * <code>Create Job</code> request.
         * </p>
         * 
         * @param jobId
         *        The ID for this job. Amazon S3 generates this ID automatically and returns it after a successful
         *        <code>Create Job</code> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);
    }

    static final class BuilderImpl extends S3ControlResponse.BuilderImpl implements Builder {
        private String jobId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateJobResponse model) {
            super(model);
            jobId(model.jobId);
        }

        public final String getJobId() {
            return jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public CreateJobResponse build() {
            return new CreateJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
