/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.RequiredTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The inventory table configuration for an S3 Metadata configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InventoryTableConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<InventoryTableConfiguration.Builder, InventoryTableConfiguration> {
    private static final SdkField<String> CONFIGURATION_STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationState")
            .getter(getter(InventoryTableConfiguration::configurationStateAsString))
            .setter(setter(Builder::configurationState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationState")
                    .unmarshallLocationName("ConfigurationState").build(), RequiredTrait.create()).build();

    private static final SdkField<MetadataTableEncryptionConfiguration> ENCRYPTION_CONFIGURATION_FIELD = SdkField
            .<MetadataTableEncryptionConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("EncryptionConfiguration")
            .getter(getter(InventoryTableConfiguration::encryptionConfiguration))
            .setter(setter(Builder::encryptionConfiguration))
            .constructor(MetadataTableEncryptionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionConfiguration")
                    .unmarshallLocationName("EncryptionConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_STATE_FIELD,
            ENCRYPTION_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String configurationState;

    private final MetadataTableEncryptionConfiguration encryptionConfiguration;

    private InventoryTableConfiguration(BuilderImpl builder) {
        this.configurationState = builder.configurationState;
        this.encryptionConfiguration = builder.encryptionConfiguration;
    }

    /**
     * <p>
     * The configuration state of the inventory table, indicating whether the inventory table is enabled or disabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #configurationState} will return {@link InventoryConfigurationState#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #configurationStateAsString}.
     * </p>
     * 
     * @return The configuration state of the inventory table, indicating whether the inventory table is enabled or
     *         disabled.
     * @see InventoryConfigurationState
     */
    public final InventoryConfigurationState configurationState() {
        return InventoryConfigurationState.fromValue(configurationState);
    }

    /**
     * <p>
     * The configuration state of the inventory table, indicating whether the inventory table is enabled or disabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #configurationState} will return {@link InventoryConfigurationState#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #configurationStateAsString}.
     * </p>
     * 
     * @return The configuration state of the inventory table, indicating whether the inventory table is enabled or
     *         disabled.
     * @see InventoryConfigurationState
     */
    public final String configurationStateAsString() {
        return configurationState;
    }

    /**
     * <p>
     * The encryption configuration for the inventory table.
     * </p>
     * 
     * @return The encryption configuration for the inventory table.
     */
    public final MetadataTableEncryptionConfiguration encryptionConfiguration() {
        return encryptionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configurationStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InventoryTableConfiguration)) {
            return false;
        }
        InventoryTableConfiguration other = (InventoryTableConfiguration) obj;
        return Objects.equals(configurationStateAsString(), other.configurationStateAsString())
                && Objects.equals(encryptionConfiguration(), other.encryptionConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InventoryTableConfiguration").add("ConfigurationState", configurationStateAsString())
                .add("EncryptionConfiguration", encryptionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationState":
            return Optional.ofNullable(clazz.cast(configurationStateAsString()));
        case "EncryptionConfiguration":
            return Optional.ofNullable(clazz.cast(encryptionConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConfigurationState", CONFIGURATION_STATE_FIELD);
        map.put("EncryptionConfiguration", ENCRYPTION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InventoryTableConfiguration, T> g) {
        return obj -> g.apply((InventoryTableConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InventoryTableConfiguration> {
        /**
         * <p>
         * The configuration state of the inventory table, indicating whether the inventory table is enabled or
         * disabled.
         * </p>
         * 
         * @param configurationState
         *        The configuration state of the inventory table, indicating whether the inventory table is enabled or
         *        disabled.
         * @see InventoryConfigurationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InventoryConfigurationState
         */
        Builder configurationState(String configurationState);

        /**
         * <p>
         * The configuration state of the inventory table, indicating whether the inventory table is enabled or
         * disabled.
         * </p>
         * 
         * @param configurationState
         *        The configuration state of the inventory table, indicating whether the inventory table is enabled or
         *        disabled.
         * @see InventoryConfigurationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InventoryConfigurationState
         */
        Builder configurationState(InventoryConfigurationState configurationState);

        /**
         * <p>
         * The encryption configuration for the inventory table.
         * </p>
         * 
         * @param encryptionConfiguration
         *        The encryption configuration for the inventory table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionConfiguration(MetadataTableEncryptionConfiguration encryptionConfiguration);

        /**
         * <p>
         * The encryption configuration for the inventory table.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link MetadataTableEncryptionConfiguration.Builder} avoiding the need to create one manually via
         * {@link MetadataTableEncryptionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MetadataTableEncryptionConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #encryptionConfiguration(MetadataTableEncryptionConfiguration)}.
         * 
         * @param encryptionConfiguration
         *        a consumer that will call methods on {@link MetadataTableEncryptionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionConfiguration(MetadataTableEncryptionConfiguration)
         */
        default Builder encryptionConfiguration(Consumer<MetadataTableEncryptionConfiguration.Builder> encryptionConfiguration) {
            return encryptionConfiguration(MetadataTableEncryptionConfiguration.builder().applyMutation(encryptionConfiguration)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String configurationState;

        private MetadataTableEncryptionConfiguration encryptionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(InventoryTableConfiguration model) {
            configurationState(model.configurationState);
            encryptionConfiguration(model.encryptionConfiguration);
        }

        public final String getConfigurationState() {
            return configurationState;
        }

        public final void setConfigurationState(String configurationState) {
            this.configurationState = configurationState;
        }

        @Override
        public final Builder configurationState(String configurationState) {
            this.configurationState = configurationState;
            return this;
        }

        @Override
        public final Builder configurationState(InventoryConfigurationState configurationState) {
            this.configurationState(configurationState == null ? null : configurationState.toString());
            return this;
        }

        public final MetadataTableEncryptionConfiguration.Builder getEncryptionConfiguration() {
            return encryptionConfiguration != null ? encryptionConfiguration.toBuilder() : null;
        }

        public final void setEncryptionConfiguration(MetadataTableEncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        @Override
        public final Builder encryptionConfiguration(MetadataTableEncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        @Override
        public InventoryTableConfiguration build() {
            return new InventoryTableConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
