/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.endpoints;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.regions.PartitionMetadata;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Configuration;
import software.amazon.awssdk.services.s3.internal.ConfiguredS3SdkHttpRequest;
import software.amazon.awssdk.services.s3.internal.endpoints.S3EndpointResolver;
import software.amazon.awssdk.services.s3.internal.endpoints.S3EndpointResolverContext;
import software.amazon.awssdk.services.s3.internal.endpoints.S3ObjectLambdaOperationEndpointBuilder;
import software.amazon.awssdk.services.s3.model.S3Request;
import software.amazon.awssdk.services.s3.model.WriteGetObjectResponseRequest;
import software.amazon.awssdk.utils.StringUtils;

@SdkInternalApi
public class S3ObjectLambdaOperationEndpointResolver
implements S3EndpointResolver {
    private static final String SIGNING_NAME = "s3-object-lambda";

    @Override
    public ConfiguredS3SdkHttpRequest applyEndpointConfiguration(S3EndpointResolverContext context) {
        S3Request originalRequest = (S3Request)context.originalRequest();
        S3ObjectLambdaOperationEndpointResolver.validateObjectLambdaRequest((SdkRequest)originalRequest);
        S3Configuration configuration = context.serviceConfiguration();
        S3ObjectLambdaOperationEndpointResolver.validateConfiguration(configuration);
        SdkHttpRequest updatedRequest = context.request();
        if (context.endpointOverride() == null) {
            String newHost = S3ObjectLambdaOperationEndpointResolver.getUriForObjectLambdaOperation(context).getHost();
            if (!context.isDisableHostPrefixInjection()) {
                newHost = S3ObjectLambdaOperationEndpointResolver.applyHostPrefix(newHost, originalRequest);
            }
            updatedRequest = (SdkHttpRequest)((SdkHttpRequest.Builder)updatedRequest.toBuilder()).host(newHost).build();
        }
        return ConfiguredS3SdkHttpRequest.builder().sdkHttpRequest(updatedRequest).signingServiceModification(SIGNING_NAME).build();
    }

    public static S3ObjectLambdaOperationEndpointResolver create() {
        return new S3ObjectLambdaOperationEndpointResolver();
    }

    private static void validateConfiguration(S3Configuration configuration) {
        S3ObjectLambdaOperationEndpointResolver.validateNotAccelerateEnabled(configuration);
        S3ObjectLambdaOperationEndpointResolver.validateNotDualStackEnabled(configuration);
    }

    private static void validateObjectLambdaRequest(SdkRequest request) {
        if (!(request instanceof WriteGetObjectResponseRequest)) {
            String msg = String.format("%s is not an S3 Object Lambda operation", request);
            throw new IllegalArgumentException(msg);
        }
    }

    private static void validateNotAccelerateEnabled(S3Configuration configuration) {
        if (configuration.accelerateModeEnabled()) {
            throw new IllegalArgumentException("S3 Object Lambda does not support accelerate endpoints");
        }
    }

    private static void validateNotDualStackEnabled(S3Configuration configuration) {
        if (configuration.dualstackEnabled()) {
            throw new IllegalArgumentException("S3 Object Lambda does not support dualstack endpoints");
        }
    }

    private static URI getUriForObjectLambdaOperation(S3EndpointResolverContext context) {
        PartitionMetadata clientPartitionMetadata = PartitionMetadata.of((Region)context.region());
        return S3ObjectLambdaOperationEndpointBuilder.create().domain(clientPartitionMetadata.dnsSuffix()).protocol(context.request().protocol()).region(context.region().id()).toUri();
    }

    private static String applyHostPrefix(String host, S3Request request) {
        String prefix = S3ObjectLambdaOperationEndpointResolver.getPrefix(request);
        if (!StringUtils.isBlank((CharSequence)prefix)) {
            return prefix + "." + host;
        }
        return host;
    }

    private static String getPrefix(S3Request request) {
        if (request instanceof WriteGetObjectResponseRequest) {
            return ((WriteGetObjectResponseRequest)request).requestRoute();
        }
        throw new RuntimeException("Unable to determine prefix for request " + (Object)((Object)request));
    }
}

