/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.crt;

import java.nio.charset.StandardCharsets;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.crt.auth.credentials.Credentials;
import software.amazon.awssdk.crt.auth.credentials.CredentialsProvider;
import software.amazon.awssdk.crt.auth.credentials.DelegateCredentialsProvider;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkInternalApi
public final class CrtCredentialsProviderAdapter
implements SdkAutoCloseable {
    private final AwsCredentialsProvider credentialsProvider;
    private final CredentialsProvider crtCredentials;

    public CrtCredentialsProviderAdapter(AwsCredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
        this.crtCredentials = new DelegateCredentialsProvider.DelegateCredentialsProviderBuilder().withHandler(() -> {
            AwsCredentials sdkCredentials = credentialsProvider.resolveCredentials();
            byte[] accessKey = sdkCredentials.accessKeyId().getBytes(StandardCharsets.UTF_8);
            byte[] secreteKey = sdkCredentials.secretAccessKey().getBytes(StandardCharsets.UTF_8);
            byte[] sessionTokens = null;
            if (sdkCredentials instanceof AwsSessionCredentials) {
                sessionTokens = ((AwsSessionCredentials)sdkCredentials).sessionToken().getBytes(StandardCharsets.UTF_8);
            }
            return new Credentials(accessKey, secreteKey, sessionTokens);
        }).build();
    }

    public CredentialsProvider crtCredentials() {
        return this.crtCredentials;
    }

    public void close() {
        if (this.credentialsProvider instanceof SdkAutoCloseable) {
            ((SdkAutoCloseable)this.credentialsProvider).close();
        }
        this.crtCredentials.close();
    }
}

