/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutObjectAclRequest extends S3Request implements
        ToCopyableBuilder<PutObjectAclRequest.Builder, PutObjectAclRequest> {
    private static final SdkField<String> ACL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ACL")
            .getter(getter(PutObjectAclRequest::aclAsString))
            .setter(setter(Builder::acl))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-acl")
                    .unmarshallLocationName("x-amz-acl").build()).build();

    private static final SdkField<AccessControlPolicy> ACCESS_CONTROL_POLICY_FIELD = SdkField
            .<AccessControlPolicy> builder(MarshallingType.SDK_POJO)
            .memberName("AccessControlPolicy")
            .getter(getter(PutObjectAclRequest::accessControlPolicy))
            .setter(setter(Builder::accessControlPolicy))
            .constructor(AccessControlPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessControlPolicy")
                    .unmarshallLocationName("AccessControlPolicy").build(), PayloadTrait.create()).build();

    private static final SdkField<String> BUCKET_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Bucket")
            .getter(getter(PutObjectAclRequest::bucket))
            .setter(setter(Builder::bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Bucket")
                    .unmarshallLocationName("Bucket").build()).build();

    private static final SdkField<String> CONTENT_MD5_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ContentMD5")
            .getter(getter(PutObjectAclRequest::contentMD5))
            .setter(setter(Builder::contentMD5))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-MD5")
                    .unmarshallLocationName("Content-MD5").build()).build();

    private static final SdkField<String> GRANT_FULL_CONTROL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("GrantFullControl")
            .getter(getter(PutObjectAclRequest::grantFullControl))
            .setter(setter(Builder::grantFullControl))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-grant-full-control")
                    .unmarshallLocationName("x-amz-grant-full-control").build()).build();

    private static final SdkField<String> GRANT_READ_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("GrantRead")
            .getter(getter(PutObjectAclRequest::grantRead))
            .setter(setter(Builder::grantRead))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-grant-read")
                    .unmarshallLocationName("x-amz-grant-read").build()).build();

    private static final SdkField<String> GRANT_READ_ACP_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("GrantReadACP")
            .getter(getter(PutObjectAclRequest::grantReadACP))
            .setter(setter(Builder::grantReadACP))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-grant-read-acp")
                    .unmarshallLocationName("x-amz-grant-read-acp").build()).build();

    private static final SdkField<String> GRANT_WRITE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("GrantWrite")
            .getter(getter(PutObjectAclRequest::grantWrite))
            .setter(setter(Builder::grantWrite))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-grant-write")
                    .unmarshallLocationName("x-amz-grant-write").build()).build();

    private static final SdkField<String> GRANT_WRITE_ACP_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("GrantWriteACP")
            .getter(getter(PutObjectAclRequest::grantWriteACP))
            .setter(setter(Builder::grantWriteACP))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-grant-write-acp")
                    .unmarshallLocationName("x-amz-grant-write-acp").build()).build();

    private static final SdkField<String> KEY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Key")
            .getter(getter(PutObjectAclRequest::key))
            .setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.GREEDY_PATH).locationName("Key")
                    .unmarshallLocationName("Key").build()).build();

    private static final SdkField<String> REQUEST_PAYER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RequestPayer")
            .getter(getter(PutObjectAclRequest::requestPayerAsString))
            .setter(setter(Builder::requestPayer))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-request-payer")
                    .unmarshallLocationName("x-amz-request-payer").build()).build();

    private static final SdkField<String> VERSION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VersionId")
            .getter(getter(PutObjectAclRequest::versionId))
            .setter(setter(Builder::versionId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("versionId")
                    .unmarshallLocationName("versionId").build()).build();

    private static final SdkField<String> EXPECTED_BUCKET_OWNER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ExpectedBucketOwner")
            .getter(getter(PutObjectAclRequest::expectedBucketOwner))
            .setter(setter(Builder::expectedBucketOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-expected-bucket-owner")
                    .unmarshallLocationName("x-amz-expected-bucket-owner").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACL_FIELD,
            ACCESS_CONTROL_POLICY_FIELD, BUCKET_FIELD, CONTENT_MD5_FIELD, GRANT_FULL_CONTROL_FIELD, GRANT_READ_FIELD,
            GRANT_READ_ACP_FIELD, GRANT_WRITE_FIELD, GRANT_WRITE_ACP_FIELD, KEY_FIELD, REQUEST_PAYER_FIELD, VERSION_ID_FIELD,
            EXPECTED_BUCKET_OWNER_FIELD));

    private final String acl;

    private final AccessControlPolicy accessControlPolicy;

    private final String bucket;

    private final String contentMD5;

    private final String grantFullControl;

    private final String grantRead;

    private final String grantReadACP;

    private final String grantWrite;

    private final String grantWriteACP;

    private final String key;

    private final String requestPayer;

    private final String versionId;

    private final String expectedBucketOwner;

    private PutObjectAclRequest(BuilderImpl builder) {
        super(builder);
        this.acl = builder.acl;
        this.accessControlPolicy = builder.accessControlPolicy;
        this.bucket = builder.bucket;
        this.contentMD5 = builder.contentMD5;
        this.grantFullControl = builder.grantFullControl;
        this.grantRead = builder.grantRead;
        this.grantReadACP = builder.grantReadACP;
        this.grantWrite = builder.grantWrite;
        this.grantWriteACP = builder.grantWriteACP;
        this.key = builder.key;
        this.requestPayer = builder.requestPayer;
        this.versionId = builder.versionId;
        this.expectedBucketOwner = builder.expectedBucketOwner;
    }

    /**
     * <p>
     * The canned ACL to apply to the object. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#CannedACL">Canned ACL</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #acl} will return
     * {@link ObjectCannedACL#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #aclAsString}.
     * </p>
     * 
     * @return The canned ACL to apply to the object. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#CannedACL">Canned ACL</a>.
     * @see ObjectCannedACL
     */
    public ObjectCannedACL acl() {
        return ObjectCannedACL.fromValue(acl);
    }

    /**
     * <p>
     * The canned ACL to apply to the object. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#CannedACL">Canned ACL</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #acl} will return
     * {@link ObjectCannedACL#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #aclAsString}.
     * </p>
     * 
     * @return The canned ACL to apply to the object. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#CannedACL">Canned ACL</a>.
     * @see ObjectCannedACL
     */
    public String aclAsString() {
        return acl;
    }

    /**
     * <p>
     * Contains the elements that set the ACL permissions for an object per grantee.
     * </p>
     * 
     * @return Contains the elements that set the ACL permissions for an object per grantee.
     */
    public AccessControlPolicy accessControlPolicy() {
        return accessControlPolicy;
    }

    /**
     * <p>
     * The bucket name that contains the object to which you want to attach the ACL.
     * </p>
     * <p>
     * When using this API with an access point, you must direct requests to the access point hostname. The access point
     * hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When
     * using this operation using an access point through the AWS SDKs, you provide the access point ARN in place of the
     * bucket name. For more information about access point ARNs, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-access-points.html">Using Access Points</a> in the
     * <i>Amazon Simple Storage Service Developer Guide</i>.
     * </p>
     * 
     * @return The bucket name that contains the object to which you want to attach the ACL. </p>
     *         <p>
     *         When using this API with an access point, you must direct requests to the access point hostname. The
     *         access point hostname takes the form
     *         <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this
     *         operation using an access point through the AWS SDKs, you provide the access point ARN in place of the
     *         bucket name. For more information about access point ARNs, see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-access-points.html">Using Access Points</a>
     *         in the <i>Amazon Simple Storage Service Developer Guide</i>.
     */
    public String bucket() {
        return bucket;
    }

    /**
     * <p>
     * The base64-encoded 128-bit MD5 digest of the data. This header must be used as a message integrity check to
     * verify that the request body was not corrupted in transit. For more information, go to <a
     * href="http://www.ietf.org/rfc/rfc1864.txt">RFC 1864.&gt;</a>
     * </p>
     * 
     * @return The base64-encoded 128-bit MD5 digest of the data. This header must be used as a message integrity check
     *         to verify that the request body was not corrupted in transit. For more information, go to <a
     *         href="http://www.ietf.org/rfc/rfc1864.txt">RFC 1864.&gt;</a>
     */
    public String contentMD5() {
        return contentMD5;
    }

    /**
     * <p>
     * Allows grantee the read, write, read ACP, and write ACP permissions on the bucket.
     * </p>
     * 
     * @return Allows grantee the read, write, read ACP, and write ACP permissions on the bucket.
     */
    public String grantFullControl() {
        return grantFullControl;
    }

    /**
     * <p>
     * Allows grantee to list the objects in the bucket.
     * </p>
     * 
     * @return Allows grantee to list the objects in the bucket.
     */
    public String grantRead() {
        return grantRead;
    }

    /**
     * <p>
     * Allows grantee to read the bucket ACL.
     * </p>
     * 
     * @return Allows grantee to read the bucket ACL.
     */
    public String grantReadACP() {
        return grantReadACP;
    }

    /**
     * <p>
     * Allows grantee to create, overwrite, and delete any object in the bucket.
     * </p>
     * 
     * @return Allows grantee to create, overwrite, and delete any object in the bucket.
     */
    public String grantWrite() {
        return grantWrite;
    }

    /**
     * <p>
     * Allows grantee to write the ACL for the applicable bucket.
     * </p>
     * 
     * @return Allows grantee to write the ACL for the applicable bucket.
     */
    public String grantWriteACP() {
        return grantWriteACP;
    }

    /**
     * <p>
     * Key for which the PUT operation was initiated.
     * </p>
     * <p>
     * When using this API with an access point, you must direct requests to the access point hostname. The access point
     * hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When
     * using this operation using an access point through the AWS SDKs, you provide the access point ARN in place of the
     * bucket name. For more information about access point ARNs, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-access-points.html">Using Access Points</a> in the
     * <i>Amazon Simple Storage Service Developer Guide</i>.
     * </p>
     * <p>
     * When using this API with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3
     * on Outposts hostname takes the form
     * <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this
     * operation using S3 on Outposts through the AWS SDKs, you provide the Outposts bucket ARN in place of the bucket
     * name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/">Using S3 on
     * Outposts</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.
     * </p>
     * 
     * @return Key for which the PUT operation was initiated.</p>
     *         <p>
     *         When using this API with an access point, you must direct requests to the access point hostname. The
     *         access point hostname takes the form
     *         <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this
     *         operation using an access point through the AWS SDKs, you provide the access point ARN in place of the
     *         bucket name. For more information about access point ARNs, see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-access-points.html">Using Access Points</a>
     *         in the <i>Amazon Simple Storage Service Developer Guide</i>.
     *         </p>
     *         <p>
     *         When using this API with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname.
     *         The S3 on Outposts hostname takes the form
     *         <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When
     *         using this operation using S3 on Outposts through the AWS SDKs, you provide the Outposts bucket ARN in
     *         place of the bucket name. For more information about S3 on Outposts ARNs, see <a
     *         href="https://docs.aws.amazon.com/">Using S3 on Outposts</a> in the <i>Amazon Simple Storage Service
     *         Developer Guide</i>.
     */
    public String key() {
        return key;
    }

    /**
     * Returns the value of the RequestPayer property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #requestPayer} will
     * return {@link RequestPayer#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #requestPayerAsString}.
     * </p>
     * 
     * @return The value of the RequestPayer property for this object.
     * @see RequestPayer
     */
    public RequestPayer requestPayer() {
        return RequestPayer.fromValue(requestPayer);
    }

    /**
     * Returns the value of the RequestPayer property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #requestPayer} will
     * return {@link RequestPayer#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #requestPayerAsString}.
     * </p>
     * 
     * @return The value of the RequestPayer property for this object.
     * @see RequestPayer
     */
    public String requestPayerAsString() {
        return requestPayer;
    }

    /**
     * <p>
     * VersionId used to reference a specific version of the object.
     * </p>
     * 
     * @return VersionId used to reference a specific version of the object.
     */
    public String versionId() {
        return versionId;
    }

    /**
     * <p>
     * The account id of the expected bucket owner. If the bucket is owned by a different account, the request will fail
     * with an HTTP <code>403 (Access Denied)</code> error.
     * </p>
     * 
     * @return The account id of the expected bucket owner. If the bucket is owned by a different account, the request
     *         will fail with an HTTP <code>403 (Access Denied)</code> error.
     */
    public String expectedBucketOwner() {
        return expectedBucketOwner;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(aclAsString());
        hashCode = 31 * hashCode + Objects.hashCode(accessControlPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(bucket());
        hashCode = 31 * hashCode + Objects.hashCode(contentMD5());
        hashCode = 31 * hashCode + Objects.hashCode(grantFullControl());
        hashCode = 31 * hashCode + Objects.hashCode(grantRead());
        hashCode = 31 * hashCode + Objects.hashCode(grantReadACP());
        hashCode = 31 * hashCode + Objects.hashCode(grantWrite());
        hashCode = 31 * hashCode + Objects.hashCode(grantWriteACP());
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(requestPayerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(versionId());
        hashCode = 31 * hashCode + Objects.hashCode(expectedBucketOwner());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutObjectAclRequest)) {
            return false;
        }
        PutObjectAclRequest other = (PutObjectAclRequest) obj;
        return Objects.equals(aclAsString(), other.aclAsString())
                && Objects.equals(accessControlPolicy(), other.accessControlPolicy()) && Objects.equals(bucket(), other.bucket())
                && Objects.equals(contentMD5(), other.contentMD5())
                && Objects.equals(grantFullControl(), other.grantFullControl()) && Objects.equals(grantRead(), other.grantRead())
                && Objects.equals(grantReadACP(), other.grantReadACP()) && Objects.equals(grantWrite(), other.grantWrite())
                && Objects.equals(grantWriteACP(), other.grantWriteACP()) && Objects.equals(key(), other.key())
                && Objects.equals(requestPayerAsString(), other.requestPayerAsString())
                && Objects.equals(versionId(), other.versionId())
                && Objects.equals(expectedBucketOwner(), other.expectedBucketOwner());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutObjectAclRequest").add("ACL", aclAsString())
                .add("AccessControlPolicy", accessControlPolicy()).add("Bucket", bucket()).add("ContentMD5", contentMD5())
                .add("GrantFullControl", grantFullControl()).add("GrantRead", grantRead()).add("GrantReadACP", grantReadACP())
                .add("GrantWrite", grantWrite()).add("GrantWriteACP", grantWriteACP()).add("Key", key())
                .add("RequestPayer", requestPayerAsString()).add("VersionId", versionId())
                .add("ExpectedBucketOwner", expectedBucketOwner()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ACL":
            return Optional.ofNullable(clazz.cast(aclAsString()));
        case "AccessControlPolicy":
            return Optional.ofNullable(clazz.cast(accessControlPolicy()));
        case "Bucket":
            return Optional.ofNullable(clazz.cast(bucket()));
        case "ContentMD5":
            return Optional.ofNullable(clazz.cast(contentMD5()));
        case "GrantFullControl":
            return Optional.ofNullable(clazz.cast(grantFullControl()));
        case "GrantRead":
            return Optional.ofNullable(clazz.cast(grantRead()));
        case "GrantReadACP":
            return Optional.ofNullable(clazz.cast(grantReadACP()));
        case "GrantWrite":
            return Optional.ofNullable(clazz.cast(grantWrite()));
        case "GrantWriteACP":
            return Optional.ofNullable(clazz.cast(grantWriteACP()));
        case "Key":
            return Optional.ofNullable(clazz.cast(key()));
        case "RequestPayer":
            return Optional.ofNullable(clazz.cast(requestPayerAsString()));
        case "VersionId":
            return Optional.ofNullable(clazz.cast(versionId()));
        case "ExpectedBucketOwner":
            return Optional.ofNullable(clazz.cast(expectedBucketOwner()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutObjectAclRequest, T> g) {
        return obj -> g.apply((PutObjectAclRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends S3Request.Builder, SdkPojo, CopyableBuilder<Builder, PutObjectAclRequest> {
        /**
         * <p>
         * The canned ACL to apply to the object. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#CannedACL">Canned ACL</a>.
         * </p>
         * 
         * @param acl
         *        The canned ACL to apply to the object. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#CannedACL">Canned ACL</a>.
         * @see ObjectCannedACL
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ObjectCannedACL
         */
        Builder acl(String acl);

        /**
         * <p>
         * The canned ACL to apply to the object. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#CannedACL">Canned ACL</a>.
         * </p>
         * 
         * @param acl
         *        The canned ACL to apply to the object. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#CannedACL">Canned ACL</a>.
         * @see ObjectCannedACL
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ObjectCannedACL
         */
        Builder acl(ObjectCannedACL acl);

        /**
         * <p>
         * Contains the elements that set the ACL permissions for an object per grantee.
         * </p>
         * 
         * @param accessControlPolicy
         *        Contains the elements that set the ACL permissions for an object per grantee.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessControlPolicy(AccessControlPolicy accessControlPolicy);

        /**
         * <p>
         * Contains the elements that set the ACL permissions for an object per grantee.
         * </p>
         * This is a convenience that creates an instance of the {@link AccessControlPolicy.Builder} avoiding the need
         * to create one manually via {@link AccessControlPolicy#builder()}.
         *
         * When the {@link Consumer} completes, {@link AccessControlPolicy.Builder#build()} is called immediately and
         * its result is passed to {@link #accessControlPolicy(AccessControlPolicy)}.
         * 
         * @param accessControlPolicy
         *        a consumer that will call methods on {@link AccessControlPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessControlPolicy(AccessControlPolicy)
         */
        default Builder accessControlPolicy(Consumer<AccessControlPolicy.Builder> accessControlPolicy) {
            return accessControlPolicy(AccessControlPolicy.builder().applyMutation(accessControlPolicy).build());
        }

        /**
         * <p>
         * The bucket name that contains the object to which you want to attach the ACL.
         * </p>
         * <p>
         * When using this API with an access point, you must direct requests to the access point hostname. The access
         * point hostname takes the form
         * <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this operation
         * using an access point through the AWS SDKs, you provide the access point ARN in place of the bucket name. For
         * more information about access point ARNs, see <a
         * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-access-points.html">Using Access Points</a> in
         * the <i>Amazon Simple Storage Service Developer Guide</i>.
         * </p>
         * 
         * @param bucket
         *        The bucket name that contains the object to which you want to attach the ACL. </p>
         *        <p>
         *        When using this API with an access point, you must direct requests to the access point hostname. The
         *        access point hostname takes the form
         *        <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this
         *        operation using an access point through the AWS SDKs, you provide the access point ARN in place of the
         *        bucket name. For more information about access point ARNs, see <a
         *        href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-access-points.html">Using Access
         *        Points</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * <p>
         * The base64-encoded 128-bit MD5 digest of the data. This header must be used as a message integrity check to
         * verify that the request body was not corrupted in transit. For more information, go to <a
         * href="http://www.ietf.org/rfc/rfc1864.txt">RFC 1864.&gt;</a>
         * </p>
         * 
         * @param contentMD5
         *        The base64-encoded 128-bit MD5 digest of the data. This header must be used as a message integrity
         *        check to verify that the request body was not corrupted in transit. For more information, go to <a
         *        href="http://www.ietf.org/rfc/rfc1864.txt">RFC 1864.&gt;</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentMD5(String contentMD5);

        /**
         * <p>
         * Allows grantee the read, write, read ACP, and write ACP permissions on the bucket.
         * </p>
         * 
         * @param grantFullControl
         *        Allows grantee the read, write, read ACP, and write ACP permissions on the bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantFullControl(String grantFullControl);

        /**
         * <p>
         * Allows grantee to list the objects in the bucket.
         * </p>
         * 
         * @param grantRead
         *        Allows grantee to list the objects in the bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantRead(String grantRead);

        /**
         * <p>
         * Allows grantee to read the bucket ACL.
         * </p>
         * 
         * @param grantReadACP
         *        Allows grantee to read the bucket ACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantReadACP(String grantReadACP);

        /**
         * <p>
         * Allows grantee to create, overwrite, and delete any object in the bucket.
         * </p>
         * 
         * @param grantWrite
         *        Allows grantee to create, overwrite, and delete any object in the bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantWrite(String grantWrite);

        /**
         * <p>
         * Allows grantee to write the ACL for the applicable bucket.
         * </p>
         * 
         * @param grantWriteACP
         *        Allows grantee to write the ACL for the applicable bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantWriteACP(String grantWriteACP);

        /**
         * <p>
         * Key for which the PUT operation was initiated.
         * </p>
         * <p>
         * When using this API with an access point, you must direct requests to the access point hostname. The access
         * point hostname takes the form
         * <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this operation
         * using an access point through the AWS SDKs, you provide the access point ARN in place of the bucket name. For
         * more information about access point ARNs, see <a
         * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-access-points.html">Using Access Points</a> in
         * the <i>Amazon Simple Storage Service Developer Guide</i>.
         * </p>
         * <p>
         * When using this API with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The
         * S3 on Outposts hostname takes the form
         * <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using
         * this operation using S3 on Outposts through the AWS SDKs, you provide the Outposts bucket ARN in place of the
         * bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/">Using
         * S3 on Outposts</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.
         * </p>
         * 
         * @param key
         *        Key for which the PUT operation was initiated.</p>
         *        <p>
         *        When using this API with an access point, you must direct requests to the access point hostname. The
         *        access point hostname takes the form
         *        <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this
         *        operation using an access point through the AWS SDKs, you provide the access point ARN in place of the
         *        bucket name. For more information about access point ARNs, see <a
         *        href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-access-points.html">Using Access
         *        Points</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.
         *        </p>
         *        <p>
         *        When using this API with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts
         *        hostname. The S3 on Outposts hostname takes the form
         *        <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When
         *        using this operation using S3 on Outposts through the AWS SDKs, you provide the Outposts bucket ARN in
         *        place of the bucket name. For more information about S3 on Outposts ARNs, see <a
         *        href="https://docs.aws.amazon.com/">Using S3 on Outposts</a> in the <i>Amazon Simple Storage Service
         *        Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * Sets the value of the RequestPayer property for this object.
         *
         * @param requestPayer
         *        The new value for the RequestPayer property for this object.
         * @see RequestPayer
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RequestPayer
         */
        Builder requestPayer(String requestPayer);

        /**
         * Sets the value of the RequestPayer property for this object.
         *
         * @param requestPayer
         *        The new value for the RequestPayer property for this object.
         * @see RequestPayer
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RequestPayer
         */
        Builder requestPayer(RequestPayer requestPayer);

        /**
         * <p>
         * VersionId used to reference a specific version of the object.
         * </p>
         * 
         * @param versionId
         *        VersionId used to reference a specific version of the object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionId(String versionId);

        /**
         * <p>
         * The account id of the expected bucket owner. If the bucket is owned by a different account, the request will
         * fail with an HTTP <code>403 (Access Denied)</code> error.
         * </p>
         * 
         * @param expectedBucketOwner
         *        The account id of the expected bucket owner. If the bucket is owned by a different account, the
         *        request will fail with an HTTP <code>403 (Access Denied)</code> error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expectedBucketOwner(String expectedBucketOwner);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends S3Request.BuilderImpl implements Builder {
        private String acl;

        private AccessControlPolicy accessControlPolicy;

        private String bucket;

        private String contentMD5;

        private String grantFullControl;

        private String grantRead;

        private String grantReadACP;

        private String grantWrite;

        private String grantWriteACP;

        private String key;

        private String requestPayer;

        private String versionId;

        private String expectedBucketOwner;

        private BuilderImpl() {
        }

        private BuilderImpl(PutObjectAclRequest model) {
            super(model);
            acl(model.acl);
            accessControlPolicy(model.accessControlPolicy);
            bucket(model.bucket);
            contentMD5(model.contentMD5);
            grantFullControl(model.grantFullControl);
            grantRead(model.grantRead);
            grantReadACP(model.grantReadACP);
            grantWrite(model.grantWrite);
            grantWriteACP(model.grantWriteACP);
            key(model.key);
            requestPayer(model.requestPayer);
            versionId(model.versionId);
            expectedBucketOwner(model.expectedBucketOwner);
        }

        public final String getAcl() {
            return acl;
        }

        @Override
        public final Builder acl(String acl) {
            this.acl = acl;
            return this;
        }

        @Override
        public final Builder acl(ObjectCannedACL acl) {
            this.acl(acl == null ? null : acl.toString());
            return this;
        }

        public final void setAcl(String acl) {
            this.acl = acl;
        }

        public final AccessControlPolicy.Builder getAccessControlPolicy() {
            return accessControlPolicy != null ? accessControlPolicy.toBuilder() : null;
        }

        @Override
        public final Builder accessControlPolicy(AccessControlPolicy accessControlPolicy) {
            this.accessControlPolicy = accessControlPolicy;
            return this;
        }

        public final void setAccessControlPolicy(AccessControlPolicy.BuilderImpl accessControlPolicy) {
            this.accessControlPolicy = accessControlPolicy != null ? accessControlPolicy.build() : null;
        }

        public final String getBucket() {
            return bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getContentMD5() {
            return contentMD5;
        }

        @Override
        public final Builder contentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
            return this;
        }

        public final void setContentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
        }

        public final String getGrantFullControl() {
            return grantFullControl;
        }

        @Override
        public final Builder grantFullControl(String grantFullControl) {
            this.grantFullControl = grantFullControl;
            return this;
        }

        public final void setGrantFullControl(String grantFullControl) {
            this.grantFullControl = grantFullControl;
        }

        public final String getGrantRead() {
            return grantRead;
        }

        @Override
        public final Builder grantRead(String grantRead) {
            this.grantRead = grantRead;
            return this;
        }

        public final void setGrantRead(String grantRead) {
            this.grantRead = grantRead;
        }

        public final String getGrantReadACP() {
            return grantReadACP;
        }

        @Override
        public final Builder grantReadACP(String grantReadACP) {
            this.grantReadACP = grantReadACP;
            return this;
        }

        public final void setGrantReadACP(String grantReadACP) {
            this.grantReadACP = grantReadACP;
        }

        public final String getGrantWrite() {
            return grantWrite;
        }

        @Override
        public final Builder grantWrite(String grantWrite) {
            this.grantWrite = grantWrite;
            return this;
        }

        public final void setGrantWrite(String grantWrite) {
            this.grantWrite = grantWrite;
        }

        public final String getGrantWriteACP() {
            return grantWriteACP;
        }

        @Override
        public final Builder grantWriteACP(String grantWriteACP) {
            this.grantWriteACP = grantWriteACP;
            return this;
        }

        public final void setGrantWriteACP(String grantWriteACP) {
            this.grantWriteACP = grantWriteACP;
        }

        public final String getKey() {
            return key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getRequestPayer() {
            return requestPayer;
        }

        @Override
        public final Builder requestPayer(String requestPayer) {
            this.requestPayer = requestPayer;
            return this;
        }

        @Override
        public final Builder requestPayer(RequestPayer requestPayer) {
            this.requestPayer(requestPayer == null ? null : requestPayer.toString());
            return this;
        }

        public final void setRequestPayer(String requestPayer) {
            this.requestPayer = requestPayer;
        }

        public final String getVersionId() {
            return versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        public final String getExpectedBucketOwner() {
            return expectedBucketOwner;
        }

        @Override
        public final Builder expectedBucketOwner(String expectedBucketOwner) {
            this.expectedBucketOwner = expectedBucketOwner;
            return this;
        }

        public final void setExpectedBucketOwner(String expectedBucketOwner) {
            this.expectedBucketOwner = expectedBucketOwner;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutObjectAclRequest build() {
            return new PutObjectAclRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
