/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.LoggingEnabled;
import software.amazon.awssdk.services.s3.model.TargetGrant;
import software.amazon.awssdk.services.s3.transform.TargetGrantUnmarshaller;

public class LoggingEnabledUnmarshaller
implements Unmarshaller<LoggingEnabled, StaxUnmarshallerContext> {
    private static final LoggingEnabledUnmarshaller INSTANCE = new LoggingEnabledUnmarshaller();

    public LoggingEnabled unmarshall(StaxUnmarshallerContext context) throws Exception {
        LoggingEnabled.Builder loggingEnabled;
        block7: {
            loggingEnabled = LoggingEnabled.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<TargetGrant> targetGrants = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    loggingEnabled.targetGrants(targetGrants);
                    break block7;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("TargetBucket", targetDepth)) {
                        loggingEnabled.targetBucket(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("TargetGrants", targetDepth)) {
                        targetGrants = new ArrayList<TargetGrant>();
                        continue;
                    }
                    if (context.testExpression("TargetGrants/Grant", targetDepth)) {
                        targetGrants.add(TargetGrantUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("TargetPrefix", targetDepth)) continue;
                    loggingEnabled.targetPrefix(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            loggingEnabled.targetGrants(targetGrants);
        }
        return (LoggingEnabled)loggingEnabled.build();
    }

    public static LoggingEnabledUnmarshaller getInstance() {
        return INSTANCE;
    }
}

