/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.model.ListPartsRequest;
import software.amazon.awssdk.services.s3.model.ListPartsResponse;
import software.amazon.awssdk.services.s3.model.Part;

public class ListPartsPublisher
implements SdkPublisher<ListPartsResponse> {
    private final S3AsyncClient client;
    private final ListPartsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPartsPublisher(S3AsyncClient client, ListPartsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPartsPublisher(S3AsyncClient client, ListPartsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPartsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPartsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<Part> parts() {
        Function<ListPartsResponse, Iterator> getIterator = response -> {
            if (response != null && response.parts() != null) {
                return response.parts().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new ListPartsResponseFetcher(), getIterator, this.isLastPage);
    }

    public final ListPartsPublisher resume(ListPartsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListPartsPublisher(this.client, (ListPartsRequest)((Object)this.firstRequest.toBuilder().partNumberMarker(lastSuccessfulPage.nextPartNumberMarker()).build()));
        }
        return new ListPartsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListPartsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListPartsResponseFetcher
    implements AsyncPageFetcher<ListPartsResponse> {
        private ListPartsResponseFetcher() {
        }

        public boolean hasNextPage(ListPartsResponse previousPage) {
            return previousPage.isTruncated();
        }

        public CompletableFuture<ListPartsResponse> nextPage(ListPartsResponse previousPage) {
            if (previousPage == null) {
                return ListPartsPublisher.this.client.listParts(ListPartsPublisher.this.firstRequest);
            }
            return ListPartsPublisher.this.client.listParts((ListPartsRequest)((Object)ListPartsPublisher.this.firstRequest.toBuilder().partNumberMarker(previousPage.nextPartNumberMarker()).build()));
        }
    }
}

