/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.s3.model.BucketLoggingStatus;
import software.amazon.awssdk.services.s3.model.S3Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutBucketLoggingRequest
extends S3Request
implements ToCopyableBuilder<Builder, PutBucketLoggingRequest> {
    private final String bucket;
    private final BucketLoggingStatus bucketLoggingStatus;
    private final String contentMD5;

    private PutBucketLoggingRequest(BuilderImpl builder) {
        super(builder);
        this.bucket = builder.bucket;
        this.bucketLoggingStatus = builder.bucketLoggingStatus;
        this.contentMD5 = builder.contentMD5;
    }

    public String bucket() {
        return this.bucket;
    }

    public BucketLoggingStatus bucketLoggingStatus() {
        return this.bucketLoggingStatus;
    }

    public String contentMD5() {
        return this.contentMD5;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketLoggingStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentMD5());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutBucketLoggingRequest)) {
            return false;
        }
        PutBucketLoggingRequest other = (PutBucketLoggingRequest)((Object)obj);
        return Objects.equals(this.bucket(), other.bucket()) && Objects.equals(this.bucketLoggingStatus(), other.bucketLoggingStatus()) && Objects.equals(this.contentMD5(), other.contentMD5());
    }

    public String toString() {
        return ToString.builder((String)"PutBucketLoggingRequest").add("Bucket", (Object)this.bucket()).add("BucketLoggingStatus", (Object)this.bucketLoggingStatus()).add("ContentMD5", (Object)this.contentMD5()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Bucket": {
                return Optional.of(clazz.cast(this.bucket()));
            }
            case "BucketLoggingStatus": {
                return Optional.of(clazz.cast(this.bucketLoggingStatus()));
            }
            case "ContentMD5": {
                return Optional.of(clazz.cast(this.contentMD5()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends S3Request.BuilderImpl
    implements Builder {
        private String bucket;
        private BucketLoggingStatus bucketLoggingStatus;
        private String contentMD5;

        private BuilderImpl() {
        }

        private BuilderImpl(PutBucketLoggingRequest model) {
            this.bucket(model.bucket);
            this.bucketLoggingStatus(model.bucketLoggingStatus);
            this.contentMD5(model.contentMD5);
        }

        public final String getBucket() {
            return this.bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final BucketLoggingStatus.Builder getBucketLoggingStatus() {
            return this.bucketLoggingStatus != null ? this.bucketLoggingStatus.toBuilder() : null;
        }

        @Override
        public final Builder bucketLoggingStatus(BucketLoggingStatus bucketLoggingStatus) {
            this.bucketLoggingStatus = bucketLoggingStatus;
            return this;
        }

        public final void setBucketLoggingStatus(BucketLoggingStatus.BuilderImpl bucketLoggingStatus) {
            this.bucketLoggingStatus = bucketLoggingStatus != null ? bucketLoggingStatus.build() : null;
        }

        public final String getContentMD5() {
            return this.contentMD5;
        }

        @Override
        public final Builder contentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
            return this;
        }

        public final void setContentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public PutBucketLoggingRequest build() {
            return new PutBucketLoggingRequest(this);
        }
    }

    public static interface Builder
    extends S3Request.Builder,
    CopyableBuilder<Builder, PutBucketLoggingRequest> {
        public Builder bucket(String var1);

        public Builder bucketLoggingStatus(BucketLoggingStatus var1);

        default public Builder bucketLoggingStatus(Consumer<BucketLoggingStatus.Builder> bucketLoggingStatus) {
            return this.bucketLoggingStatus((BucketLoggingStatus)((BucketLoggingStatus.Builder)BucketLoggingStatus.builder().apply(bucketLoggingStatus)).build());
        }

        public Builder contentMD5(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

