/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.PathMarshallers;
import software.amazon.awssdk.core.util.UriResourcePathUtils;
import software.amazon.awssdk.services.s3.model.GetBucketNotificationConfigurationRequest;

public class GetBucketNotificationConfigurationRequestMarshaller
implements Marshaller<Request<GetBucketNotificationConfigurationRequest>, GetBucketNotificationConfigurationRequest> {
    public Request<GetBucketNotificationConfigurationRequest> marshall(GetBucketNotificationConfigurationRequest getBucketNotificationConfigurationRequest) {
        if (getBucketNotificationConfigurationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)getBucketNotificationConfigurationRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/{Bucket}?notification";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParametersToRequest((Request)request, (String)uriResourcePath);
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", getBucketNotificationConfigurationRequest.bucket());
        request.setResourcePath(uriResourcePath);
        return request;
    }
}

