/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.ErrorDocument;

public class ErrorDocumentUnmarshaller
implements Unmarshaller<ErrorDocument, StaxUnmarshallerContext> {
    private static final ErrorDocumentUnmarshaller INSTANCE = new ErrorDocumentUnmarshaller();

    public ErrorDocument unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        ErrorDocument.Builder errorDocument = ErrorDocument.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (!context.testExpression("Key", targetDepth)) continue;
                errorDocument.key(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (ErrorDocument)errorDocument.build();
    }

    public static ErrorDocumentUnmarshaller getInstance() {
        return INSTANCE;
    }
}

