/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.CommonPrefix;
import software.amazon.awssdk.services.s3.model.DeleteMarkerEntry;
import software.amazon.awssdk.services.s3.model.ListObjectVersionsResponse;
import software.amazon.awssdk.services.s3.model.ObjectVersion;
import software.amazon.awssdk.services.s3.transform.CommonPrefixUnmarshaller;
import software.amazon.awssdk.services.s3.transform.DeleteMarkerEntryUnmarshaller;
import software.amazon.awssdk.services.s3.transform.ObjectVersionUnmarshaller;

public class ListObjectVersionsResponseUnmarshaller
implements Unmarshaller<ListObjectVersionsResponse, StaxUnmarshallerContext> {
    private static final ListObjectVersionsResponseUnmarshaller INSTANCE = new ListObjectVersionsResponseUnmarshaller();

    public ListObjectVersionsResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        ListObjectVersionsResponse.Builder listObjectVersionsResponse;
        block19: {
            listObjectVersionsResponse = ListObjectVersionsResponse.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<ObjectVersion> versions = null;
            ArrayList<DeleteMarkerEntry> deleteMarkers = null;
            ArrayList<CommonPrefix> commonPrefixes = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    listObjectVersionsResponse.versions(versions);
                    listObjectVersionsResponse.deleteMarkers(deleteMarkers);
                    listObjectVersionsResponse.commonPrefixes(commonPrefixes);
                    break block19;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("IsTruncated", targetDepth)) {
                        listObjectVersionsResponse.isTruncated(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("KeyMarker", targetDepth)) {
                        listObjectVersionsResponse.keyMarker(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("VersionIdMarker", targetDepth)) {
                        listObjectVersionsResponse.versionIdMarker(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("NextKeyMarker", targetDepth)) {
                        listObjectVersionsResponse.nextKeyMarker(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("NextVersionIdMarker", targetDepth)) {
                        listObjectVersionsResponse.nextVersionIdMarker(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Version", targetDepth)) {
                        if (versions == null) {
                            versions = new ArrayList<ObjectVersion>();
                        }
                        versions.add(ObjectVersionUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("DeleteMarker", targetDepth)) {
                        if (deleteMarkers == null) {
                            deleteMarkers = new ArrayList<DeleteMarkerEntry>();
                        }
                        deleteMarkers.add(DeleteMarkerEntryUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Name", targetDepth)) {
                        listObjectVersionsResponse.name(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Prefix", targetDepth)) {
                        listObjectVersionsResponse.prefix(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Delimiter", targetDepth)) {
                        listObjectVersionsResponse.delimiter(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("MaxKeys", targetDepth)) {
                        listObjectVersionsResponse.maxKeys(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("CommonPrefixes", targetDepth)) {
                        if (commonPrefixes == null) {
                            commonPrefixes = new ArrayList<CommonPrefix>();
                        }
                        commonPrefixes.add(CommonPrefixUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("EncodingType", targetDepth)) continue;
                    listObjectVersionsResponse.encodingType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            listObjectVersionsResponse.versions(versions);
            listObjectVersionsResponse.deleteMarkers(deleteMarkers);
            listObjectVersionsResponse.commonPrefixes(commonPrefixes);
        }
        return (ListObjectVersionsResponse)((Object)listObjectVersionsResponse.build());
    }

    public static ListObjectVersionsResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}

