/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.Bucket;
import software.amazon.awssdk.services.s3.model.ListBucketsResponse;
import software.amazon.awssdk.services.s3.transform.BucketUnmarshaller;
import software.amazon.awssdk.services.s3.transform.OwnerUnmarshaller;

public class ListBucketsResponseUnmarshaller
implements Unmarshaller<ListBucketsResponse, StaxUnmarshallerContext> {
    private static final ListBucketsResponseUnmarshaller INSTANCE = new ListBucketsResponseUnmarshaller();

    public ListBucketsResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        ListBucketsResponse.Builder listBucketsResponse;
        block6: {
            listBucketsResponse = ListBucketsResponse.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<Bucket> buckets = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    listBucketsResponse.buckets(buckets);
                    break block6;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("Buckets", targetDepth)) {
                        buckets = new ArrayList<Bucket>();
                        continue;
                    }
                    if (context.testExpression("Buckets/Bucket", targetDepth)) {
                        buckets.add(BucketUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("Owner", targetDepth)) continue;
                    listBucketsResponse.owner(OwnerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            listBucketsResponse.buckets(buckets);
        }
        return (ListBucketsResponse)((Object)listBucketsResponse.build());
    }

    public static ListBucketsResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}

