/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.s3.model.CommonPrefix;
import software.amazon.awssdk.services.s3.model.CommonPrefixListCopier;
import software.amazon.awssdk.services.s3.model.EncodingType;
import software.amazon.awssdk.services.s3.model.MultipartUpload;
import software.amazon.awssdk.services.s3.model.MultipartUploadListCopier;
import software.amazon.awssdk.services.s3.model.S3Response;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListMultipartUploadsResponse
extends S3Response
implements ToCopyableBuilder<Builder, ListMultipartUploadsResponse> {
    private final String bucket;
    private final String keyMarker;
    private final String uploadIdMarker;
    private final String nextKeyMarker;
    private final String prefix;
    private final String delimiter;
    private final String nextUploadIdMarker;
    private final Integer maxUploads;
    private final Boolean isTruncated;
    private final List<MultipartUpload> uploads;
    private final List<CommonPrefix> commonPrefixes;
    private final String encodingType;

    private ListMultipartUploadsResponse(BuilderImpl builder) {
        super(builder);
        this.bucket = builder.bucket;
        this.keyMarker = builder.keyMarker;
        this.uploadIdMarker = builder.uploadIdMarker;
        this.nextKeyMarker = builder.nextKeyMarker;
        this.prefix = builder.prefix;
        this.delimiter = builder.delimiter;
        this.nextUploadIdMarker = builder.nextUploadIdMarker;
        this.maxUploads = builder.maxUploads;
        this.isTruncated = builder.isTruncated;
        this.uploads = builder.uploads;
        this.commonPrefixes = builder.commonPrefixes;
        this.encodingType = builder.encodingType;
    }

    public String bucket() {
        return this.bucket;
    }

    public String keyMarker() {
        return this.keyMarker;
    }

    public String uploadIdMarker() {
        return this.uploadIdMarker;
    }

    public String nextKeyMarker() {
        return this.nextKeyMarker;
    }

    public String prefix() {
        return this.prefix;
    }

    public String delimiter() {
        return this.delimiter;
    }

    public String nextUploadIdMarker() {
        return this.nextUploadIdMarker;
    }

    public Integer maxUploads() {
        return this.maxUploads;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public List<MultipartUpload> uploads() {
        return this.uploads;
    }

    public List<CommonPrefix> commonPrefixes() {
        return this.commonPrefixes;
    }

    public EncodingType encodingType() {
        return EncodingType.fromValue(this.encodingType);
    }

    public String encodingTypeString() {
        return this.encodingType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyMarker());
        hashCode = 31 * hashCode + Objects.hashCode(this.uploadIdMarker());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextKeyMarker());
        hashCode = 31 * hashCode + Objects.hashCode(this.prefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.delimiter());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextUploadIdMarker());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxUploads());
        hashCode = 31 * hashCode + Objects.hashCode(this.isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(this.uploads());
        hashCode = 31 * hashCode + Objects.hashCode(this.commonPrefixes());
        hashCode = 31 * hashCode + Objects.hashCode(this.encodingTypeString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMultipartUploadsResponse)) {
            return false;
        }
        ListMultipartUploadsResponse other = (ListMultipartUploadsResponse)((Object)obj);
        return Objects.equals(this.bucket(), other.bucket()) && Objects.equals(this.keyMarker(), other.keyMarker()) && Objects.equals(this.uploadIdMarker(), other.uploadIdMarker()) && Objects.equals(this.nextKeyMarker(), other.nextKeyMarker()) && Objects.equals(this.prefix(), other.prefix()) && Objects.equals(this.delimiter(), other.delimiter()) && Objects.equals(this.nextUploadIdMarker(), other.nextUploadIdMarker()) && Objects.equals(this.maxUploads(), other.maxUploads()) && Objects.equals(this.isTruncated(), other.isTruncated()) && Objects.equals(this.uploads(), other.uploads()) && Objects.equals(this.commonPrefixes(), other.commonPrefixes()) && Objects.equals(this.encodingTypeString(), other.encodingTypeString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.bucket() != null) {
            sb.append("Bucket: ").append(this.bucket()).append(",");
        }
        if (this.keyMarker() != null) {
            sb.append("KeyMarker: ").append(this.keyMarker()).append(",");
        }
        if (this.uploadIdMarker() != null) {
            sb.append("UploadIdMarker: ").append(this.uploadIdMarker()).append(",");
        }
        if (this.nextKeyMarker() != null) {
            sb.append("NextKeyMarker: ").append(this.nextKeyMarker()).append(",");
        }
        if (this.prefix() != null) {
            sb.append("Prefix: ").append(this.prefix()).append(",");
        }
        if (this.delimiter() != null) {
            sb.append("Delimiter: ").append(this.delimiter()).append(",");
        }
        if (this.nextUploadIdMarker() != null) {
            sb.append("NextUploadIdMarker: ").append(this.nextUploadIdMarker()).append(",");
        }
        if (this.maxUploads() != null) {
            sb.append("MaxUploads: ").append(this.maxUploads()).append(",");
        }
        if (this.isTruncated() != null) {
            sb.append("IsTruncated: ").append(this.isTruncated()).append(",");
        }
        if (this.uploads() != null) {
            sb.append("Uploads: ").append(this.uploads()).append(",");
        }
        if (this.commonPrefixes() != null) {
            sb.append("CommonPrefixes: ").append(this.commonPrefixes()).append(",");
        }
        if (this.encodingTypeString() != null) {
            sb.append("EncodingType: ").append(this.encodingTypeString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Bucket": {
                return Optional.of(clazz.cast(this.bucket()));
            }
            case "KeyMarker": {
                return Optional.of(clazz.cast(this.keyMarker()));
            }
            case "UploadIdMarker": {
                return Optional.of(clazz.cast(this.uploadIdMarker()));
            }
            case "NextKeyMarker": {
                return Optional.of(clazz.cast(this.nextKeyMarker()));
            }
            case "Prefix": {
                return Optional.of(clazz.cast(this.prefix()));
            }
            case "Delimiter": {
                return Optional.of(clazz.cast(this.delimiter()));
            }
            case "NextUploadIdMarker": {
                return Optional.of(clazz.cast(this.nextUploadIdMarker()));
            }
            case "MaxUploads": {
                return Optional.of(clazz.cast(this.maxUploads()));
            }
            case "IsTruncated": {
                return Optional.of(clazz.cast(this.isTruncated()));
            }
            case "Uploads": {
                return Optional.of(clazz.cast(this.uploads()));
            }
            case "CommonPrefixes": {
                return Optional.of(clazz.cast(this.commonPrefixes()));
            }
            case "EncodingType": {
                return Optional.of(clazz.cast(this.encodingTypeString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends S3Response.BuilderImpl
    implements Builder {
        private String bucket;
        private String keyMarker;
        private String uploadIdMarker;
        private String nextKeyMarker;
        private String prefix;
        private String delimiter;
        private String nextUploadIdMarker;
        private Integer maxUploads;
        private Boolean isTruncated;
        private List<MultipartUpload> uploads;
        private List<CommonPrefix> commonPrefixes;
        private String encodingType;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMultipartUploadsResponse model) {
            this.bucket(model.bucket);
            this.keyMarker(model.keyMarker);
            this.uploadIdMarker(model.uploadIdMarker);
            this.nextKeyMarker(model.nextKeyMarker);
            this.prefix(model.prefix);
            this.delimiter(model.delimiter);
            this.nextUploadIdMarker(model.nextUploadIdMarker);
            this.maxUploads(model.maxUploads);
            this.isTruncated(model.isTruncated);
            this.uploads(model.uploads);
            this.commonPrefixes(model.commonPrefixes);
            this.encodingType(model.encodingType);
        }

        public final String getBucket() {
            return this.bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getKeyMarker() {
            return this.keyMarker;
        }

        @Override
        public final Builder keyMarker(String keyMarker) {
            this.keyMarker = keyMarker;
            return this;
        }

        public final void setKeyMarker(String keyMarker) {
            this.keyMarker = keyMarker;
        }

        public final String getUploadIdMarker() {
            return this.uploadIdMarker;
        }

        @Override
        public final Builder uploadIdMarker(String uploadIdMarker) {
            this.uploadIdMarker = uploadIdMarker;
            return this;
        }

        public final void setUploadIdMarker(String uploadIdMarker) {
            this.uploadIdMarker = uploadIdMarker;
        }

        public final String getNextKeyMarker() {
            return this.nextKeyMarker;
        }

        @Override
        public final Builder nextKeyMarker(String nextKeyMarker) {
            this.nextKeyMarker = nextKeyMarker;
            return this;
        }

        public final void setNextKeyMarker(String nextKeyMarker) {
            this.nextKeyMarker = nextKeyMarker;
        }

        public final String getPrefix() {
            return this.prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public final String getDelimiter() {
            return this.delimiter;
        }

        @Override
        public final Builder delimiter(String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public final void setDelimiter(String delimiter) {
            this.delimiter = delimiter;
        }

        public final String getNextUploadIdMarker() {
            return this.nextUploadIdMarker;
        }

        @Override
        public final Builder nextUploadIdMarker(String nextUploadIdMarker) {
            this.nextUploadIdMarker = nextUploadIdMarker;
            return this;
        }

        public final void setNextUploadIdMarker(String nextUploadIdMarker) {
            this.nextUploadIdMarker = nextUploadIdMarker;
        }

        public final Integer getMaxUploads() {
            return this.maxUploads;
        }

        @Override
        public final Builder maxUploads(Integer maxUploads) {
            this.maxUploads = maxUploads;
            return this;
        }

        public final void setMaxUploads(Integer maxUploads) {
            this.maxUploads = maxUploads;
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final Collection<MultipartUpload.Builder> getUploads() {
            return this.uploads != null ? (Collection)this.uploads.stream().map(MultipartUpload::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder uploads(Collection<MultipartUpload> uploads) {
            this.uploads = MultipartUploadListCopier.copy(uploads);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder uploads(MultipartUpload ... uploads) {
            this.uploads(Arrays.asList(uploads));
            return this;
        }

        public final void setUploads(Collection<MultipartUpload.BuilderImpl> uploads) {
            this.uploads = MultipartUploadListCopier.copyFromBuilder(uploads);
        }

        public final Collection<CommonPrefix.Builder> getCommonPrefixes() {
            return this.commonPrefixes != null ? (Collection)this.commonPrefixes.stream().map(CommonPrefix::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder commonPrefixes(Collection<CommonPrefix> commonPrefixes) {
            this.commonPrefixes = CommonPrefixListCopier.copy(commonPrefixes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commonPrefixes(CommonPrefix ... commonPrefixes) {
            this.commonPrefixes(Arrays.asList(commonPrefixes));
            return this;
        }

        public final void setCommonPrefixes(Collection<CommonPrefix.BuilderImpl> commonPrefixes) {
            this.commonPrefixes = CommonPrefixListCopier.copyFromBuilder(commonPrefixes);
        }

        public final String getEncodingType() {
            return this.encodingType;
        }

        @Override
        public final Builder encodingType(String encodingType) {
            this.encodingType = encodingType;
            return this;
        }

        @Override
        public final Builder encodingType(EncodingType encodingType) {
            this.encodingType(encodingType.toString());
            return this;
        }

        public final void setEncodingType(String encodingType) {
            this.encodingType = encodingType;
        }

        @Override
        public ListMultipartUploadsResponse build() {
            return new ListMultipartUploadsResponse(this);
        }
    }

    public static interface Builder
    extends S3Response.Builder,
    CopyableBuilder<Builder, ListMultipartUploadsResponse> {
        public Builder bucket(String var1);

        public Builder keyMarker(String var1);

        public Builder uploadIdMarker(String var1);

        public Builder nextKeyMarker(String var1);

        public Builder prefix(String var1);

        public Builder delimiter(String var1);

        public Builder nextUploadIdMarker(String var1);

        public Builder maxUploads(Integer var1);

        public Builder isTruncated(Boolean var1);

        public Builder uploads(Collection<MultipartUpload> var1);

        public Builder uploads(MultipartUpload ... var1);

        public Builder commonPrefixes(Collection<CommonPrefix> var1);

        public Builder commonPrefixes(CommonPrefix ... var1);

        public Builder encodingType(String var1);

        public Builder encodingType(EncodingType var1);
    }
}

