/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.s3.model.VersioningConfiguration;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutBucketVersioningRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, PutBucketVersioningRequest> {
    private final String bucket;
    private final String contentMD5;
    private final String mfa;
    private final VersioningConfiguration versioningConfiguration;

    private PutBucketVersioningRequest(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.contentMD5 = builder.contentMD5;
        this.mfa = builder.mfa;
        this.versioningConfiguration = builder.versioningConfiguration;
    }

    public String bucket() {
        return this.bucket;
    }

    public String contentMD5() {
        return this.contentMD5;
    }

    public String mfa() {
        return this.mfa;
    }

    public VersioningConfiguration versioningConfiguration() {
        return this.versioningConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentMD5());
        hashCode = 31 * hashCode + Objects.hashCode(this.mfa());
        hashCode = 31 * hashCode + Objects.hashCode(this.versioningConfiguration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutBucketVersioningRequest)) {
            return false;
        }
        PutBucketVersioningRequest other = (PutBucketVersioningRequest)((Object)obj);
        return Objects.equals(this.bucket(), other.bucket()) && Objects.equals(this.contentMD5(), other.contentMD5()) && Objects.equals(this.mfa(), other.mfa()) && Objects.equals(this.versioningConfiguration(), other.versioningConfiguration());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.bucket() != null) {
            sb.append("Bucket: ").append(this.bucket()).append(",");
        }
        if (this.contentMD5() != null) {
            sb.append("ContentMD5: ").append(this.contentMD5()).append(",");
        }
        if (this.mfa() != null) {
            sb.append("MFA: ").append(this.mfa()).append(",");
        }
        if (this.versioningConfiguration() != null) {
            sb.append("VersioningConfiguration: ").append(this.versioningConfiguration()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Bucket": {
                return Optional.of(clazz.cast(this.bucket()));
            }
            case "ContentMD5": {
                return Optional.of(clazz.cast(this.contentMD5()));
            }
            case "MFA": {
                return Optional.of(clazz.cast(this.mfa()));
            }
            case "VersioningConfiguration": {
                return Optional.of(clazz.cast(this.versioningConfiguration()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String bucket;
        private String contentMD5;
        private String mfa;
        private VersioningConfiguration versioningConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(PutBucketVersioningRequest model) {
            this.bucket(model.bucket);
            this.contentMD5(model.contentMD5);
            this.mfa(model.mfa);
            this.versioningConfiguration(model.versioningConfiguration);
        }

        public final String getBucket() {
            return this.bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getContentMD5() {
            return this.contentMD5;
        }

        @Override
        public final Builder contentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
            return this;
        }

        public final void setContentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
        }

        public final String getMFA() {
            return this.mfa;
        }

        @Override
        public final Builder mfa(String mfa) {
            this.mfa = mfa;
            return this;
        }

        public final void setMFA(String mfa) {
            this.mfa = mfa;
        }

        public final VersioningConfiguration.Builder getVersioningConfiguration() {
            return this.versioningConfiguration != null ? this.versioningConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder versioningConfiguration(VersioningConfiguration versioningConfiguration) {
            this.versioningConfiguration = versioningConfiguration;
            return this;
        }

        public final void setVersioningConfiguration(VersioningConfiguration.BuilderImpl versioningConfiguration) {
            this.versioningConfiguration = versioningConfiguration != null ? versioningConfiguration.build() : null;
        }

        public PutBucketVersioningRequest build() {
            return new PutBucketVersioningRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PutBucketVersioningRequest> {
        public Builder bucket(String var1);

        public Builder contentMD5(String var1);

        public Builder mfa(String var1);

        public Builder versioningConfiguration(VersioningConfiguration var1);

        default public Builder versioningConfiguration(Consumer<VersioningConfiguration.Builder> versioningConfiguration) {
            return this.versioningConfiguration((VersioningConfiguration)((VersioningConfiguration.Builder)VersioningConfiguration.builder().apply(versioningConfiguration)).build());
        }
    }
}

