/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.s3.model.AnalyticsConfiguration;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutBucketAnalyticsConfigurationRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, PutBucketAnalyticsConfigurationRequest> {
    private final String bucket;
    private final String id;
    private final AnalyticsConfiguration analyticsConfiguration;

    private PutBucketAnalyticsConfigurationRequest(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.id = builder.id;
        this.analyticsConfiguration = builder.analyticsConfiguration;
    }

    public String bucket() {
        return this.bucket;
    }

    public String id() {
        return this.id;
    }

    public AnalyticsConfiguration analyticsConfiguration() {
        return this.analyticsConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.analyticsConfiguration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutBucketAnalyticsConfigurationRequest)) {
            return false;
        }
        PutBucketAnalyticsConfigurationRequest other = (PutBucketAnalyticsConfigurationRequest)((Object)obj);
        return Objects.equals(this.bucket(), other.bucket()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.analyticsConfiguration(), other.analyticsConfiguration());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.bucket() != null) {
            sb.append("Bucket: ").append(this.bucket()).append(",");
        }
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.analyticsConfiguration() != null) {
            sb.append("AnalyticsConfiguration: ").append(this.analyticsConfiguration()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Bucket": {
                return Optional.of(clazz.cast(this.bucket()));
            }
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "AnalyticsConfiguration": {
                return Optional.of(clazz.cast(this.analyticsConfiguration()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String bucket;
        private String id;
        private AnalyticsConfiguration analyticsConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(PutBucketAnalyticsConfigurationRequest model) {
            this.bucket(model.bucket);
            this.id(model.id);
            this.analyticsConfiguration(model.analyticsConfiguration);
        }

        public final String getBucket() {
            return this.bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final AnalyticsConfiguration.Builder getAnalyticsConfiguration() {
            return this.analyticsConfiguration != null ? this.analyticsConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder analyticsConfiguration(AnalyticsConfiguration analyticsConfiguration) {
            this.analyticsConfiguration = analyticsConfiguration;
            return this;
        }

        public final void setAnalyticsConfiguration(AnalyticsConfiguration.BuilderImpl analyticsConfiguration) {
            this.analyticsConfiguration = analyticsConfiguration != null ? analyticsConfiguration.build() : null;
        }

        public PutBucketAnalyticsConfigurationRequest build() {
            return new PutBucketAnalyticsConfigurationRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PutBucketAnalyticsConfigurationRequest> {
        public Builder bucket(String var1);

        public Builder id(String var1);

        public Builder analyticsConfiguration(AnalyticsConfiguration var1);

        default public Builder analyticsConfiguration(Consumer<AnalyticsConfiguration.Builder> analyticsConfiguration) {
            return this.analyticsConfiguration((AnalyticsConfiguration)((AnalyticsConfiguration.Builder)AnalyticsConfiguration.builder().apply(analyticsConfiguration)).build());
        }
    }
}

