/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Part
implements ToCopyableBuilder<Builder, Part> {
    private final Integer partNumber;
    private final Instant lastModified;
    private final String eTag;
    private final Long size;

    private Part(BuilderImpl builder) {
        this.partNumber = builder.partNumber;
        this.lastModified = builder.lastModified;
        this.eTag = builder.eTag;
        this.size = builder.size;
    }

    public Integer partNumber() {
        return this.partNumber;
    }

    public Instant lastModified() {
        return this.lastModified;
    }

    public String eTag() {
        return this.eTag;
    }

    public Long size() {
        return this.size;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.partNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModified());
        hashCode = 31 * hashCode + Objects.hashCode(this.eTag());
        hashCode = 31 * hashCode + Objects.hashCode(this.size());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Part)) {
            return false;
        }
        Part other = (Part)obj;
        return Objects.equals(this.partNumber(), other.partNumber()) && Objects.equals(this.lastModified(), other.lastModified()) && Objects.equals(this.eTag(), other.eTag()) && Objects.equals(this.size(), other.size());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.partNumber() != null) {
            sb.append("PartNumber: ").append(this.partNumber()).append(",");
        }
        if (this.lastModified() != null) {
            sb.append("LastModified: ").append(this.lastModified()).append(",");
        }
        if (this.eTag() != null) {
            sb.append("ETag: ").append(this.eTag()).append(",");
        }
        if (this.size() != null) {
            sb.append("Size: ").append(this.size()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PartNumber": {
                return Optional.of(clazz.cast(this.partNumber()));
            }
            case "LastModified": {
                return Optional.of(clazz.cast(this.lastModified()));
            }
            case "ETag": {
                return Optional.of(clazz.cast(this.eTag()));
            }
            case "Size": {
                return Optional.of(clazz.cast(this.size()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Integer partNumber;
        private Instant lastModified;
        private String eTag;
        private Long size;

        private BuilderImpl() {
        }

        private BuilderImpl(Part model) {
            this.partNumber(model.partNumber);
            this.lastModified(model.lastModified);
            this.eTag(model.eTag);
            this.size(model.size);
        }

        public final Integer getPartNumber() {
            return this.partNumber;
        }

        @Override
        public final Builder partNumber(Integer partNumber) {
            this.partNumber = partNumber;
            return this;
        }

        public final void setPartNumber(Integer partNumber) {
            this.partNumber = partNumber;
        }

        public final Instant getLastModified() {
            return this.lastModified;
        }

        @Override
        public final Builder lastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final void setLastModified(Instant lastModified) {
            this.lastModified = lastModified;
        }

        public final String getETag() {
            return this.eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        public final Long getSize() {
            return this.size;
        }

        @Override
        public final Builder size(Long size) {
            this.size = size;
            return this;
        }

        public final void setSize(Long size) {
            this.size = size;
        }

        public Part build() {
            return new Part(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Part> {
        public Builder partNumber(Integer var1);

        public Builder lastModified(Instant var1);

        public Builder eTag(String var1);

        public Builder size(Long var1);
    }
}

