/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.s3.model.Tier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GlacierJobParameters
implements ToCopyableBuilder<Builder, GlacierJobParameters> {
    private final String tier;

    private GlacierJobParameters(BuilderImpl builder) {
        this.tier = builder.tier;
    }

    public Tier tier() {
        return Tier.fromValue(this.tier);
    }

    public String tierString() {
        return this.tier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tierString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GlacierJobParameters)) {
            return false;
        }
        GlacierJobParameters other = (GlacierJobParameters)obj;
        return Objects.equals(this.tierString(), other.tierString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.tierString() != null) {
            sb.append("Tier: ").append(this.tierString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Tier": {
                return Optional.of(clazz.cast(this.tierString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String tier;

        private BuilderImpl() {
        }

        private BuilderImpl(GlacierJobParameters model) {
            this.tier(model.tier);
        }

        public final String getTier() {
            return this.tier;
        }

        @Override
        public final Builder tier(String tier) {
            this.tier = tier;
            return this;
        }

        @Override
        public final Builder tier(Tier tier) {
            this.tier(tier.toString());
            return this;
        }

        public final void setTier(String tier) {
            this.tier = tier;
        }

        public GlacierJobParameters build() {
            return new GlacierJobParameters(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GlacierJobParameters> {
        public Builder tier(String var1);

        public Builder tier(Tier var1);
    }
}

