/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.RestoreRequest;
import software.amazon.awssdk.services.s3.transform.GlacierJobParametersUnmarshaller;

public class RestoreRequestUnmarshaller
implements Unmarshaller<RestoreRequest, StaxUnmarshallerContext> {
    private static final RestoreRequestUnmarshaller INSTANCE = new RestoreRequestUnmarshaller();

    public RestoreRequest unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        RestoreRequest.Builder restoreRequest = RestoreRequest.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Days", targetDepth)) {
                    restoreRequest.days(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("GlacierJobParameters", targetDepth)) continue;
                restoreRequest.glacierJobParameters(GlacierJobParametersUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (RestoreRequest)restoreRequest.build();
    }

    public static RestoreRequestUnmarshaller getInstance() {
        return INSTANCE;
    }
}

