/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Optional;
import software.amazon.awssdk.services.s3.model.AnalyticsExportDestination;
import software.amazon.awssdk.services.s3.model.StorageClassAnalysisSchemaVersion;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StorageClassAnalysisDataExport
implements ToCopyableBuilder<Builder, StorageClassAnalysisDataExport> {
    private final String outputSchemaVersion;
    private final AnalyticsExportDestination destination;

    private StorageClassAnalysisDataExport(BuilderImpl builder) {
        this.outputSchemaVersion = builder.outputSchemaVersion;
        this.destination = builder.destination;
    }

    public StorageClassAnalysisSchemaVersion outputSchemaVersion() {
        return StorageClassAnalysisSchemaVersion.fromValue(this.outputSchemaVersion);
    }

    public String outputSchemaVersionString() {
        return this.outputSchemaVersion;
    }

    public AnalyticsExportDestination destination() {
        return this.destination;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.outputSchemaVersionString() == null ? 0 : this.outputSchemaVersionString().hashCode());
        hashCode = 31 * hashCode + (this.destination() == null ? 0 : this.destination().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StorageClassAnalysisDataExport)) {
            return false;
        }
        StorageClassAnalysisDataExport other = (StorageClassAnalysisDataExport)obj;
        if (other.outputSchemaVersionString() == null ^ this.outputSchemaVersionString() == null) {
            return false;
        }
        if (other.outputSchemaVersionString() != null && !other.outputSchemaVersionString().equals(this.outputSchemaVersionString())) {
            return false;
        }
        if (other.destination() == null ^ this.destination() == null) {
            return false;
        }
        return other.destination() == null || other.destination().equals(this.destination());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.outputSchemaVersionString() != null) {
            sb.append("OutputSchemaVersion: ").append(this.outputSchemaVersionString()).append(",");
        }
        if (this.destination() != null) {
            sb.append("Destination: ").append(this.destination()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OutputSchemaVersion": {
                return Optional.of(clazz.cast(this.outputSchemaVersionString()));
            }
            case "Destination": {
                return Optional.of(clazz.cast(this.destination()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String outputSchemaVersion;
        private AnalyticsExportDestination destination;

        private BuilderImpl() {
        }

        private BuilderImpl(StorageClassAnalysisDataExport model) {
            this.outputSchemaVersion(model.outputSchemaVersion);
            this.destination(model.destination);
        }

        public final String getOutputSchemaVersion() {
            return this.outputSchemaVersion;
        }

        @Override
        public final Builder outputSchemaVersion(String outputSchemaVersion) {
            this.outputSchemaVersion = outputSchemaVersion;
            return this;
        }

        @Override
        public final Builder outputSchemaVersion(StorageClassAnalysisSchemaVersion outputSchemaVersion) {
            this.outputSchemaVersion(outputSchemaVersion.toString());
            return this;
        }

        public final void setOutputSchemaVersion(String outputSchemaVersion) {
            this.outputSchemaVersion = outputSchemaVersion;
        }

        public final AnalyticsExportDestination.Builder getDestination() {
            return this.destination != null ? this.destination.toBuilder() : null;
        }

        @Override
        public final Builder destination(AnalyticsExportDestination destination) {
            this.destination = destination;
            return this;
        }

        public final void setDestination(AnalyticsExportDestination.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        public StorageClassAnalysisDataExport build() {
            return new StorageClassAnalysisDataExport(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StorageClassAnalysisDataExport> {
        public Builder outputSchemaVersion(String var1);

        public Builder outputSchemaVersion(StorageClassAnalysisSchemaVersion var1);

        public Builder destination(AnalyticsExportDestination var1);
    }
}

