/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.PathMarshallers;
import software.amazon.awssdk.services.s3.model.MetricsAndOperator;
import software.amazon.awssdk.services.s3.model.MetricsConfiguration;
import software.amazon.awssdk.services.s3.model.MetricsFilter;
import software.amazon.awssdk.services.s3.model.PutBucketMetricsConfigurationRequest;
import software.amazon.awssdk.services.s3.model.Tag;
import software.amazon.awssdk.util.Md5Utils;
import software.amazon.awssdk.util.StringInputStream;
import software.amazon.awssdk.util.StringUtils;
import software.amazon.awssdk.util.UriResourcePathUtils;
import software.amazon.awssdk.util.XmlWriter;

public class PutBucketMetricsConfigurationRequestMarshaller
implements Marshaller<Request<PutBucketMetricsConfigurationRequest>, PutBucketMetricsConfigurationRequest> {
    public Request<PutBucketMetricsConfigurationRequest> marshall(PutBucketMetricsConfigurationRequest putBucketMetricsConfigurationRequest) {
        if (putBucketMetricsConfigurationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putBucketMetricsConfigurationRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.PUT);
        String uriResourcePath = "/{Bucket}?metrics";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParamtersToRequest((Request)request, (String)uriResourcePath);
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", putBucketMetricsConfigurationRequest.bucket());
        request.setResourcePath(uriResourcePath);
        if (putBucketMetricsConfigurationRequest.id() != null) {
            request.addParameter("id", StringUtils.fromString((String)putBucketMetricsConfigurationRequest.id()));
        }
        try {
            StringWriter stringWriter = null;
            MetricsConfiguration metricsConfiguration = putBucketMetricsConfigurationRequest.metricsConfiguration();
            if (metricsConfiguration != null) {
                MetricsFilter filter;
                stringWriter = new StringWriter();
                XmlWriter xmlWriter = new XmlWriter((Writer)stringWriter, "http://s3.amazonaws.com/doc/2006-03-01/");
                xmlWriter.startElement("MetricsConfiguration");
                if (metricsConfiguration.id() != null) {
                    xmlWriter.startElement("Id").value(metricsConfiguration.id()).endElement();
                }
                if ((filter = metricsConfiguration.filter()) != null) {
                    MetricsAndOperator and;
                    Tag tag;
                    xmlWriter.startElement("Filter");
                    if (filter.prefix() != null) {
                        xmlWriter.startElement("Prefix").value(filter.prefix()).endElement();
                    }
                    if ((tag = filter.tag()) != null) {
                        xmlWriter.startElement("Tag");
                        if (tag.key() != null) {
                            xmlWriter.startElement("Key").value(tag.key()).endElement();
                        }
                        if (tag.value() != null) {
                            xmlWriter.startElement("Value").value(tag.value()).endElement();
                        }
                        xmlWriter.endElement();
                    }
                    if ((and = filter.and()) != null) {
                        List<Tag> metricsAndOperatorTagsList;
                        xmlWriter.startElement("And");
                        if (and.prefix() != null) {
                            xmlWriter.startElement("Prefix").value(and.prefix()).endElement();
                        }
                        if ((metricsAndOperatorTagsList = and.tags()) != null) {
                            for (Tag metricsAndOperatorTagsListValue : metricsAndOperatorTagsList) {
                                xmlWriter.startElement("Tag");
                                if (metricsAndOperatorTagsListValue.key() != null) {
                                    xmlWriter.startElement("Key").value(metricsAndOperatorTagsListValue.key()).endElement();
                                }
                                if (metricsAndOperatorTagsListValue.value() != null) {
                                    xmlWriter.startElement("Value").value(metricsAndOperatorTagsListValue.value()).endElement();
                                }
                                xmlWriter.endElement();
                            }
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }
            if (stringWriter != null) {
                if (!request.getHeaders().containsKey("Content-MD5")) {
                    request.addHeader("Content-MD5", Md5Utils.md5AsBase64((byte[])stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8)));
                }
                request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
                request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            }
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

