/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.PathMarshallers;
import software.amazon.awssdk.services.s3.model.ListObjectsRequest;
import software.amazon.awssdk.util.StringUtils;

public class ListObjectsRequestMarshaller
implements Marshaller<Request<ListObjectsRequest>, ListObjectsRequest> {
    public Request<ListObjectsRequest> marshall(ListObjectsRequest listObjectsRequest) {
        if (listObjectsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listObjectsRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.GET);
        if (listObjectsRequest.requestPayer() != null) {
            request.addHeader("x-amz-request-payer", StringUtils.fromString((String)listObjectsRequest.requestPayer()));
        }
        String uriResourcePath = "/{Bucket}";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", listObjectsRequest.bucket());
        request.setResourcePath(uriResourcePath);
        if (listObjectsRequest.delimiter() != null) {
            request.addParameter("delimiter", StringUtils.fromString((String)listObjectsRequest.delimiter()));
        }
        if (listObjectsRequest.encodingType() != null) {
            request.addParameter("encoding-type", StringUtils.fromString((String)listObjectsRequest.encodingType()));
        }
        if (listObjectsRequest.marker() != null) {
            request.addParameter("marker", StringUtils.fromString((String)listObjectsRequest.marker()));
        }
        if (listObjectsRequest.maxKeys() != null) {
            request.addParameter("max-keys", StringUtils.fromInteger((Integer)listObjectsRequest.maxKeys()));
        }
        if (listObjectsRequest.prefix() != null) {
            request.addParameter("prefix", StringUtils.fromString((String)listObjectsRequest.prefix()));
        }
        return request;
    }
}

