/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.PathMarshallers;
import software.amazon.awssdk.services.s3.model.DeleteBucketInventoryConfigurationRequest;
import software.amazon.awssdk.util.StringUtils;
import software.amazon.awssdk.util.UriResourcePathUtils;

public class DeleteBucketInventoryConfigurationRequestMarshaller
implements Marshaller<Request<DeleteBucketInventoryConfigurationRequest>, DeleteBucketInventoryConfigurationRequest> {
    public Request<DeleteBucketInventoryConfigurationRequest> marshall(DeleteBucketInventoryConfigurationRequest deleteBucketInventoryConfigurationRequest) {
        if (deleteBucketInventoryConfigurationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteBucketInventoryConfigurationRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.DELETE);
        String uriResourcePath = "/{Bucket}?inventory";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParamtersToRequest((Request)request, (String)uriResourcePath);
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", deleteBucketInventoryConfigurationRequest.bucket());
        request.setResourcePath(uriResourcePath);
        if (deleteBucketInventoryConfigurationRequest.id() != null) {
            request.addParameter("id", StringUtils.fromString((String)deleteBucketInventoryConfigurationRequest.id()));
        }
        return request;
    }
}

